function [pwaves, rpeaks] = make_comb(pwaves, rpeaks)

    if ~isempty(pwaves) && ~isempty(rpeaks)
      rpeaks = rpeaks(rpeaks>pwaves(1));

      if ~isempty(rpeaks)
          pwaves = pwaves(find(pwaves > rpeaks(1),1) - 1 : end);

          if ~isempty(pwaves)
              % handles the right side (last point is r-peak,point before that is p-wave)
              rpeaks = rpeaks(  setdiff(1:length(rpeaks),   find(rpeaks > pwaves(end))+1 )    );
              pwaves = pwaves(pwaves<rpeaks(end));

              % find only pairs of type : p-wave -> r-peak (the rest is not good: p-wave->p-wave, and r-peak->r-peak)
              pwaves = [pwaves, ones(length(pwaves),1)];    % 1's
              rpeaks = [rpeaks, 2*ones(length(rpeaks),1)];  % 2's
              comb = [pwaves; rpeaks];
              comb = sortrows(comb,1);
              comb = [comb(comb(1:end-1,2)==1 & comb(2:end,2) == 2,1)  comb(find(comb(1:end-1,2)==1 & comb(2:end,2) == 2)+1,1) ]; % [pwave rpeak]
              % now we have exactly: [1,2; ... ;1,2]
              pwaves = comb(:,1);
              rpeaks = comb(:,2);
          else
              pwaves = [];
              rpeaks = [];  
          end
      else
        pwaves = [];
        rpeaks = [];
      end
    else
        pwaves = [];
        rpeaks = [];
    end