function [X, list_features] = load_phy2020_strip_sub_NOste(leads, res_lead)
%wave_features, invT_leads, rmse_linfit_Twave_leads
% generate general physionet2020 ecg features
    chunk_ids = 1;
    phase = 2;
    
	% wave features:
    P2R_wavedet             = NaN*zeros(length(chunk_ids),2); 
    P1R_wavedet             = NaN*zeros(length(chunk_ids),2);
    P1R_wavedet_details     = cell(length(chunk_ids),2); 
    P1Q_wavedet             = NaN*zeros(length(chunk_ids),2); 
    P1Q_wavedet_details     = cell(length(chunk_ids),2); 
    P3R_wavedet             = NaN*zeros(length(chunk_ids),2); 
    P3R_wavedet_details     = cell(length(chunk_ids),2); 
    QS_wavedet              = NaN*zeros(length(chunk_ids),2); 
    QS_wavedet_details      = cell(length(chunk_ids),2);
    QT_wavedet              = NaN*zeros(length(chunk_ids),2); 
    QT_wavedet_details      = cell(length(chunk_ids),2); 
    QTc_wavedet             = NaN*zeros(length(chunk_ids),2); 
    QTc_wavedet_details     = cell(length(chunk_ids),2); 
    T3P1_wavedet            = NaN*zeros(length(chunk_ids),2); 
    T3P1_wavedet_details    = cell(length(chunk_ids),2); 
    dy_QR_wavedet           = NaN*zeros(length(chunk_ids),4); 
    dy_QR_RS_wavedet        = NaN*zeros(length(chunk_ids),1);
    dy_QRS_span_wavedet     = NaN*zeros(length(chunk_ids),2); 
    dy_PQ_wavedet           = NaN*zeros(length(chunk_ids),2); 
    HR_gqrs                 = NaN*zeros(length(chunk_ids),2); 
    HR_std_gqrs             = NaN*zeros(length(chunk_ids),2); 
    invT_leads              = NaN(length(chunk_ids),2*12); 
    rmse_linfit_Twave_leads = NaN(length(chunk_ids),2*12); 
    %
    QRS_all_BIG = cell(size(chunk_ids,1),1);
    for i = 1:size(chunk_ids,1) % make QRS_all_BIG
        QRS_all_BIG{i,1} = [];
        myloc = 1;
        if ~isempty(res_lead{1}{myloc,1}.QRS_all_BIG)
            QRS_all_BIG{i,1} = [res_lead{1}{myloc,1}.QRS_all_BIG(:,1); res_lead{1}{myloc,1}.QRS_all_BIG(end,2)];
        end
    end
    
    for m = 1:length(chunk_ids)

        myloc = 1;
        
        for use_lead = 2:-1:1
            res_ = res_lead{use_lead};
            mult = 1; 

            if ~isempty(res_{myloc,1}.QRS_all_BIG)
                HR_gqrs(m,use_lead) = 60*(250/median(res_{myloc,1}.QRS_all_BIG(:,2)-res_{myloc,1}.QRS_all_BIG(:,1)));
                HR_std_gqrs(m,use_lead) = std(60*(250./(res_{myloc,1}.QRS_all_BIG(:,2)-res_{myloc,1}.QRS_all_BIG(:,1))));
            end

            dy_PQ = []; % via wavedet
            if ~isempty(res_{myloc,1}.waves_wavedet) && ~isempty(res_{myloc,1}.waves_wavedet.Pon) && ~isempty(res_{myloc,1}.waves_wavedet.Poff) && ~isempty(res_{myloc,1}.waves_wavedet.QRSon) && ~isempty(res_{myloc,1}.QRS_all_BIG)
                for jj=1:size(res_{myloc,1}.QRS_all_BIG,1)
                    P1 = res_{myloc,1}.waves_wavedet.Pon(res_{myloc,1}.waves_wavedet.Pon > res_{myloc,1}.QRS_all_BIG(jj,1) & res_{myloc,1}.waves_wavedet.Pon < res_{myloc,1}.QRS_all_BIG(jj,2));
                    P3 = res_{myloc,1}.waves_wavedet.Poff(res_{myloc,1}.waves_wavedet.Poff > res_{myloc,1}.QRS_all_BIG(jj,1) & res_{myloc,1}.waves_wavedet.Poff < res_{myloc,1}.QRS_all_BIG(jj,2));
                    Q = res_{myloc,1}.waves_wavedet.QRSon(res_{myloc,1}.waves_wavedet.QRSon > res_{myloc,1}.QRS_all_BIG(jj,1) & res_{myloc,1}.waves_wavedet.QRSon < res_{myloc,1}.QRS_all_BIG(jj,2));
                    try
                        dy_PQ = [dy_PQ; min(leads(P1(1),use_lead)-leads(Q(1),use_lead) , leads(P3(1),use_lead)-leads(Q(1),use_lead))]; 
                    catch
                        dy_PQ = [dy_PQ; nan]; 
                    end
                end
                if length(dy_PQ(~isnan(dy_PQ))) >= 3
                    dy_PQ_wavedet(m,use_lead) = mult*median(dy_PQ(~isnan(dy_PQ)));
                end
            end
           
            
            QT = []; % via wavedet
            QTc = []; % via wavedet
            if ~isempty(res_{myloc,1}.waves_wavedet) && ~isempty(res_{myloc,1}.waves_wavedet.QRSon) && ~isempty(res_{myloc,1}.waves_wavedet.Toff) && ~isempty(res_{myloc,1}.QRS_all_BIG)
                for jj=1:size(res_{myloc, 1}.QRS_all_BIG,1)-1 % note the "-1"
                    Q = res_{myloc, 1}.waves_wavedet.QRSon(res_{myloc, 1}.waves_wavedet.QRSon > res_{myloc, 1}.QRS_all_BIG(jj,1) & res_{myloc, 1}.waves_wavedet.QRSon < res_{myloc, 1}.QRS_all_BIG(jj,2));
                    T3 = res_{myloc, 1}.waves_wavedet.Toff(res_{myloc, 1}.waves_wavedet.Toff > res_{myloc, 1}.QRS_all_BIG(jj+1,1) & res_{myloc, 1}.waves_wavedet.Toff < res_{myloc, 1}.QRS_all_BIG(jj+1,2));
                    R     = res_{myloc,1}.QRS_all_BIG(jj,2);
                    Rnext = res_{myloc,1}.QRS_all_BIG(jj+1,2);
                    try
                        QT = [QT; T3(1)-Q(1)];
                        QTc = [QTc; (4*(T3(1)-Q(1)))/sqrt(4*(Rnext-R))]; % 4*(...) - so as to have milliseconds
                    catch
                        QT = [QT; nan];
                        QTc = [QTc; nan];
                    end
                end
                if length(QT(~isnan(QT))) >= 3
                   	QT_wavedet(m,use_lead) = median(QT(~isnan(QT)));
                end
                QT_wavedet_details{m,use_lead} = QT;
                if length(QTc(~isnan(QTc))) >= 3
                   	QTc_wavedet(m,use_lead) = median(QTc(~isnan(QTc)));
                end
                QTc_wavedet_details{m,use_lead} = QTc;
            end
            
            
            P2R = [];
            if ~isempty(res_{myloc,1}.waves_wavedet) && ~isempty(res_{myloc,1}.waves_wavedet.P) && ~isempty(res_{myloc,1}.QRS_all_BIG)
                for jj=2:size(res_{myloc,1}.QRS_all_BIG,1)
                    P2 = res_{myloc,1}.waves_wavedet.P(res_{myloc,1}.waves_wavedet.P > res_{myloc,1}.QRS_all_BIG(jj,1) & res_{myloc,1}.waves_wavedet.P < res_{myloc,1}.QRS_all_BIG(jj,2));
                    R = res_{myloc,1}.QRS_all_BIG(jj,2);
                    try P2R = [P2R; R(1)-P2(1)]; catch P2R = [P2R; nan]; end
                end
                if length(P2R(~isnan(P2R))) >= 3
                    P2R_wavedet(m,use_lead) = mult*median(P2R(~isnan(P2R)));
                end
            end

            P1R = [];
            if ~isempty(res_{myloc,1}.waves_wavedet) && ~isempty(res_{myloc,1}.waves_wavedet.Pon) && ~isempty(res_{myloc,1}.QRS_all_BIG)
                for jj=2:size(res_{myloc,1}.QRS_all_BIG,1)
                    P1 = res_{myloc,1}.waves_wavedet.Pon(res_{myloc,1}.waves_wavedet.Pon > res_{myloc,1}.QRS_all_BIG(jj,1) & res_{myloc,1}.waves_wavedet.Pon < res_{myloc,1}.QRS_all_BIG(jj,2));
                    R = res_{myloc,1}.QRS_all_BIG(jj,2);
                    try P1R = [P1R; R(1)-P1(1)]; catch P1R = [P1R; nan]; end
                end
                if length(P1R(~isnan(P1R))) >= 3
                    P1R_wavedet(m,use_lead) = mult*median(P1R(~isnan(P1R)));
                end
                P1R_wavedet_details{m,use_lead} = P1R;
            end
            
            P1Q = [];
            if ~isempty(res_{myloc,1}.waves_wavedet) && ~isempty(res_{myloc,1}.waves_wavedet.Pon) && ~isempty(res_{myloc,1}.waves_wavedet.QRSon) && ~isempty(res_{myloc,1}.QRS_all_BIG)
                for jj=1:size(res_{myloc,1}.QRS_all_BIG,1)
                    P1 = res_{myloc,1}.waves_wavedet.Pon(res_{myloc,1}.waves_wavedet.Pon > res_{myloc,1}.QRS_all_BIG(jj,1) & res_{myloc,1}.waves_wavedet.Pon < res_{myloc,1}.QRS_all_BIG(jj,2));
                    Q = res_{myloc,1}.waves_wavedet.QRSon(res_{myloc,1}.waves_wavedet.QRSon > res_{myloc,1}.QRS_all_BIG(jj,1) & res_{myloc,1}.waves_wavedet.QRSon < res_{myloc,1}.QRS_all_BIG(jj,2));
                    try Q=Q(1); P1Q = [P1Q; Q(1)-P1(1)]; catch P1Q = [P1Q; nan]; end
                end
                if length(P1Q(~isnan(P1Q))) >= 3
                    P1Q_wavedet(m,use_lead) = mult*median(P1Q(~isnan(P1Q)));
                end
                P1Q_wavedet_details{m,use_lead} = P1Q;
            end

            P3R = [];
            if ~isempty(res_{myloc, 1}.waves_wavedet) && ~isempty(res_{myloc,1}.waves_wavedet.Poff) && ~isempty(res_{myloc,1}.QRS_all_BIG)
                for jj=1:size(res_{myloc, 1}.QRS_all_BIG,1)
                    P3 = res_{myloc, 1}.waves_wavedet.Poff(res_{myloc, 1}.waves_wavedet.Poff > res_{myloc, 1}.QRS_all_BIG(jj,1) & res_{myloc, 1}.waves_wavedet.Poff < res_{myloc, 1}.QRS_all_BIG(jj,2));
                    R = res_{myloc,1}.QRS_all_BIG(jj,2);
                    try
                        P3R = [P3R; R(1)-P3(1)];
                    catch
                        P3R = [P3R; nan];
                    end
                end
                if length(P3R(~isnan(P3R))) >= 3
                    P3R_wavedet(m,use_lead) = mult*median(P3R(~isnan(P3R)));
                end
                P3R_wavedet_details{m,use_lead} = P3R;
            end

            QS = [];
            if ~isempty(res_{myloc,1}.waves_wavedet) && ~isempty(res_{myloc,1}.waves_wavedet.QRSon) && ~isempty(res_{myloc,1}.waves_wavedet.QRSoff) && ~isempty(res_{myloc,1}.QRS_all_BIG)
                for jj=1:size(res_{myloc, 1}.QRS_all_BIG,1)-1 % note the "-1"
                    Q = res_{myloc, 1}.waves_wavedet.QRSon(res_{myloc, 1}.waves_wavedet.QRSon > res_{myloc, 1}.QRS_all_BIG(jj,1) & res_{myloc, 1}.waves_wavedet.QRSon < res_{myloc, 1}.QRS_all_BIG(jj,2));
                    S = res_{myloc, 1}.waves_wavedet.QRSoff(res_{myloc, 1}.waves_wavedet.QRSoff > res_{myloc, 1}.QRS_all_BIG(jj+1,1) & res_{myloc, 1}.waves_wavedet.QRSoff < res_{myloc, 1}.QRS_all_BIG(jj+1,2));
                    try
                        QS = [QS; S(1)-Q(1)];
                    catch
                        QS = [QS; nan];
                    end
                end
                if length(QS(~isnan(QS))) >= 3
                   	QS_wavedet(m,use_lead) = median(QS(~isnan(QS)));
                end
                QS_wavedet_details{m,use_lead} = QS;
            end

            T3P1 = []; % via wavedet
            if ~isempty(res_{myloc, 1}.waves_wavedet) && ~isempty(res_{myloc,1}.waves_wavedet.Toff) && ~isempty(res_{myloc,1}.waves_wavedet.Pon) && ~isempty(res_{myloc,1}.QRS_all_BIG)
                for jj=1:size(res_{myloc, 1}.QRS_all_BIG,1)
                    T3 = res_{myloc, 1}.waves_wavedet.Toff(res_{myloc, 1}.waves_wavedet.Toff > res_{myloc, 1}.QRS_all_BIG(jj,1) & res_{myloc, 1}.waves_wavedet.Toff < res_{myloc, 1}.QRS_all_BIG(jj,2));
                    P1 = res_{myloc,1}.waves_wavedet.Pon(res_{myloc,1}.waves_wavedet.Pon > res_{myloc,1}.QRS_all_BIG(jj,1) & res_{myloc,1}.waves_wavedet.Pon < res_{myloc,1}.QRS_all_BIG(jj,2));
                    try
                        T3P1 = [T3P1; P1(1)-T3(1)];
                    catch
                        T3P1 = [T3P1; nan];
                    end
                end
                if length(T3P1(~isnan(T3P1))) >= 3
                   	T3P1_wavedet(m,use_lead) = median(T3P1(~isnan(T3P1)));
                end
                T3P1_wavedet_details{m,use_lead} = T3P1;
            end            
            
        end

        if phase == 2
            % gain = strsplit(res_{myloc,1}.header{2},' '); gain = strsplit(gain{3},'/'); gain = eval(gain{1});
            gain = 1000;
            analogue_signal = (leads-0)./gain; % (leads-baseline)./gain;  see rdsamp.m. Assumed here: baseline = 0;
        end 
        
        if use_lead == 2
            use_lead = 1;
            res_ = res_lead{use_lead};
        end
        dy_QR = []; % via wavedet
        if ~isempty(res_{myloc,1}.waves_wavedet) && ~isempty(res_{myloc,1}.waves_wavedet.QRSon) && ~isempty(res_{myloc,1}.QRS_all_BIG)
            for jj=2:size(res_{myloc,1}.QRS_all_BIG,1)
                Q = res_{myloc, 1}.waves_wavedet.QRSon(res_{myloc, 1}.waves_wavedet.QRSon > res_{myloc, 1}.QRS_all_BIG(jj,1) & res_{myloc, 1}.waves_wavedet.QRSon < res_{myloc, 1}.QRS_all_BIG(jj,2));
                R = res_{myloc,1}.QRS_all_BIG(jj,2);
                try
                    dy_QR = [dy_QR; leads(R(1),1)-leads(Q(1),1) leads(R(1),2)-leads(Q(1),2) leads(R(1),3)-leads(Q(1),3) leads(R(1),6)-leads(Q(1),6)]; % leads [1,2,3,6] using R locs from lead 1. Alternatively: sign() can be used
                catch
                    dy_QR = [dy_QR; nan(1,4)];
                end
            end
            if size(dy_QR(~isnan(dy_QR(:,1))),1) >= 3
                dy_QR_wavedet(m,1:4) = [median(dy_QR(~isnan(dy_QR(:,1)),1)) median(dy_QR(~isnan(dy_QR(:,2)),2)) median(dy_QR(~isnan(dy_QR(:,3)),3)) median(dy_QR(~isnan(dy_QR(:,4)),4))];
            end
        end
        
        dy_QR_RS = [];    % via wavedet (for RAD)
        dy_QRS_span = []; % via wavedet (for 'low qrs voltages')
        if ~isempty(res_{myloc,1}.waves_wavedet) && ~isempty(res_{myloc,1}.waves_wavedet.QRSon) && ~isempty(res_{myloc,1}.waves_wavedet.QRSoff) && ~isempty(res_{myloc,1}.QRS_all_BIG)
            for jj=1:size(res_{myloc, 1}.QRS_all_BIG,1)-1 % note the "-1"
                Q = res_{myloc, 1}.waves_wavedet.QRSon(res_{myloc, 1}.waves_wavedet.QRSon > res_{myloc, 1}.QRS_all_BIG(jj,1) & res_{myloc, 1}.waves_wavedet.QRSon < res_{myloc, 1}.QRS_all_BIG(jj,2));
                R = res_{myloc,1}.QRS_all_BIG(jj,2);
                S = res_{myloc, 1}.waves_wavedet.QRSoff(res_{myloc, 1}.waves_wavedet.QRSoff > res_{myloc, 1}.QRS_all_BIG(jj+1,1) & res_{myloc, 1}.waves_wavedet.QRSoff < res_{myloc, 1}.QRS_all_BIG(jj+1,2));
                try
                    dy_QR_RS    = [dy_QR_RS; (abs(leads(R(1),1)-leads(Q(1),1))+0.1) / (abs(leads(Q(1),1)-leads(S(1),1))+0.1)];
                    tmp =  max(analogue_signal(R(1),:) - analogue_signal(Q(1),:), analogue_signal(R(1),:) - analogue_signal(S(1),:));
                    dy_QRS_span = [dy_QRS_span; mean(tmp([1,2,3])) mean(tmp([7:12]))]; 
                catch
                    dy_QR_RS = [dy_QR_RS; nan];
                    dy_QRS_span = [dy_QRS_span; nan nan];
                end
            end
            if length(dy_QR_RS(~isnan(dy_QR_RS))) >= 3
                dy_QR_RS_wavedet(m,1) = median(dy_QR_RS(~isnan(dy_QR_RS)));
            end
            if length(dy_QRS_span(~isnan(dy_QRS_span))) >= 3
            	dy_QRS_span_wavedet(m,1:2) = [median(dy_QRS_span(~isnan(dy_QRS_span(:,1)),1)) median(dy_QRS_span(~isnan(dy_QRS_span(:,2)),2))];
            end
        end        

        if ~isempty(QRS_all_BIG{m,1})
            for use_lead = 1:2
                invT_ = NaN*zeros(1,12);
                rmse_linfit_Twave_ = NaN*zeros(1,12);
                for mylead = 1:12
                    invT = [];
                    rmse_linfit_Twave = [];
                    for jj=1:size(res_lead{use_lead}{myloc,1}.QRS_all_BIG,1)
                        T1 = res_lead{use_lead}{myloc,1}.waves_wavedet.Ton( res_lead{use_lead}{myloc,1}.waves_wavedet.Ton  > res_lead{use_lead}{myloc, 1}.QRS_all_BIG(jj,1) & res_lead{use_lead}{myloc,1}.waves_wavedet.Ton  < res_lead{use_lead}{myloc, 1}.QRS_all_BIG(jj,2));
                        T2 = res_lead{use_lead}{myloc,1}.waves_wavedet.T(   res_lead{use_lead}{myloc,1}.waves_wavedet.T    > res_lead{use_lead}{myloc, 1}.QRS_all_BIG(jj,1) & res_lead{use_lead}{myloc,1}.waves_wavedet.T    < res_lead{use_lead}{myloc, 1}.QRS_all_BIG(jj,2));
                        T3 = res_lead{use_lead}{myloc,1}.waves_wavedet.Toff(res_lead{use_lead}{myloc,1}.waves_wavedet.Toff > res_lead{use_lead}{myloc, 1}.QRS_all_BIG(jj,1) & res_lead{use_lead}{myloc,1}.waves_wavedet.Toff < res_lead{use_lead}{myloc, 1}.QRS_all_BIG(jj,2));
                        if ~isempty(T1) && ~isempty(T2) && ~isempty(T3)
                            if leads(T2(1),mylead) == min(leads([T1(1),T2(1),T3(1)],mylead))
                                invT = [invT; 1];
                            else
                                invT = [invT; 0];
                            end
                            rmse_linfit_Twave = [rmse_linfit_Twave; sqrt(sum(power([leads(T1(1),mylead);leads(T2(1),mylead);leads(T3(1),mylead)] - [1 T1(1);1 T2(1);1 T3(1)]*([1 T1(1);1 T2(1);1 T3(1)]\[leads(T1(1),mylead);leads(T2(1),mylead);leads(T3(1),mylead)]),2)))]; 
                        else
                            invT = [invT; nan];
                            rmse_linfit_Twave = [rmse_linfit_Twave; nan];
                        end
                    end
                    if length(invT(~isnan(invT))) >= 3
                        invT_(mylead) = mean(invT(~isnan(invT)));
                    end
                    if length(rmse_linfit_Twave(~isnan(rmse_linfit_Twave))) >= 3
                        rmse_linfit_Twave_(mylead) = mean(rmse_linfit_Twave(~isnan(rmse_linfit_Twave)));
                    end
                end
                invT_leads(m,(1:12) + (use_lead-1)*12) = invT_;
                rmse_linfit_Twave_leads(m,(1:12) + (use_lead-1)*12) = rmse_linfit_Twave_;
            end

        end

    end

    invT_leads_rawECG = invT_leads;
    rmse_linfit_Twave_leads_rawECG = rmse_linfit_Twave_leads;
    
    wave_features = struct;
    wave_features.P1R_wavedet         = P1R_wavedet;
    wave_features.P2R_wavedet         = P2R_wavedet;
    wave_features.P1Q_wavedet         = P1Q_wavedet;
    wave_features.P3R_wavedet         = P3R_wavedet;
    wave_features.T3P1_wavedet        = T3P1_wavedet;
    wave_features.QS_wavedet          = QS_wavedet;
    wave_features.HR_gqrs             = HR_gqrs;
    wave_features.HR_std_gqrs         = HR_std_gqrs;
    wave_features.dy_QR_wavedet       = dy_QR_wavedet;
    wave_features.dy_QR_RS_wavedet    = dy_QR_RS_wavedet;
    wave_features.dy_QRS_span_wavedet = dy_QRS_span_wavedet;
    wave_features.dy_PQ_wavedet       = dy_PQ_wavedet;
    wave_features.QT_wavedet          = QT_wavedet;
    wave_features.QTc_wavedet         = QTc_wavedet;
    
    % Make a dataset 'X' (with column names in 'list_features') for a model, using data from 'dataset_ph2'

    %case 17 % all features en bulk for phase 2 using wavedet only
    P1R_wavedet  = wave_features.P1R_wavedet; P1R_wavedet(isnan(P1R_wavedet)) = 0*mean(P1R_wavedet(~isnan(P1R_wavedet)));
    P2R_wavedet  = wave_features.P2R_wavedet; P2R_wavedet(isnan(P2R_wavedet)) = 0*mean(P2R_wavedet(~isnan(P2R_wavedet)));
    P1Q_wavedet  = wave_features.P1Q_wavedet; P1Q_wavedet(isnan(P1Q_wavedet)) = 0*mean(P1Q_wavedet(~isnan(P1Q_wavedet)));
    P3R_wavedet  = wave_features.P3R_wavedet; P3R_wavedet(isnan(P3R_wavedet)) = 0*mean(P3R_wavedet(~isnan(P3R_wavedet)));
    T3P1_wavedet = wave_features.T3P1_wavedet;T3P1_wavedet(isnan(T3P1_wavedet)) = 0*mean(T3P1_wavedet(~isnan(T3P1_wavedet)));
    QS_wavedet   = wave_features.QS_wavedet;  QS_wavedet(isnan(QS_wavedet)) = 0*mean(QS_wavedet(~isnan(QS_wavedet)));
    %
    feat_wavedet_txt = {'HR_gqrs','HR_std_gqrs'};
    for i = 1:length(feat_wavedet_txt)
        feat_wavedet = eval(['wave_features.' feat_wavedet_txt{i}]);
        feat_wavedet(isnan(feat_wavedet(:,1)),1) = feat_wavedet(isnan(feat_wavedet(:,1)),2);
        feat_wavedet(isnan(feat_wavedet(:,2)),2) = feat_wavedet(isnan(feat_wavedet(:,2)),1);
        feat_wavedet(isnan(feat_wavedet)) = 0;
        eval([feat_wavedet_txt{i} ' = feat_wavedet;'])
    end
    HR_gqrs(HR_gqrs(:,1)==0,1) = 60; HR_gqrs(HR_gqrs(:,2)==0,2) = 60;
    %
    invT_leads = invT_leads_rawECG(:,[1,7,8,11,12]);
    invT_leads(isnan(invT_leads)) = 0;
    %
    dy_QR_wavedet           = wave_features.dy_QR_wavedet; dy_QR_wavedet(isnan(dy_QR_wavedet)) = 0*mean(dy_QR_wavedet(~isnan(dy_QR_wavedet)));
    dy_QR_RS_wavedet        = wave_features.dy_QR_RS_wavedet; dy_QR_RS_wavedet(isnan(dy_QR_RS_wavedet)) = 0*mean(dy_QR_RS_wavedet(~isnan(dy_QR_RS_wavedet)));
    dy_QRS_span_wavedet     = wave_features.dy_QRS_span_wavedet; dy_QRS_span_wavedet(isnan(dy_QRS_span_wavedet)) = 0*mean(dy_QRS_span_wavedet(~isnan(dy_QRS_span_wavedet)));
    dy_PQ_wavedet           = wave_features.dy_PQ_wavedet; dy_PQ_wavedet(isnan(dy_PQ_wavedet)) = 0*mean(dy_PQ_wavedet(~isnan(dy_PQ_wavedet)));
    QTc_wavedet             = wave_features.QTc_wavedet; QTc_wavedet(isnan(QTc_wavedet)) = 0*mean(QTc_wavedet(~isnan(QTc_wavedet)));
    rmse_linfit_Twave_leads = rmse_linfit_Twave_leads_rawECG; rmse_linfit_Twave_leads(isnan(rmse_linfit_Twave_leads)) = 0*mean(rmse_linfit_Twave_leads(~isnan(rmse_linfit_Twave_leads))); 
    %
    X = [P1R_wavedet P2R_wavedet P1Q_wavedet P3R_wavedet T3P1_wavedet ...
        QS_wavedet HR_gqrs HR_std_gqrs invT_leads ...
        dy_QR_wavedet dy_QR_RS_wavedet ...
        dy_QRS_span_wavedet dy_PQ_wavedet QTc_wavedet ...
        rmse_linfit_Twave_leads];
    list_features = {'P1R_wavedet1' 'P1R_wavedet2' 'P2R_wavedet1' 'P2R_wavedet2' 'P1Q_wavedet1' 'P1Q_wavedet2' 'P3R_wavedet1' 'P3R_wavedet2' 'T3P1_wavedet1' 'T3P1_wavedet2' ...
        'QS_wavedet1' 'QS_wavedet2' 'HR_gqrs1' 'HR_gqrs2' 'HR_std_gqrs1' 'HR_std_gqrs2' 'invT_leads_L1' 'invT_leads_V1' 'invT_leads_V2' 'invT_leads_V5' 'invT_leads_V6' ...
        'dy_QR_wavedet_L1' 'dy_QR_wavedet_L2' 'dy_QR_wavedet_L3' 'dy_QR_wavedet_aVF' 'dy_QR_RS_wavedet' ...
        'dy_QRS_span_wavedet_L1L2L3' 'dy_QRS_span_wavedet_V1V2V3V4V5V6' 'dy_PQ_wavedet1' 'dy_PQ_wavedet2' 'QTc_wavedet1' 'QTc_wavedet2' ...
            'rmse_linfit_Twave_leads1'	'rmse_linfit_Twave_leads2'	'rmse_linfit_Twave_leads3'	'rmse_linfit_Twave_leads4'	'rmse_linfit_Twave_leads5' ...
            'rmse_linfit_Twave_leads6'	'rmse_linfit_Twave_leads7'	'rmse_linfit_Twave_leads8'	'rmse_linfit_Twave_leads9'	'rmse_linfit_Twave_leads10'	... 
            'rmse_linfit_Twave_leads11'	'rmse_linfit_Twave_leads12'	'rmse_linfit_Twave_leads13'	'rmse_linfit_Twave_leads14'	'rmse_linfit_Twave_leads15'	... 
            'rmse_linfit_Twave_leads16'	'rmse_linfit_Twave_leads17'	'rmse_linfit_Twave_leads18'	'rmse_linfit_Twave_leads19'	'rmse_linfit_Twave_leads20'	...
            'rmse_linfit_Twave_leads21'	'rmse_linfit_Twave_leads22'	'rmse_linfit_Twave_leads23'	'rmse_linfit_Twave_leads24'...
        };

    
   


    



