function res = global_predict_20segments_model(outtrain, leads, use_num_leads,d1,bbb,aaa,patID)

PatID_wrsamp = patID;
disp(PatID_wrsamp);

XSaug_cur = {}; 
XSaug_cur{1,8} = leads(:,1);

kk = size(leads,1);

XSaug_cur_2400 = {};
for i=1:size(XSaug_cur,1)
    if size(XSaug_cur{i,8},1) >= kk
        count = 1;
        while size(XSaug_cur{i,8},1) - count >= kk-1
            % note: the time reference in cols 1 and 2 will not be valid any more
            switch use_num_leads
                case 12
                    XSaug_cur_2400 = [XSaug_cur_2400; [XSaug_cur(i,1:7) XSaug_cur{i,8}(count:count+(kk-1)) ... 
                                                                                   XSaug_cur{i,9}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,10}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,11}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,12}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,13}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,14}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,15}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,16}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,17}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,18}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,19}(count:count+(kk-1)) ]];
                case 2
                    XSaug_cur_2400 = [XSaug_cur_2400; [XSaug_cur(i,1:7) XSaug_cur{i,8}(count:count+(kk-1)) ...
                                                                                                                   XSaug_cur{i,9}(count:count+(kk-1)) ]];
                case 1
                    XSaug_cur_2400 = [XSaug_cur_2400; [XSaug_cur(i,1:7) XSaug_cur{i,8}(count:count+(kk-1))                                            ]];
               otherwise
                   error()
            end
            count = count + kk;
        end
    end
end
clear XSaug_cur

use_wfdb_gqrs = 1; % GQRS is computed by wfdb (java) rather than gqrs.exe

do_shift_ecgpeaks = 1;

shift_peaks_done = 0;
ecg_plot_all = {};
ecg_plot_all_RRR = {};
ecg_plot_all_val = {};
ecg_plot_all_RRR_val = {};
lead = 1;
yHat_all_BIG = []; % R-R segments
yHat_all_RRR_BIG = []; % R-R-R segments
QRS_all_BIG = [];
R_YhatSVM = [];
mini_verbosity = 0;
QRS_gqrs = [];
ECG_header = [];
waves_wavedet = [];
for use_Yhat_forS2_filtfilt = 0:1
    for num_steps = 21:20:41
        eval(['yHat_all_BIG_s' num2str(num_steps) '_filtfilt' num2str(use_Yhat_forS2_filtfilt) ' = [];']);
    end
end


for i = 1:1:size(XSaug_cur_2400,1)
    %disp([num2str(i) '/' num2str(size(XSaug_cur_2400,1))])
    
    ecg = XSaug_cur_2400{i,7+lead};

    if any(ecg)==0 % tests if all ecg are zeros
        disp('skipping ecg')
    else

        skip_wavedet = 0;
        if skip_wavedet == 0
            lead_num = 1;
            Fs = 250; gain = 200; fmt = 16;
            %
            ECG_header = struct;
            ECG_header.recname = PatID_wrsamp;
            ECG_header.nsig = length(lead_num);
            ECG_header.freq = Fs;
            ECG_header.nsamp = length(ecg);
            ECG_header.btime = '00:00:00';
            ECG_header.bdate = '01/01/2000';
            ECG_header.spf = NaN;
            ECG_header.baseline = NaN;
            ECG_header.units = 'mV';
            ECG_header.fname = [PatID_wrsamp '.dat'];
            ECG_header.group = 0;
            ECG_header.fmt = fmt;
            ECG_header.gain = gain;
            ECG_header.adcres = 16;
            ECG_header.adczero = 0;
            ECG_header.initval = ecg(1);
            ECG_header.cksum = 0; % ok ???
            ECG_header.bsize = 0;
            ECG_header.desc = repmat('V1',length(lead_num));
            %
            skipme = 0; % if ==0, the R peaks from GQRS will be supplied to wavedet_3D_gn as inputs
            if skipme == 0 % supply external R detections
                if use_wfdb_gqrs == 1
                    QRS_gqrs = local_gqrs_wfdb(ecg, PatID_wrsamp);
                else % use gqrs.exe
                    QRS_gqrs = local_gqrs_exe(ecg,ECG_header);
                end
                if length(QRS_gqrs) > 2
                    if do_shift_ecgpeaks == 1
                        QRS_gqrs = shift_peaks(QRS_gqrs,ecg,ceil(prctile(diff(QRS_gqrs)*4,10)*0.04)*2+1); % 81 note:  ceil(1000*0.04)*2+1 == 81
                        QRS_gqrs = discard_fake_ecgpeaks(QRS_gqrs,ecg,[],250);
                    end
                    if length(QRS_gqrs) > 2
                        QRS_gqrs = shift_peaks(QRS_gqrs,ecg,ceil(prctile(diff(QRS_gqrs)*4,10)*0.04)*2+1); % 81
                    end
                else
                    break
                end
                shift_peaks_done = 1;
            else
                QRS_gqrs = []; % do not supply external R detections
                wavedet_config.setup.wavedet.QRS_detection_thr = 2*ones(5,1); % original is QRS_detection_thr = ones(5,1)
            end
            if isempty(QRS_gqrs)
                qrs_flag = 0; % R peaks will be computed by wavedet algo itself
            else
                qrs_flag = 1; % if ==1, the R peaks will be read from external source
            end
            wavedet_config.setup.wavedet.qrs_flag = qrs_flag;
            % run wave detection:
            waves_wavedet = wavedet_3D_gn( ecg, QRS_gqrs', ECG_header, wavedet_config); % 0.25*250*(ecg/std(ecg)
            a = fields(waves_wavedet);
            for ii = 1:length(a)
                eval(['waves_wavedet.' a{ii} ' = waves_wavedet.' a{ii} '(~isnan(waves_wavedet.' a{ii} '));'])
            end
        else
            waves_wavedet = [];
        end
        QRS = QRS_gqrs;
        if length(QRS) > 2
            if length(QRS) > 2

                for j=2:length(QRS)
                    x = 1; % manually impose that the RR interval is "approved"
                    ecg_plot_all_val = [ecg_plot_all_val; x];
                end
                
                % compute set of line segment features based on Yhat_forS2
                %         d1 = designfilt('lowpassiir','FilterOrder',2, 'HalfPowerFrequency',0.05+0.05,'DesignMethod','butter'); % amtter param -> smoother
                for use_Yhat_forS2_filtfilt = 0:1
                    for num_steps = 21:20:41
                        QRS_all_BIG = []; % will be computed 4 times... a bit of redundancy
                        yHat_all_BIG = [];
                        ecg_plot_all = {}; % will be computed 4 times... a bit of redundancy
                        yHat_all = [];
                        if use_Yhat_forS2_filtfilt == 1
                            Yhat_forS2 = filtfilt(d1,125*(ecg-mean(ecg))/std(ecg)); % filtfilt(d1,ecg); %%% figure;plot(125*(ecg-mean(ecg))/std(ecg));hold on; plot(Yhat_forS2)
                        else
                            Yhat_forS2 = ecg;
                        end
                        %xHat_all = [];
                        %steps = [0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100]/100; % in percent b/n two R peaks
                        if num_steps == 41
                            steps = (0:2.5:100)/100; % 41 step points (40 intervals) ; in percent b/n two R peaks. Default: 
                        elseif num_steps == 21
                            steps = (0:5:100)/100; % 21 step points (20 intervals)
                        end
                        for j=2:1:length(QRS) % R2->R2->R2 ... etc
                            y = Yhat_forS2(QRS(j-1):QRS(j)); % from R1 to R2
                            for s = 2:length(steps)
                                X = (floor(steps(s-1)*length(y))+1:ceil(steps(s)*length(y)))';
                                yHat = [ones(length(X),1) X]*([ones(length(X),1) X]\y(X));
                                %figure(1); plot(X+QRS(j-1) - 1,yHat,'b')
                                yHat_all = [yHat_all; yHat(1)]; % consider only the first point of the segment, so that the dots of the beginning of the slopes are connected
                                %xHat_all = [xHat_all; X(1)+QRS(j-1) - 1];
                            end
                            yHat_all = [yHat_all; yHat(end)]; % the last point has be here as well so that the last slope is computed as well
                            %xHat_all = [xHat_all; X(end)+QRS(j-1) - 1];
                            ecg_plot_all = [ecg_plot_all; ecg(QRS(j-1):QRS(j))];
                        end
                        if ~isempty(yHat_all)
                            Yhat_forISO = filtfilt(bbb, aaa, Yhat_forS2);
                            k=1;
                            for j=2:1:length(QRS)
                                diff100 = ((Yhat_forISO(QRS(j))-Yhat_forISO(QRS(j-1))) + Yhat_forS2(QRS(j-1))) - Yhat_forS2(QRS(j)); 
                                tmp = steps'*diff100;
                                yHat_all(k:k+length(steps)-1) = yHat_all(k:k+length(steps)-1) + tmp; % k+20
                                k = k + length(steps);
                            end
                            yHat_all = reshape(yHat_all,length(steps),length(yHat_all)/length(steps))'; 
                            yHat_all_BIG = [yHat_all_BIG; yHat_all];
                            QRS_all_BIG = [QRS_all_BIG; [QRS(1:end-1), QRS(2:end)]];
                        end
                        eval(['yHat_all_BIG_s' num2str(num_steps) '_filtfilt' num2str(use_Yhat_forS2_filtfilt)  ' = yHat_all_BIG;']);
                    end
                end
                
                yHat_all_RRR = [];
                Yhat_forS2 = filtfilt(d1,125*(ecg-mean(ecg))/std(ecg));
                steps = (0:5/2:100)/100;
                for j=2:1:length(QRS)-1
                    y = Yhat_forS2(QRS(j-1):QRS(j+1));
                    for s = 2:length(steps)
                        X = (floor(steps(s-1)*length(y))+1:ceil(steps(s)*length(y)))';
                        yHat = [ones(length(X),1) X]*([ones(length(X),1) X]\y(X));
                        yHat_all_RRR = [yHat_all_RRR; yHat(1)];
                    end
                    yHat_all_RRR = [yHat_all_RRR; yHat(end)];
                    ecg_plot_all_RRR = [ecg_plot_all_RRR; ecg(QRS(j-1):QRS(j+1))];
                end
                if ~isempty(yHat_all_RRR)
                    Yhat_forISO = filtfilt(bbb, aaa, Yhat_forS2);
                    k=1;
                    for j=2:1:length(QRS)-1
                        diff100 = ((Yhat_forISO(QRS(j+1))-Yhat_forISO(QRS(j-1))) + Yhat_forS2(QRS(j-1))) - Yhat_forS2(QRS(j+1)); % with that much we have to increase the third R so that the diff b/n 1st and 3rd R is the same as diff b/n 1st and 3rd R on the ISO line. NOTE: peaks on ISO may not be at QRS points
                        tmp = steps'*diff100; % with that much we have to increase each one of the [20] slopes in Yhat_forS2
                        yHat_all_RRR(k:k+length(steps)-1) = yHat_all_RRR(k:k+length(steps)-1) + tmp; % k+20
                        k = k + length(steps); % k+21
                    end
                    yHat_all_RRR = reshape(yHat_all_RRR,length(steps),length(yHat_all_RRR)/length(steps))';
                    % idea: normalize the sum(abs( per row)) = 1
                    yHat_all_RRR_BIG = [yHat_all_RRR_BIG; yHat_all_RRR]; % the points in raw y coordinates of the 20 line segments, adjusted to iso-line
                end


            end
        end


    end
end
ecg_plot_all_RRR_val = [num2cell(ones(length(ecg_plot_all_RRR),2)) ecg_plot_all_RRR];
ecg_plot_all_val = [ecg_plot_all_val ecg_plot_all];
res = struct;
res.ecg_plot_all_val = ecg_plot_all_val;
res.ecg_plot_all_RRR_val = ecg_plot_all_RRR_val;
res.QRS_all_BIG = QRS_all_BIG;
res.patID = patID;
res.waves_wavedet = waves_wavedet;
for use_Yhat_forS2_filtfilt = 0:1
    for num_steps = 21:20:41
        eval(['res.yHat_all_BIG_s' num2str(num_steps) '_filtfilt' num2str(use_Yhat_forS2_filtfilt) ' = yHat_all_BIG_s' num2str(num_steps) '_filtfilt' num2str(use_Yhat_forS2_filtfilt) ';']);
    end
end
res.yHat_all_RRR_BIG = yHat_all_RRR_BIG;
end


function QRS = local_gqrs_exe(ecg,ECG_header)

cwd = pwd;
mybasedir = 'D:\Boichev\m\ECG\path';
mydir = [mybasedir '\' 'results' '\'];
cd(mydir)
QRSdetector = 'gqrs';
%
lead_num = 1;
Fs = 250; gain = 200; fmt = 16;
%wrsamp((0:length(-ecg)-1)',30*(ecg/std(ecg)),'PatID_wrsamp',Fs,gain,num2str(fmt)); % NOTE: lead description/name is NOT provided, so " col 1" name is generated automatically
wrsamp((0:length(-ecg)-1)',0.25*250*(ecg/std(ecg)),PatID_wrsamp,Fs,gain,num2str(fmt)); % NOTE: lead description/name is NOT provided, so " col 1" name is generated automatically
% create a (fake) header file:
if isempty(ECG_header)
    ECG_header = struct;
    ECG_header.recname = PatID_wrsamp;
    ECG_header.nsig = length(lead_num);
    ECG_header.freq = Fs;
    ECG_header.nsamp = length(ecg);
    ECG_header.btime = '00:00:00';
    ECG_header.bdate = '01/01/2000';
    ECG_header.spf = NaN;
    ECG_header.baseline = NaN;
    ECG_header.units = 'mV';
    ECG_header.fname = [PatID_wrsamp '.dat'];
    ECG_header.group = 0;
    ECG_header.fmt = fmt;
    ECG_header.gain = gain;
    ECG_header.adcres = 16;
    ECG_header.adczero = 0;
    ECG_header.initval = ecg(1);
    ECG_header.cksum = 0; % ok ???
    ECG_header.bsize = 0;
    ECG_header.desc = repmat('V1',length(lead_num));
end
this_detector = QRSdetector; % QRSdetector = 'gqrs';
obj.tmp_path_local = mydir; % georgi
obj.detection_threshold = 1; % georgi 0.5, 1
obj.gqrs_config_filename = [mydir 'gqrs.conf'];
obj.WFDB_cmd_prefix_str = ['C:&cd ' mydir '&'];
jj=1;
file_name_orig =  [obj.tmp_path_local ECG_header.recname '.' this_detector num2str(jj) ];
this_thrs = obj.detection_threshold;
[status, ~] = system(['gqrs -c ' obj.gqrs_config_filename ' -r ' ECG_header.recname ' -s ' num2str(jj-1) ' -m ' num2str(this_thrs)]);
[status, ~] = system(['gqpost -c ' obj.gqrs_config_filename ' -r ' ECG_header.recname ' -o ' this_detector num2str(jj) ]);
delete([obj.tmp_path_local ECG_header.recname '.qrs' ]);
anns_test = readannot(file_name_orig); % in which folder is this file ??
cd(cwd)
if ~isempty(anns_test)
    QRS = anns_test.time;
else
    QRS = 0;
end
end


function QRS = local_gqrs_wfdb(ecg, PatID_wrsamp)

cwd = pwd;

% mybasedir = 'D:\Boichev\m\ECG\path';
% mydir = [mybasedir '\' 'results' '\'];
% cd(mydir)
mydir = pwd; mydir = [mydir filesep];

%
Fs = 250; gain = 200; fmt = 16;
%wrsamp((0:length(-ecg)-1)',30*(ecg/std(ecg)),'PatID_wrsamp',Fs,gain,num2str(fmt)); % NOTE: lead description/name is NOT provided, so " col 1" name is generated automatically
wrsamp((0:length(-ecg)-1)',0.25*250*(ecg/std(ecg)),PatID_wrsamp,Fs,gain,num2str(fmt)); % NOTE: lead description/name is NOT provided, so " col 1" name is generated automatically

wfdb_argument = [{'-r'}, {PatID_wrsamp}, {'-f'}, {'s0'}];
javaWfdbExec=getWfdbClass('gqrs');
err=javaWfdbExec.execToStringList(wfdb_argument);
if(~isempty(strfind(err.toString,['annopen: can''t'])))
    error(err)
end

file_name_orig = [mydir [PatID_wrsamp '.qrs']];
try
    % anns_test = readannot(file_name_orig); % in which folder is this file ??
    heasig.freq = 250; heasig.nsamp = length(ecg); t = [1 length(ecg)]; anns_test = local_readannot(file_name_orig,heasig,t);
catch
    disp('Error in readannot')
    anns_test = [];
end
delete(file_name_orig);

file_name_orig = [mydir [PatID_wrsamp '.hea']];
delete(file_name_orig);
file_name_orig = [mydir [PatID_wrsamp '.dat']];
delete(file_name_orig);

cd(cwd)
if ~isempty(anns_test)
    QRS = anns_test.time;
else
    QRS = 0;
end
end


function anot=local_readannot(name,heasig,t)
% READANNOT  READS DB-ANNOTATION FILES
%
%	Input parameters: name -> character string with name of annotation file
%			  heasig -> header structure signal
%			  t=[t0 t1] -> vector of interval of reading in samples

% Salvador Olmos
% e-mail: olmos@posta.unizar.es


dim = ceil(heasig.nsamp/heasig.freq*2);
% pre-allocating of memory
anot=struct('time',zeros(dim,1),'anntyp',blanks(dim)','subtyp',blanks(dim)','chan',blanks(dim)','num',blanks(dim)','aux',repmat(blanks(dim)',1,10));

del=1;

% Opening binary file
fida=fopen(name,'rb');
if fida<0
   disp('can not open annotation file');
   %keyboard;
end

% Initialization of variables
pos=0; 	% relative position to the beginnning of file
i=1; 	% index of annotation number
currnumfield='0';
currchanfield='0';
subtyp='0';

% Reading of the two first bytes for annotation code
data=fread(fida,2,'uchar');
L=['NLRaVFJASEj/Q~ | sT*D"=pB^t+u?!{}en xf()r'];	% Dictionaty of annotation types


while (~feof(fida) & pos<t(2) ),

	A=data(1)+data(2)*256;
	II=rem(A,1024);  	% Distance (in samples) respect to last annotation
	A=floor(A/1024); 	% Annotation code
        if ((A~=0) & A<=length(L)) anot.anntyp(i)=L(A); end  % JGM 100699
        %if (A~=0)  anot.anntyp(i)=L(A); end

        data=fread(fida,2,'uchar');
        if (feof(fida))  del=0; break; end
	A=data(1)+data(2)*256;
	I=rem(A,1024);
	A=floor(A/1024);
      
        while (A>=59)		% Special annotation codes
  	  if A==59,
		skip=fread(fida,4,'uchar');
		I=skip(3)+256*(skip(4)+256*(skip(1)+256*skip(2)));
		pos=pos+I;
	 	I=0;
	  elseif A==60,
		currnumfield=setstr(I);                                
	  elseif A==61,
		subtyp=num2str(I);
	  elseif A==62,
		currchanfield=setstr(I);
	  elseif A==63,
		if rem(I,2)==1,
			I=I+1;
		end;
                h=setstr(fread(fida,I,'char'))';
		anot.aux(i,1:length(h))=h;
	  end;
	  data=fread(fida,2,'uchar');
          if (feof(fida))  del=0; break; end
   	  A=data(1)+data(2)*256;
	  I=rem(A,1024);
	  A=floor(A/1024);
        end
	 
	pos=pos+II;
	anot.time(i)=pos;
	anot.num(i)=currnumfield;
	anot.chan(i)=currchanfield;
	anot.subtyp(i)=str2num(subtyp);
	subtyp='0';
	i=i+1;

end
fclose(fida);

if i<dim
  anot.anntyp(i:dim)=[];
  anot.time(i:dim)=[];
  anot.num(i:dim)=[];
  anot.subtyp(i:dim)=[];
  anot.chan(i:dim)=[];
  anot.aux(i:dim,:)=[];
end


aux=find(anot.time<t(1) | anot.time>=t(2));
anot.time(aux)=[];
anot.anntyp(aux)=[];
anot.subtyp(aux)=[];
anot.num(aux)=[];
anot.chan(aux)=[];  
anot.aux(i-del,:)=' ';

anot.aux=anot.aux(1:i-1-del,:);
%	if A==0,
%elseif A==1,anot.anntyp(i)='N'; %Normal beat
%elseif A==2,anot.anntyp(i)='L'; %Left bundle branch block beat
%elseif A==3,anot.anntyp(i)='R'; %Right bundle branch block beat
%elseif A==4,anot.anntyp(i)='a'; %Aberrated atrial premature beat
%elseif A==5,anot.anntyp(i)='V'; %Premature ventricular contraction
%elseif A==6,anot.anntyp(i)='F'; %Fusuion of ventricular and normal beat
%elseif A==7,anot.anntyp(i)='J'; %Nodal (junctional) premature beat
%elseif A==8,anot.anntyp(i)='A'; %Atrial premature beat
%elseif A==9,anot.anntyp(i)='S'; %Premature or ectopic supraventricular beat
%elseif A==10,anot.anntyp(i)='E'; %Ventricular escape beat
%elseif A==11,anot.anntyp(i)='j'; %Nodal (junctional) escape beat
%elseif A==12,anot.anntyp(i)='/'; %Paced beat
%elseif A==13,anot.anntyp(i)='Q'; %Unclassifiable beat
%elseif A==14,anot.anntyp(i)='~'; %Signal quality change
%elseif A==15,anot.anntyp(i)=''; %Not specified
%elseif A==16,anot.anntyp(i)='|'; %Isolated QRS-like artifact
%elseif A==17,anot.anntyp(i)=''; %Not specified
%elseif A==18,anot.anntyp(i)='s'; %ST change
%elseif A==19,anot.anntyp(i)='T'; %T-wave change
%elseif A==20,anot.anntyp(i)='*'; %Systole
%elseif A==21,anot.anntyp(i)='D'; %Diastole
%elseif A==22,anot.anntyp(i)='"'; %Comment annotation
%elseif A==23,anot.anntyp(i)='='; %Measurement annotation
%elseif A==24,anot.anntyp(i)='p'; %P-wave peak
%elseif A==25,anot.anntyp(i)='B'; %Left or right bundle branch block
%elseif A==26,anot.anntyp(i)='^'; %Non-conducted pacer spike
%elseif A==27,anot.anntyp(i)='t'; %T-wave peak
%elseif A==28,anot.anntyp(i)='+'; %Rythm change         
%elseif A==29,anot.anntyp(i)='u'; %U-wave peak
%elseif A==30,anot.anntyp(i)='?'; %Learning
%elseif A==31,anot.anntyp(i)='!'; %Ventricular flutter wave
%elseif A==32,anot.anntyp(i)='['; %Start of ventricular flutter/fibrillation
%elseif A==33,anot.anntyp(i)=']'; %End of ventricular flutter/fibrillation
%elseif A==34,anot.anntyp(i)='e'; %Atrial escape beat
%elseif A==35,anot.anntyp(i)='n'; %Supraventricular espace beat
%elseif A==36,anot.anntyp(i)=''; %Not specified
%elseif A==37,anot.anntyp(i)='x'; %Non-conducted P-wave (blocked APB)
%elseif A==38,anot.anntyp(i)='f'; %Fusion of paced and normal beat
%elseif A==39,anot.anntyp(i)='('; %Waveform onset
%elseif A==40,anot.anntyp(i)=')'; %Waveform end
%elseif A==41,anot.anntyp(i)='r'; %R-on-T premature ventricular contraction
%end; % Fin de decodificacion de anotacion




end



