function [x_fv] = get_fv4(ecg_data_f,Fs)
%Vignesh Kalidas 
%PhD - Computer Engineering, 
%Dept of Electrical Engineering, 
%University of Texas at Dallas, Texas, USA
% GNU General public License
    l_yes = 0;
    x_fv1 = [];
    x_fv2 = [];


    ecg_data1 = ecg_data_f - mean(ecg_data_f);

    [x_fv,ecg_locs1] = get_features(ecg_data1,Fs);

end

function [x_fv,ecg_locs1] = get_features(ecg_data1,Fs)

    lp_ecg = butter_bidir(1,ecg_data1,Fs,2,'low');
    ecg_data1 = ecg_data1 - lp_ecg;


%     [flat1,~] = verify_flat(ecg_data1,Fs);


    ecg_locs1 = [];


%     if(~flat1)
        [ecg_locs1] = get_rpeaks(ecg_data1,Fs,1);
%     end


    l=1;
    ebpm1_5 = [0];

    ecgloc_off1 = 4;
    if(length(ecg_locs1) >= 5)
        ecgloc_off1 = 4;
    elseif(length(ecg_locs1) >= 3)
        ecgloc_off1 = 2;
    else
        ecgloc_off1 = 1; % For Very Small Length Signal
    end

 

    for i=1:1:length(ecg_locs1)-ecgloc_off1

        ecg_beats = ecg_locs1(i:i+ecgloc_off1);
        diff_locs = diff(ecg_beats);
        mean_locs = mean(diff_locs);
        ebpm1_5(l) = 60*Fs/mean_locs;
        l=l+1;

    end
    min_ebpm1 = min(ebpm1_5);


    x_fv = [min_ebpm1];
end
