function features = get_12ECG_features(data, header_data)

    %parforNumWorkers = 0; %Inf
    parforNumWorkers = Inf;

    generate_phase_1_features = true;
    generate_phase_2_features = true;
    
    max_time = 20; %180
    
    sw_save_res = false;
    %res_dir = 'E:\PhysioNetChallenge2020\all_data_res';
    res_dir = 'E:\PhysioNetChallenge2020\partition_2_res';
    
    % Initialisations

    global dsc_n_catch;
    global dsc_n_ok;
    
    [recording,Total_time,~,Fs,~,age,sex]=extract_data_from_header(header_data);
    
    if Total_time > max_time
       tmax = min(max_time * Fs, size(data, 2));
       data = data(:,1:tmax); 
    end
    
    % 1081 OK
    % 250  NOK
    % 2156 TOTAL
    
    n_catch_max = 1000; %250; %12;

    features = struct;
    features.GN = struct;
    
    % Matlab baseline model features
    
    dsc_n_catch_local = 0;
    
    try
        features.MB = get_12ECG_features_mb(data,header_data);
    catch
        features.MB = [age sex NaN(1,22)];
        dsc_n_catch_local = dsc_n_catch_local + 1;
    end
    
    % SD's AF features
    
    leadIdxs = [1 2 7];
    features_SD_lead_n = cell(3,1);
    
    %for i = 1:length(leadIdxs)
    parfor (i = 1:length(leadIdxs), parforNumWorkers)
        
        leadIdx = leadIdxs(i);
        
        try
            features_SD_lead_n{i,1} = challenge(data, header_data, leadIdx);
        catch
            MeanVector_208 = load('MeanVector_208.mat', 'MeanVector_208');
            MeanVector_208 = MeanVector_208.MeanVector_208;
            features_SD_lead_n{i,1} = MeanVector_208;
            dsc_n_catch_local = dsc_n_catch_local + 1;
        end
    end
    
    if dsc_n_catch_local > 0
        dsc_n_catch = dsc_n_catch + 1;
        disp(['catch ' num2str(dsc_n_catch) ' in :' recording]);
    else
        dsc_n_ok = dsc_n_ok + 1;
    end
    
    if dsc_n_catch > n_catch_max
        error(['Too many catches in get_12ECG_features_mb: ' num2str(dsc_n_ok)]);
    end
    
    features.SD = [features_SD_lead_n{1,1} features_SD_lead_n{2,1} features_SD_lead_n{3,1}];    
    
    % resample
    
    signal = data';

    recording = strrep(recording,'.mat', '');
    
    n = size(signal,1);
    freq = Fs;
    leads = zeros(round(size(signal,1)*250/freq),size(signal,2));

    if freq ~= 250
        for i=1:size(signal,2)
            leads(:,i) = round( interp1((1:n)*(1000/freq),signal(1:n,i),(1:round(n*(250/freq)))*(1000/250),'linear','extrap')');
        end
    end

    signal = leads;

    tm = [0 (1:(size(signal, 1)-1))/250];
    
    if generate_phase_1_features
        load('params.mat','params')
    
        d1 = params.d1;
        bbb = params.bbb;
        aaa = params.aaa;
        use_num_leads = params.use_num_leads;
    else
        use_num_leads = 1;
    end
    
    Phy2020file = recording;
    
    % wavedet
    
    ress = cell(12,1);
    ress_ph2 = cell(12,1);
    leadIdxs = [1 2 5 7 10 12];
    res_parfor = cell(6,1);
    res_parfor_ph2 = cell(2,1);
    
    %for leadIdxIdx = 1:length(leadIdxs)
    parfor (leadIdxIdx = 1:length(leadIdxs), parforNumWorkers)
        % disp(num2str(leadIdx));
        leadIdx = leadIdxs(leadIdxIdx);
        
        if generate_phase_1_features
            res_parfor{leadIdxIdx} = global_predict_20segments_model([], signal(:,leadIdx), use_num_leads,d1,bbb,aaa,[Phy2020file '_' num2str(leadIdx)]);
        end
        
        if generate_phase_2_features
            if leadIdx <= 2
                % NOTE: will only prepare data, predictions are carried out outside this function
                res_parfor_ph2{leadIdxIdx} = predict_20segments_model_sub(signal(:,leadIdx), use_num_leads, Phy2020file, [Phy2020file '_' num2str(leadIdx)]);
            end
        end
    end
    
    for leadIdxIdx = 1:length(leadIdxs)
        % disp(num2str(leadIdx));
        leadIdx = leadIdxs(leadIdxIdx);
        ress{leadIdx} = res_parfor{leadIdxIdx};
        
        if generate_phase_2_features
            if leadIdx <= 2
                ress_ph2{leadIdx} = res_parfor_ph2{leadIdxIdx};
            end
        end
    end
    
    if generate_phase_2_features
        for leadIdxIdx = 1:length(leadIdxs)
            % disp(num2str(leadIdx));
            leadIdx = leadIdxs(leadIdxIdx);
            if leadIdx <= 2
                res_lead{leadIdx} = {res_parfor_ph2{leadIdxIdx}};
            end
        end
    end
    
    if sw_save_res
        save([res_dir '\' recording '.mat'], 'ress');
    end
    
    % STE features
    
    features.STE = get_12ECG_features_ste_leads(signal, tm, ress);
    
    % GN features
    
    if generate_phase_1_features
    
        % features_gn_model_I.mat        1
        % features_gn_model_II.mat       2 
        % features_gn_model_aVL.mat      5
        % features_gn_model_v1.mat       7
        % features_gn_model_v4.mat       10
        % features_gn_model_v6.mat       12

        features_gn_lead_1 = get_12ECG_features_gn(leads, ress, 1);
        features_gn_lead_2 = get_12ECG_features_gn(leads, ress, 2);
        features_gn_lead_5 = get_12ECG_features_gn(leads, ress, 5);
        features_gn_lead_7 = get_12ECG_features_gn(leads, ress, 7);
        features_gn_lead_10 = get_12ECG_features_gn(leads, ress, 10);
        features_gn_lead_12 = get_12ECG_features_gn(leads, ress, 12);

        features.GN.set1 = [features_gn_lead_1.GN.set1 ...
                            features_gn_lead_2.GN.set1 ...
                            features_gn_lead_5.GN.set1 ...
                            features_gn_lead_7.GN.set1 ...
                            features_gn_lead_10.GN.set1 ...
                            features_gn_lead_12.GN.set1 ...
                            ];

        features.GN.set2.X = [features_gn_lead_1.GN.set2.X; ...
                            features_gn_lead_2.GN.set2.X; ...
                            features_gn_lead_5.GN.set2.X; ...
                            features_gn_lead_7.GN.set2.X; ...
                            features_gn_lead_10.GN.set2.X; ...
                            features_gn_lead_12.GN.set2.X; ...
                            ];

        features.GN.set3.X = [features_gn_lead_1.GN.set3.X; ...
                            features_gn_lead_2.GN.set3.X; ...
                            features_gn_lead_5.GN.set3.X; ...
                            features_gn_lead_7.GN.set3.X; ...
                            features_gn_lead_10.GN.set3.X; ...
                            features_gn_lead_12.GN.set3.X; ...
                            ];         
    end

    if generate_phase_2_features
        [X, ~] = load_phy2020_strip_sub_NOste(leads, res_lead);
        features.GN.set4.X = X;
    else
        features.GN.set4.X = [];
    end
    