function ecgpeaks = discard_fake_ecgpeaks(ecgpeaks,signal,ectopicECG_ventricular,freqECG)
% check 50 milliseconds before and afterwards. If the current point has values less than the points 50 ms to the right or to the left, then it cannot be a maximum (in smoothed signal) -> discard it
%
% ecgpeaks = discard_fake_ecgpeaks(ecgpeaks,handles.ECG.leads{1},handles.ectopicECG_ventricular,handles.freqECG);

for pp = 1:length(ecgpeaks)
    try % the point can be at borders...
        if ~ismember(pp,ectopicECG_ventricular)
            wrkMax = signal(ecgpeaks(pp) -  round(freqECG*(80/1000)) : ecgpeaks(pp) +  round(freqECG*(84/1000)));
            a = find(wrkMax == max(wrkMax)); a = a(1);
            if a == 1 || a == length(wrkMax)
                ecgpeaks(pp) = 0;
            else
                ecgpeaks(pp) = ecgpeaks(pp) - round(freqECG*(80/1000)) + a;
            end
        end
    catch
    end
end
ecgpeaks = ecgpeaks(ecgpeaks~=0);
end
