function [classifier] = Tree(posData,FirstSetWeights,negData, SecondSetWeights,params, specific_params)
  labels = [ones(size(posData,1),1);-ones(size(negData,1),1)];
  data = double([posData;negData]);
  
  %size(data)
  
  %disp(specific_params);
  
  classifier = struct();
  return;
  
  if isfield(specific_params,'Method')==0
      disp('tree: default');
      
      % option 1 (OK)
      %numTrees = 50;
      %t = templateTree('MaxNumSplits',3);
      %classifier = fitcensemble(data, labels, 'NumLearningCycles', numTrees, 'Learners',t, 'LearnRate',1);

      cv = cvpartition(length(labels), 'kFold', 5, 'Stratify', false);
      
      numTrees = 50;
      t = templateTree('MaxNumSplits',5);
      classifier = fitcensemble(data, labels, 'NumLearningCycles', numTrees, 'Learners',t, 'LearnRate',1, 'CrossVal','on', 'CVPartition', cv, 'NPrint', 1);
      
      AUCs = zeros(1,5);
      for i=1:5
          disp([' Fold ' num2str(i)]);
          
          classifier_i = classifier.Trained{i};
          classifier_i.ScoreTransform = 'doublelogit';
          [~, score] = predict(classifier_i, data(cv.test(i),:));
          [~,~,~,AUC,~] = perfcurve(labels(cv.test(i)), score(:,2), 1);
          AUCs(i) = AUC;
      end
      
      disp(num2str(AUCs));
      
     %classifier = compact(classifier);
      
      % option 2
    %   rng('default')
    %   t = templateTree('Reproducible',true);
    %   classifier = fitcensemble(data, labels, 'OptimizeHyperparameters','all', 'Learners',t, ...
    %        'HyperparameterOptimizationOptions',struct('AcquisitionFunctionName','expected-improvement-plus', 'Verbose', 2, 'UseParallel', true));

      % option 3

      % 'HoldOut', 0.15

    %   rng('default')
    % t = templateTree('Reproducible',true);
    % classifier  = fitcensemble(X,Y,'OptimizeHyperparameters','auto','Learners',t, ...
    %     'HyperparameterOptimizationOptions',struct('AcquisitionFunctionName','expected-improvement-plus'))
  else
      
    if ~strcmp(specific_params.Method, 'Bag')
        
        disp('tree: not bag');
        
        t = specific_params.Learners;
        classifier = fitcensemble(data, labels, ...
            'Method', specific_params.Method, ...
            'NumLearningCycles', specific_params.NumLearningCycles, ...
            'Learners', t, ...
            'LearnRate', specific_params.LearnRate);
    else
        
        disp('tree: bag');
        
        t = specific_params.Learners;
        classifier = fitcensemble(data, labels, ...
            'Method', specific_params.Method, ...
            'NumLearningCycles', specific_params.NumLearningCycles, ...
            'Learners', t);
    end
  
  end
  
