%##########################################################################

% <ECOCs Library. Coding and decoding designs for multi-class problems.>
% Copyright (C) 2009 Sergio Escalera sergio@maia.ub.es

%##########################################################################

% This file is part of the ECOC Library.

% ECOC Library is free software; you can redistribute it and/or modify it under 
% the terms of the GNU General Public License as published by the Free Software 
% Foundation; either version 2 of the License, or (at your option) any later version. 

% This program is distributed in the hope that it will be useful, but WITHOUT ANY 
% WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR 
% A PARTICULAR PURPOSE. See the GNU General Public License for more details. 

% You should have received a copy of the GNU General Public License along with
% this program. If not, see <http://www.gnu.org/licences/>.

%##########################################################################

function Classifiers=Learning(data,Parameters,classes,positions)

ECOC=Parameters.ECOC

if isfield(Parameters,'base')
    base=Parameters.base;
end

Classifiers=[];
for i=positions % for each column of the coding matrix
%for i=38:70 % for each column of the coding matrix
    
    if isfield(Parameters,'base_classifiers')
        base=Parameters.base_classifiers{i};
    end
    
    disp(['ecoclib Learning it:' num2str(i) '/' num2str(length(positions)) ' (' base ') ' num2str(ECOC(:,i)')]);
    
    if ~isfield(Parameters,'model_input_dir') || Parameters.store_training_data
        if Parameters.dataset_idx(i) == 3

            FirstSetNumRows = 0;
            SecondSetNumRows = 0;

            NumCols = size(data,2)-1+80;

            for j=1:size(ECOC,1) % for each row of the coding matrix

                %disp([' ecoclib counting col:' num2str(j) '/' num2str(size(ECOC,1))]);

                if ECOC(j,i)==1 % save the current class data in the first partition

                    pos=find(data(:,size(data,2))==classes(j));

                    for pos_idx = 1:length(pos)
                        pos_instance_idx = pos(pos_idx);

                        if ~isempty(Parameters.datasets{pos_instance_idx}.set4)                   %chunk specific for PAC/PVC
                            pos_instance_features = Parameters.datasets{pos_instance_idx}.set4;
                        elseif ~isempty(Parameters.datasets{pos_instance_idx}.set5)               %chunk specific for other than PAC/PVC
                            pos_instance_features = Parameters.datasets{pos_instance_idx}.set5;
                        elseif ~isempty(Parameters.datasets{pos_instance_idx}.set6)               %all RR-intervals
                            pos_instance_features = Parameters.datasets{pos_instance_idx}.set6;
                        else
                            %disp(['Learning.m: No RR-intervals found for partition 1 instance ' num2str(pos_idx)]);
                            pos_instance_features = NaN(1,80); 
                        end

                        FirstSetNumRows = FirstSetNumRows + size(pos_instance_features,1);
                    end

                elseif ECOC(j,i)==-1 % save the current class data in the second partition

                    pos=find(data(:,size(data,2))==classes(j));

                    for pos_idx = 1:length(pos)
                        pos_instance_idx = pos(pos_idx);

                        if ~isempty(Parameters.datasets{pos_instance_idx}.set4)                   %chunk specific for PAC/PVC
                            pos_instance_features = Parameters.datasets{pos_instance_idx}.set4;
                        elseif ~isempty(Parameters.datasets{pos_instance_idx}.set5)               %chunk specific for other than PAC/PVC
                            pos_instance_features = Parameters.datasets{pos_instance_idx}.set5;
                        elseif ~isempty(Parameters.datasets{pos_instance_idx}.set6)               %all RR-intervals
                            pos_instance_features = Parameters.datasets{pos_instance_idx}.set6;
                        else
                            %disp(['Learning.m: No RR-intervals found for partition 1 instance ' num2str(pos_idx)]);
                            pos_instance_features = NaN(1,80); 
                        end

                        SecondSetNumRows = SecondSetNumRows + size(pos_instance_features,1);

                    end
                end
            end

            FirstSetCursor = 0;
            SecondSetCursor = 0;

            FirstSet=zeros(FirstSetNumRows,NumCols);
            SecondSet=zeros(SecondSetNumRows,NumCols);

            FirstSetWeights=zeros(FirstSetNumRows,1);
            SecondSetWeights=zeros(SecondSetNumRows,1);

            FirstSetIdx=[];
            SecondSetIdx=[];
        else
            FirstSet=[];
            SecondSet=[];
            
            FirstSetIdx=[];
            SecondSetIdx=[];
        end

        for j=1:size(ECOC,1) % for each row of the coding matrix
            %disp([' ecoclib composing col:' num2str(j) '/' num2str(size(ECOC,1))]);

            if ECOC(j,i)==1 % save the current class data in the first partition
                if Parameters.dataset_idx(i) == 0
                    pos=find(data(:,size(data,2))==classes(j));
                    FirstSet(size(FirstSet,1)+1:size(FirstSet,1)+length(pos),:)=data(pos,1:size(data,2)-1);
                    FirstSetIdx(size(FirstSetIdx,1)+1:size(FirstSetIdx,1)+length(pos),:)=pos;
                elseif Parameters.dataset_idx(i) == 3
                    pos=find(data(:,size(data,2))==classes(j));
                    FirstSetIdx(size(FirstSetIdx,1)+1:size(FirstSetIdx,1)+length(pos),:)=pos;

                    % left join of per-strip data and per RRR-data
                    % we don't do it earlier on for all data because of memory restrictions

                    for pos_idx = 1:length(pos)
                        %disp([' ecoclib composing instance:' num2str(pos_idx) '/' num2str(length(pos))]);

                        pos_instance_idx = pos(pos_idx);

                        if ~isempty(Parameters.datasets{pos_instance_idx}.set4)                   %chunk specific for PAC/PVC
                            pos_instance_features = Parameters.datasets{pos_instance_idx}.set4;
                        elseif ~isempty(Parameters.datasets{pos_instance_idx}.set5)               %chunk specific for other than PAC/PVC
                            pos_instance_features = Parameters.datasets{pos_instance_idx}.set5;
                        elseif ~isempty(Parameters.datasets{pos_instance_idx}.set6)               %all RR-intervals
                            pos_instance_features = Parameters.datasets{pos_instance_idx}.set6;
                        else
                            disp(['Learning.m: No RR-intervals found for partition 1 instance ' num2str(pos_idx)]);
                            pos_instance_features = NaN(1,80); 
                        end

                        weight = 1/size(pos_instance_features,1);
                        for pos_instance_feature_idx = 1:size(pos_instance_features,1)
                            pos_instance_feature = pos_instance_features(pos_instance_feature_idx,:);
                            FirstSetCursor = FirstSetCursor + 1;
                            FirstSetWeights(FirstSetCursor:FirstSetCursor+size(pos_instance_feature,1)-1,:)=weight;
                            FirstSet(FirstSetCursor:FirstSetCursor+size(pos_instance_feature,1)-1,:)=[data(pos_instance_idx,1:size(data,2)-1) pos_instance_feature];
                        end
                    end

                else
                    pos=find(data(:,size(data,2))==classes(j));

                    for pos_idx = 1:length(pos)
                        pos_instance_idx = pos(pos_idx);
                        pos_instance_features = Parameters.datasets{pos_instance_idx}.set2.X;
                        FirstSet(size(FirstSet,1)+1:size(FirstSet,1)+size(pos_instance_features,1),:)=pos_instance_features;
                        FirstSetStruct{length(FirstSetStruct)+1} = Parameters.datasets{pos_instance_idx};
                    end

                end
            elseif ECOC(j,i)==-1 % save the current class data in the second partition
                if Parameters.dataset_idx(i) == 0
                   pos=find(data(:,size(data,2))==classes(j));
                   SecondSet(size(SecondSet,1)+1:size(SecondSet,1)+length(pos),:)=data(pos,1:size(data,2)-1);
                   SecondSetIdx(size(SecondSetIdx,1)+1:size(SecondSetIdx,1)+length(pos),:)=pos;
                elseif Parameters.dataset_idx(i) == 3
                    pos=find(data(:,size(data,2))==classes(j));
                    SecondSetIdx(size(SecondSetIdx,1)+1:size(SecondSetIdx,1)+length(pos),:)=pos;

                    % left join of per-strip data and per RRR-data
                    % we don't do it earlier on for all data because of memory restrictions
                    for pos_idx = 1:length(pos)

                        %disp([' ecoclib composing instance:' num2str(pos_idx) '/' num2str(length(pos))]);

                        pos_instance_idx = pos(pos_idx);

                        if ~isempty(Parameters.datasets{pos_instance_idx}.set4)                   %chunk specific for PAC/PVC
                            pos_instance_features = Parameters.datasets{pos_instance_idx}.set4;
                        elseif ~isempty(Parameters.datasets{pos_instance_idx}.set5)               %chunk specific for other than PAC/PVC
                            pos_instance_features = Parameters.datasets{pos_instance_idx}.set5;
                        elseif ~isempty(Parameters.datasets{pos_instance_idx}.set6)               %all RR-intervals
                            pos_instance_features = Parameters.datasets{pos_instance_idx}.set6;
                        else
                            disp(['Learning.m: No RR-intervals found for partition 1 instance ' num2str(pos_idx)]);
                            pos_instance_features = NaN(1,80); 
                        end

                        weight = 1/size(pos_instance_features,1);
                        for pos_instance_feature_idx = 1:size(pos_instance_features,1)
                            pos_instance_feature = pos_instance_features(pos_instance_feature_idx,:);
                            SecondSetCursor = SecondSetCursor + 1;
                            SecondSetWeights(SecondSetCursor:SecondSetCursor+size(pos_instance_feature,1)-1,:)=weight;
                            SecondSet(SecondSetCursor:SecondSetCursor+size(pos_instance_feature,1)-1,:)=[data(pos_instance_idx,1:size(data,2)-1) pos_instance_feature];
                        end
                    end

                else
                    pos=find(data(:,size(data,2))==classes(j));

                    for pos_idx = 1:length(pos)
                        pos_instance_idx = pos(pos_idx);
                        pos_instance_features = Parameters.datasets{pos_instance_idx}.set2.X;

                        SecondSet(size(SecondSet,1)+1:size(SecondSet,1)+size(pos_instance_features,1),:)=pos_instance_features;
                        SecondSetStruct{length(SecondSetStruct)+1} = Parameters.datasets{pos_instance_idx};
                    end
                end
            end
        end

        if Parameters.dataset_idx(i) ~= 3
           FirstSetWeights=ones(size(FirstSet,1),1);
           SecondSetWeights=ones(size(SecondSet,1),1);
        end
    end
        
    %try, % apply the base classifier over the current partition of classes
    classifier_id = length(Classifiers) + 1;
    
    if isfield(Parameters,'model_input_dir')
       %Custom_classifier = load(['E:\ClassifiersECOC9ClassInclGNAVSTDAF\classifier_' num2str(classifier_id)]).Custom_classifier;
       %Custom_classifier = load(['G:\ModelAllLeadStripLeftJoinRR_RRRFold1\classifier_' num2str(classifier_id)]).Custom_classifier;
       
       model_input_dir = Parameters.model_input_dir;
       Custom_classifier = load([model_input_dir '\classifier_' num2str(classifier_id)]);
       Custom_classifier = Custom_classifier.Custom_classifier;
    else
       Custom_classifier=feval(base,FirstSet,FirstSetWeights,SecondSet,SecondSetWeights,Parameters.base_params, Parameters.base_classifier_params{i});
    end
    %catch,
    %    error('Exit: Base classifier bad defined for custom base classifier.');
    %end
    
    Classifiers{length(Classifiers)+1}.classifier=Custom_classifier; % save current classifier and data
    
    if Parameters.store_training_data
        Classifiers{length(Classifiers)}.FirstSet=FirstSet;
        Classifiers{length(Classifiers)}.SecondSet=SecondSet;
        
        Classifiers{length(Classifiers)}.FirstSetIdx=FirstSetIdx;
        Classifiers{length(Classifiers)}.SecondSetIdx=SecondSetIdx;
        
        %Classifiers{length(Classifiers)}.FirstSetStruct=FirstSetStruct;
        %Classifiers{length(Classifiers)}.SecondSetStruct=SecondSetStruct;
    end
    
    if isfield(Parameters,'model_output_dir')
       model_output_dir=Parameters.model_output_dir;
       mkdir(model_output_dir);
       save([model_output_dir '\classifier_' num2str(length(Classifiers))], 'Custom_classifier');  
    end
    
    %save(['C:\src\hierarchical_classifiers\classifier_' num2str(length(Classifiers))], 'Custom_classifier');
    %save(['E:\ModelAllLeadStripLeftJoinRRRFold1\classifier_' num2str(length(Classifiers))], 'Custom_classifier');
    %save(['D:\ModelAllLeadStripLeftJoinRRRFold1\classifier_' num2str(length(Classifiers))], 'Custom_classifier');
    %save(['D:\ModelAllLeadStripLeftJoinRR_RRRFold1\classifier_' num2str(length(Classifiers))], 'Custom_classifier');
    %save(['E:\Model450LearningCyclesInclSTE\classifier_' num2str(length(Classifiers))], 'Custom_classifier');
    %save(['E:\ModelMultiLeadInclSTE\classifier_' num2str(length(Classifiers))], 'Custom_classifier');
    %save(['E:\ModelMultiLeadExclSTE\classifier_' num2str(length(Classifiers))], 'Custom_classifier');
    %save(['E:\ModelMultiLeadGNInclSTEWaveDet\classifier_' num2str(length(Classifiers))], 'Custom_classifier');
    %save(['E:\ModelMultiLeadGNInclSTEWaveDetResubstitution\classifier_' num2str(length(Classifiers))], 'Custom_classifier');
    %save(['E:\ModelAllLeadGNInclSTEWaveDet\classifier_' num2str(length(Classifiers))], 'Custom_classifier');
    %save(['c:\src\NormalRhythm\classifier_' num2str(length(Classifiers))], 'Custom_classifier');
end
