/*
 * Decompiled with CFR 0.152.
 */
package org.physionet.wfdb.physiobank;

import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.physionet.wfdb.Wfdbexec;
import org.physionet.wfdb.physiobank.PhysioNetSignal;

public class PhysioNetRecord {
    private String name = new String();
    private ArrayList<String> signalStringList;
    private ArrayList<PhysioNetSignal> signalList;
    private static Logger logger = Logger.getLogger(PhysioNetRecord.class.getName());

    public PhysioNetRecord(String string) throws Exception {
        this.name = string;
        this.signalStringList = new ArrayList();
        this.signalList = new ArrayList();
        this.setSignalList();
    }

    public ArrayList<String> getSignalStringList() {
        return this.signalStringList;
    }

    public void printRecord() {
        for (PhysioNetSignal physioNetSignal : this.signalList) {
            physioNetSignal.printSignalInfo();
        }
    }

    public void setSignalList() throws Exception {
        this.setSignalList(null);
    }

    public void setSignalList(String string) throws Exception {
        String[] stringArray = new String[]{this.name};
        Wfdbexec wfdbexec = new Wfdbexec("wfdbdesc", Wfdbexec.customArchFlag);
        wfdbexec.setArguments(stringArray);
        logger.finest("\n\t***Executing wfdb command");
        ArrayList<String> arrayList = wfdbexec.execToStringList();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        PhysioNetSignal physioNetSignal = null;
        String string6 = "^Group (\\d+), Signal (\\d+):";
        String string7 = "Length:\\s+(\\d+:\\d+.\\d+)\\s+\\((\\d+)\\s+sample\\s+intervals\\)";
        String string8 = "Length:\\s+(\\d+:\\d+:\\d+.\\d+)\\s+\\((\\d+)\\s+sample\\s+intervals\\)";
        Pattern pattern = Pattern.compile(string6);
        Pattern pattern2 = Pattern.compile(string7);
        Pattern pattern3 = Pattern.compile(string8);
        Matcher matcher = null;
        Matcher matcher2 = null;
        logger.fine("parsing list, size= " + arrayList.size());
        for (String string9 : arrayList) {
            logger.finest("parsing :" + string9);
            if (string9.startsWith("Starting time: ")) {
                string2 = string9.replace("Starting time: ", "");
                continue;
            }
            if (string9.startsWith("Length: ") && !string9.contains("Length: not specified")) {
                try {
                    matcher2 = pattern2.matcher(string9);
                    if (!matcher2.find()) {
                        matcher2 = pattern3.matcher(string9);
                        matcher2.find();
                    }
                    if (!matcher2.group(1).isEmpty()) {
                        string3 = matcher2.group(1);
                    }
                    if (matcher2.group(2).isEmpty()) continue;
                    string4 = matcher2.group(2);
                }
                catch (IllegalStateException illegalStateException) {
                    System.err.println("Could not match : " + string9);
                    System.err.println("Attempting to continue...");
                }
                continue;
            }
            if (string9.startsWith("Sampling frequency: ")) {
                string5 = string9.replace("Sampling frequency: ", "");
                continue;
            }
            if (string9.startsWith("Group ")) {
                if (physioNetSignal != null) {
                    if (string == null) {
                        this.signalList.add(physioNetSignal);
                    } else if (string.equals(physioNetSignal.getDescription())) {
                        this.signalList.add(physioNetSignal);
                    }
                }
                physioNetSignal = new PhysioNetSignal(this.signalList.size() + 1, this.name);
                physioNetSignal.setStartTime(string2);
                physioNetSignal.setLengthTime(string3);
                physioNetSignal.setLengthSamples(string4);
                physioNetSignal.setSamplingFrequency(string5);
                matcher = pattern.matcher(string9);
                matcher.find();
                if (!matcher.group(1).isEmpty()) {
                    physioNetSignal.setGroup(matcher.group(1));
                }
                if (matcher.group(2).isEmpty()) continue;
                physioNetSignal.setSignalIndex(matcher.group(2));
                continue;
            }
            if (string9.startsWith(" File: ")) {
                physioNetSignal.setFile(string9.replace(" File: ", ""));
                continue;
            }
            if (string9.startsWith(" Description: ")) {
                physioNetSignal.setDescription(string9.replace(" Description: ", ""));
                continue;
            }
            if (string9.startsWith(" Gain: ")) {
                physioNetSignal.setGain(string9.replace(" Gain: ", ""));
                continue;
            }
            if (string9.startsWith(" Initial value: ")) {
                physioNetSignal.setInitialValue(string9.replace(" Initial value: ", ""));
                continue;
            }
            if (string9.startsWith(" Storage format: ")) {
                physioNetSignal.setFormat(string9.replace(" Storage format: ", ""));
                continue;
            }
            if (string9.startsWith(" I/O: ")) {
                physioNetSignal.setIo(string9.replace(" I/O: ", ""));
                continue;
            }
            if (string9.startsWith(" ADC resolution: ")) {
                physioNetSignal.setAdcResolution(string9.replace(" ADC resolution: ", ""));
                continue;
            }
            if (string9.startsWith(" ADC zero: ")) {
                physioNetSignal.setAdcZero(string9.replace(" ADC zero: ", ""));
                continue;
            }
            if (string9.startsWith(" Baseline: ")) {
                physioNetSignal.setBaseline(string9.replace(" Baseline: ", ""));
                continue;
            }
            if (!string9.startsWith(" Checksum: ")) continue;
            physioNetSignal.setCheckSum(string9.replace(" Checksum: ", ""));
        }
        if (physioNetSignal != null) {
            if (string == null) {
                this.signalList.add(physioNetSignal);
            } else if (string.equals(physioNetSignal.getDescription())) {
                this.signalList.add(physioNetSignal);
            }
        }
        logger.fine("Done parsing!");
    }

    public ArrayList<PhysioNetSignal> getSignalList() {
        return this.signalList;
    }

    public String getRecordName() {
        return this.name;
    }

    public static void main(String[] stringArray) throws Exception {
        PhysioNetRecord physioNetRecord = new PhysioNetRecord(stringArray[0]);
        ArrayList<PhysioNetSignal> arrayList = physioNetRecord.getSignalList();
        for (PhysioNetSignal physioNetSignal : arrayList) {
            physioNetSignal.printSignalInfo();
        }
    }
}

