/*
 * Decompiled with CFR 0.152.
 */
package org.physionet.wfdb.physiobank;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.physionet.wfdb.physiobank.PhysioNetRecord;

public class PhysioNetDB {
    private String name;
    private String info;
    private URL url;
    private static final String DB_URL = "http://physionet.org/physiobank/database/pbi/";
    private static final String DB_LIST = "http://physionet.org/physiobank/database/DBS";
    private ArrayList<PhysioNetRecord> dbRecordList;
    private static Logger logger = Logger.getLogger(PhysioNetRecord.class.getName());
    public static Comparator<PhysioNetDB> DBNameComparator = new Comparator<PhysioNetDB>(){

        @Override
        public int compare(PhysioNetDB physioNetDB, PhysioNetDB physioNetDB2) {
            String string;
            String string2 = physioNetDB.getname().toUpperCase();
            if (!string2.equals(string = physioNetDB2.getname().toUpperCase())) {
                return string2.compareTo(string);
            }
            return string2.compareTo(string);
        }
    };

    public PhysioNetDB(String string) {
        this.name = string;
        this.url = this.setDBURL();
        this.info = this.setInfo();
        this.dbRecordList = new ArrayList();
    }

    private PhysioNetDB(String string, String string2) {
        this.name = string;
        this.info = string2;
        this.url = this.setDBURL();
        this.dbRecordList = new ArrayList();
    }

    public String getname() {
        return this.name;
    }

    public ArrayList<PhysioNetRecord> getDBRecordList() throws Exception {
        if (this.dbRecordList.isEmpty()) {
            this.setDBRecordList();
        }
        return this.dbRecordList;
    }

    public String getinfo() {
        return this.info;
    }

    public URL getURL() {
        return this.url;
    }

    public static List<PhysioNetDB> getPhysioNetDBList() {
        BufferedReader bufferedReader = null;
        ArrayList<PhysioNetDB> arrayList = new ArrayList<PhysioNetDB>();
        try {
            String string;
            URL uRL = new URL(DB_LIST);
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                logger.finest("\n\t***Reading URL: \n\t" + string);
                String[] stringArray = string.split("\\t");
                String string2 = stringArray[0];
                String string3 = string.replaceFirst(string2, "").replaceAll("\\t", "");
                arrayList.add(new PhysioNetDB(string2, string3));
            }
            logger.fine("\n\t*** physionetDBList Size: \n\t" + arrayList.size());
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    public static HashMap<String, PhysioNetDB> getPhysioNetDBMap() {
        BufferedReader bufferedReader = null;
        HashMap<String, PhysioNetDB> hashMap = new HashMap<String, PhysioNetDB>();
        try {
            String string;
            URL uRL = new URL(DB_LIST);
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                logger.finest("\n\t***Reading URL: \n\t" + string);
                String[] stringArray = string.split("\\t");
                String string2 = stringArray[0];
                String string3 = string.replaceFirst(string2, "").replaceAll("\\t", "");
                hashMap.put(string2, new PhysioNetDB(string2, string3));
            }
            bufferedReader.close();
            logger.fine("\n\t*** physionetDBMap Size: \n\t" + hashMap.size());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashMap;
    }

    public void printDBInfo() {
        System.out.println(this.name);
        System.out.println("\tDescription: " + this.info);
        System.out.println("\tURL: " + this.url);
    }

    public String getDBInfo() {
        String string = this.name + "\n\tDescription: " + this.info + "\n\tURL: " + this.url;
        return string;
    }

    public void printDBRecordList() throws Exception {
        this.getDBRecordList();
        this.printDBInfo();
        for (PhysioNetRecord physioNetRecord : this.dbRecordList) {
            physioNetRecord.printRecord();
        }
    }

    public static void printDBList(List<PhysioNetDB> list) {
        List<PhysioNetDB> list2 = PhysioNetDB.getPhysioNetDBList();
        for (PhysioNetDB physioNetDB : list2) {
            physioNetDB.printDBInfo();
        }
    }

    public static void printDBList() {
        List<PhysioNetDB> list = PhysioNetDB.getPhysioNetDBList();
        Collections.sort(list, DBNameComparator);
        for (PhysioNetDB physioNetDB : list) {
            physioNetDB.printDBInfo();
        }
    }

    private URL setDBURL() {
        logger.finer("\n\t***URL Input: \n\t" + this.name);
        try {
            URL uRL = new URL(DB_URL + this.name.replaceAll("/", "_"));
            logger.finer("\n\t***Parsed URL: \n\t" + uRL.toString());
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    private String setInfo() {
        BufferedReader bufferedReader = null;
        String string = "";
        try {
            String string2;
            URL uRL = new URL(DB_LIST);
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split("\\t");
                if (stringArray[0].compareTo(this.name) != 0) continue;
                string = string2.replaceFirst(stringArray[0], "").replaceAll("\\t", "");
                break;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public void setDBRecordList() throws Exception {
        BufferedReader bufferedReader = null;
        String string = "";
        ArrayList<String> arrayList = null;
        logger.finest("\n\t***Getting record list from: \n\t" + this.url);
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader(this.url.openStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split("\\t");
                logger.finest("\n\t***Reading record data: \n\t" + string2);
                if (stringArray[0].compareTo(string) != 0) {
                    if (!string.isEmpty()) {
                        this.dbRecordList.add(new PhysioNetRecord(stringArray[0]));
                    }
                    string = stringArray[0];
                    arrayList = null;
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(new String(string2.replaceFirst(string, "")));
            }
            bufferedReader.close();
            logger.fine("\n\t***Rec List Size: \n\t" + arrayList.size());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static List<PhysioNetDB> main() {
        return PhysioNetDB.getPhysioNetDBList();
    }
}

