/*
 * Decompiled with CFR 0.152.
 */
package org.physionet.wfdb;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.physionet.wfdb.InputWriter;
import org.physionet.wfdb.OutputReader;
import org.physionet.wfdb.SystemSettings;

public class Wfdbexec {
    private String commandName;
    private static final String fsep = SystemSettings.fsep;
    private static final String osArch = SystemSettings.getosArch();
    private static final String osName = SystemSettings.getOsName();
    protected static final String WFDB_JAVA_HOME = SystemSettings.getWFDB_JAVA_HOME();
    private String WFDB_PATH = null;
    private String WFDBCAL = null;
    private List<String> commandInput;
    protected static Map<String, String> env;
    protected static File EXECUTING_DIR;
    protected String[] arguments;
    private int DoubleArrayListCapacity = 0;
    private int FloatArrayListCapacity = 0;
    private int ShortArrayListCapacity = 0;
    private int LongArrayListCapacity = 0;
    private static Logger logger;
    private String commandDir;
    private long initialWaitTime;
    private String WFDB_NATIVE_BIN;
    private String LD_PATH;
    public static boolean customArchFlag;

    public Wfdbexec(String string, String string2, boolean bl) {
        logger.finest("\n\t***Setting exec commandName to: " + string2 + string);
        this.commandName = string;
        this.commandDir = string2;
        customArchFlag = bl;
        this.setWFDB_NATIVE_BIN(SystemSettings.getWFDB_NATIVE_BIN(bl));
        this.LD_PATH = SystemSettings.getLD_PATH(bl);
    }

    public Wfdbexec(String string, boolean bl) {
        this(string, SystemSettings.getWFDB_NATIVE_BIN(bl) + "bin" + fsep, bl);
    }

    public void setArguments(String[] stringArray) {
        this.arguments = stringArray;
    }

    public void setWFDB_PATH(String string) {
        logger.finest("\n\t***Setting WFDB to: " + string);
        this.WFDB_PATH = string;
    }

    public void setWFDBCAL(String string) {
        logger.finest("\n\t***Setting WFDBCAL to: " + string);
        this.WFDBCAL = string;
    }

    protected void setExecName(String string) {
        this.commandName = string;
    }

    public void setInitialWaitTime(long l) {
        this.initialWaitTime = l;
    }

    public void setWFDB_NATIVE_BIN(String string) {
        this.WFDB_NATIVE_BIN = string;
    }

    public void setCustomArchFlag(boolean bl) {
        customArchFlag = bl;
    }

    public void setExecutingDir(File file) {
        logger.finer("\n\t***Setting EXECUTING_DIR: " + file);
        EXECUTING_DIR = file;
    }

    private void gen_exec_arguments() {
        this.commandInput = new ArrayList<String>();
        this.commandInput.add(this.commandDir + this.commandName);
        logger.finest("\n\t***commandInput.add = " + this.commandDir + this.commandName);
        if (this.arguments != null) {
            for (String string : this.arguments) {
                this.commandInput.add(string);
            }
        }
    }

    public synchronized ArrayList<String> execToStringList() throws Exception {
        this.gen_exec_arguments();
        ArrayList<String> arrayList = new ArrayList<String>();
        ProcessBuilder processBuilder = this.setLauncher();
        logger.fine("\n\t***Executing Launcher with commandInput : \t" + this.commandInput);
        String string = null;
        try {
            long l;
            logger.finer("\n\t***Starting exec process...");
            Process process = processBuilder.start();
            logger.finer("\n\t***Creating read buffer and waiting for exec process...");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "US-ASCII"));
            logger.finest("\n\t***Waiting for data stream from launcher...");
            long l2 = l = System.currentTimeMillis();
            while (!bufferedReader.ready()) {
                if (l2 - l > this.initialWaitTime) {
                    logger.finest("Process data stream wait time exceeded (" + this.initialWaitTime + "  milliseconds )");
                    logger.finest("\n\t***Could not get data stream, exiting...");
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                l2 = System.currentTimeMillis();
            }
            if (bufferedReader.ready()) {
                logger.finest("\n\t***A was stream initialized, checking if data or err...");
            }
            while ((string = bufferedReader.readLine()) != null) {
                logger.finest("\n\t***Reading output: \n" + string);
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            System.err.println("error executing: " + this.commandName);
            exception.printStackTrace();
            return null;
        }
        return arrayList;
    }

    public synchronized ArrayList<String> execWithStandardInput(String[] stringArray) throws Exception {
        this.gen_exec_arguments();
        ProcessBuilder processBuilder = this.setLauncher();
        processBuilder.redirectErrorStream(true);
        Process process = null;
        int n = 1;
        ArrayList<String> arrayList = null;
        try {
            process = processBuilder.start();
            if (process != null) {
                OutputReader outputReader = new OutputReader(process.getInputStream());
                InputWriter object = new InputWriter(process.getOutputStream(), stringArray);
                object.start();
                outputReader.start();
                object.join();
                outputReader.join();
                arrayList = outputReader.getResults();
            }
            n = process.waitFor();
        }
        catch (IOException iOException) {
            System.err.println("Either couldn't read from the template file or couldn't write to the OutputStream.");
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        process.destroy();
        if (n != 0) {
            System.err.println("Process exited with errors!! Error code = " + n);
            for (String string : arrayList) {
                System.err.println(string);
            }
        }
        return arrayList;
    }

    public synchronized ArrayList<String> execWithStandardInput(byte[] byArray) throws Exception {
        this.gen_exec_arguments();
        ProcessBuilder processBuilder = this.setLauncher();
        processBuilder.redirectErrorStream(true);
        Process process = null;
        int n = 1;
        ArrayList<String> arrayList = null;
        try {
            process = processBuilder.start();
            if (process != null) {
                OutputReader outputReader = new OutputReader(process.getInputStream());
                InputWriter object = new InputWriter(process.getOutputStream(), byArray);
                object.start();
                outputReader.start();
                object.join();
                outputReader.join();
                arrayList = outputReader.getResults();
            }
            n = process.waitFor();
        }
        catch (IOException iOException) {
            System.err.println("Either couldn't read from the template file or couldn't write to the OutputStream.");
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        process.destroy();
        if (n != 0) {
            System.err.println("Process exited with errors!! Error code = " + n);
            for (String string : arrayList) {
                System.err.println(string);
            }
        }
        return arrayList;
    }

    public synchronized ArrayList<String> execWithStandardInput(double[][] dArray) throws Exception {
        String[] stringArray = new String[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            stringArray[i] = Double.toString(dArray[i][0]);
        }
        return this.execWithStandardInput(stringArray);
    }

    public synchronized ArrayList<String> execToStringList(String[] stringArray) throws Exception {
        this.setArguments(stringArray);
        return this.execToStringList();
    }

    public double[][] execToDoubleArray(String[] stringArray) throws Exception {
        this.setArguments(stringArray);
        this.gen_exec_arguments();
        ArrayList<Double[]> arrayList = new ArrayList<Double[]>();
        if (this.DoubleArrayListCapacity > 0) {
            arrayList.ensureCapacity(this.DoubleArrayListCapacity);
        }
        double[][] dArray = null;
        int n = -1;
        ProcessBuilder processBuilder = null;
        logger.finest("\n\t***Setting launcher in exectToDoubleArray");
        try {
            processBuilder = this.setLauncher();
            logger.finest("\n\t***Launcher created sucessfully in exectToDoubleArray");
        }
        catch (Exception exception) {
            System.err.println("***Error in setting the system launcher:" + exception.toString());
            exception.printStackTrace();
        }
        try {
            int n2;
            String string;
            long l;
            logger.finest("\n\t***Starting launcher in exectToDoubleArray");
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "US-ASCII"));
            String[] stringArray2 = null;
            Double[] doubleArray = null;
            char[] cArray = null;
            int n3 = 0;
            logger.finest("\n\t***Waiting for data stream from launcher...");
            long l2 = l = System.currentTimeMillis();
            while (!bufferedReader.ready()) {
                if (l2 - l > this.initialWaitTime) {
                    logger.finest("Process data stream wait time exceeded (" + this.initialWaitTime + "  milliseconds )");
                    logger.finest("\n\t***Could not get data stream, exiting...");
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                l2 = System.currentTimeMillis();
            }
            if (bufferedReader.ready()) {
                logger.finest("\n\t***Streamed communication received, checking if error or data...");
            }
            int n4 = 1;
            if (this.commandName.equals("rdann")) {
                while ((string = bufferedReader.readLine()) != null) {
                    stringArray2 = string.trim().split("\\s+");
                    doubleArray = new Double[]{Double.valueOf(stringArray2[1])};
                    if (arrayList.isEmpty() && n3 == stringArray2.length) {
                        System.err.println("Error: Cannot convert to double: ");
                        System.err.println(string);
                        throw new NumberFormatException("Cannot convert");
                    }
                    arrayList.add(doubleArray);
                }
            } else {
                while ((string = bufferedReader.readLine()) != null) {
                    stringArray2 = string.trim().split("\\s+");
                    doubleArray = new Double[stringArray2.length];
                    for (int i = 0; i < stringArray2.length; ++i) {
                        try {
                            doubleArray[i] = Double.valueOf(stringArray2[i]);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (stringArray2[i].equals("-")) {
                                doubleArray[i] = Double.NaN;
                                continue;
                            }
                            if (stringArray2[i].contains(":")) {
                                doubleArray[i] = Double.NaN;
                                if (n < 0) {
                                    n = i;
                                }
                                ++n3;
                                continue;
                            }
                            try {
                                cArray = stringArray2[i].toCharArray();
                                doubleArray[i] = cArray[0];
                                ++n3;
                                continue;
                            }
                            catch (Exception exception) {
                                System.err.println("Could not convert to double: " + string);
                                throw new Exception(exception.toString());
                            }
                        }
                    }
                    if (arrayList.isEmpty() && n3 == stringArray2.length) {
                        System.err.println("Error: Cannot convert to double: ");
                        System.err.println(string);
                        throw new NumberFormatException("Cannot convert");
                    }
                    arrayList.add(doubleArray);
                }
                n4 = stringArray2.length;
                if (n > -1) {
                    --n4;
                }
            }
            if ((n2 = process.waitFor()) != 0) {
                System.err.println("Command exited with non-zero status!!");
            }
            dArray = new double[arrayList.size()][n4];
            int n5 = 0;
            if (n > -1) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Double[] doubleArray2 = new Double[stringArray2.length];
                    doubleArray2 = (Double[])arrayList.get(i);
                    for (int j = 0; j < n4; ++j) {
                        if (n > -1 && j != n) {
                            n5 = j > n ? j - 1 : j;
                        }
                        dArray[i][n5] = doubleArray2[j];
                    }
                }
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Double[] doubleArray3 = new Double[stringArray2.length];
                    doubleArray3 = (Double[])arrayList.get(i);
                    for (int j = 0; j < n4; ++j) {
                        dArray[i][j] = doubleArray3[j];
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return dArray;
    }

    public ArrayList<Double> execToDoubleList(String[] stringArray) throws Exception {
        this.setArguments(stringArray);
        this.gen_exec_arguments();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (this.DoubleArrayListCapacity > 0) {
            arrayList.ensureCapacity(this.DoubleArrayListCapacity);
        }
        int n = -1;
        ProcessBuilder processBuilder = null;
        logger.finest("\n\t***Setting launcher in exectToDoubleArray");
        try {
            processBuilder = this.setLauncher();
            logger.finest("\n\t***Launcher created sucessfully in exectToDoubleArray");
        }
        catch (Exception exception) {
            System.err.println("***Error in setting the system launcher:" + exception.toString());
            exception.printStackTrace();
        }
        try {
            String string;
            long l;
            logger.finest("\n\t***Starting launcher in exectToDoubleArray");
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String[] stringArray2 = null;
            char[] cArray = null;
            logger.finest("\n\t***Waiting for data stream from launcher...");
            long l2 = l = System.currentTimeMillis();
            while (!bufferedReader.ready()) {
                if (l2 - l > this.initialWaitTime) {
                    logger.finest("Process data stream wait time exceeded (" + this.initialWaitTime + "  milliseconds )");
                    logger.finest("\n\t***Could not get data stream, exiting...");
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                l2 = System.currentTimeMillis();
            }
            if (bufferedReader.ready()) {
                logger.finest("\n\t***Streamed communication received, checking if error or data...");
            }
            while ((string = bufferedReader.readLine()) != null) {
                stringArray2 = string.trim().split("\\s+");
                for (int i = 0; i < stringArray2.length; ++i) {
                    try {
                        arrayList.add(Double.valueOf(stringArray2[i]));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (stringArray2[i].equals("-")) {
                            arrayList.add(Double.NaN);
                            continue;
                        }
                        if (stringArray2[i].contains(":")) {
                            arrayList.add(Double.NaN);
                            if (n >= 0) continue;
                            n = i;
                            continue;
                        }
                        try {
                            cArray = stringArray2[i].toCharArray();
                            arrayList.add(Double.valueOf(cArray[0]));
                            continue;
                        }
                        catch (Exception exception) {
                            System.err.println("Could not convert to double: " + string);
                            throw new Exception(exception.toString());
                        }
                    }
                }
            }
            int n2 = process.waitFor();
            if (n2 != 0) {
                System.err.println("Command exited with non-zero status!!");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return arrayList;
    }

    public float[][] execToFloatArray(String[] stringArray) throws Exception {
        this.setArguments(stringArray);
        this.gen_exec_arguments();
        ArrayList<Float[]> arrayList = new ArrayList<Float[]>();
        if (this.FloatArrayListCapacity > 0) {
            arrayList.ensureCapacity(this.FloatArrayListCapacity);
        }
        float[][] fArray = null;
        int n = -1;
        ProcessBuilder processBuilder = null;
        logger.finest("\n\t***Setting launcher in exectToFloatArray");
        try {
            processBuilder = this.setLauncher();
            logger.finest("\n\t***Launcher created sucessfully in exectToFloatArray");
        }
        catch (Exception exception) {
            System.err.println("***Error in setting the system launcher:" + exception.toString());
            exception.printStackTrace();
        }
        try {
            String string;
            long l;
            logger.finest("\n\t***Starting launcher in exectToFloatArray");
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String[] stringArray2 = null;
            Float[] floatArray = null;
            char[] cArray = null;
            int n2 = 0;
            logger.finest("\n\t***Waiting for data stream from launcher...");
            long l2 = l = System.currentTimeMillis();
            while (!bufferedReader.ready()) {
                if (l2 - l > this.initialWaitTime) {
                    logger.finest("Process data stream wait time exceeded (" + this.initialWaitTime + "  milliseconds )");
                    logger.finest("\n\t***Could not get data stream, exiting...");
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                l2 = System.currentTimeMillis();
            }
            if (bufferedReader.ready()) {
                logger.finest("\n\t***Streamed communication received, checking if error or data...");
            }
            while ((string = bufferedReader.readLine()) != null) {
                stringArray2 = string.trim().split("\\s+");
                floatArray = new Float[stringArray2.length];
                for (int i = 0; i < stringArray2.length; ++i) {
                    try {
                        floatArray[i] = Float.valueOf(stringArray2[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (stringArray2[i].equals("-")) {
                            floatArray[i] = Float.valueOf(Float.NaN);
                            continue;
                        }
                        if (stringArray2[i].contains(":")) {
                            floatArray[i] = Float.valueOf(Float.NaN);
                            if (n < 0) {
                                n = i;
                            }
                            ++n2;
                            continue;
                        }
                        try {
                            cArray = stringArray2[i].toCharArray();
                            floatArray[i] = Float.valueOf(cArray[0]);
                            ++n2;
                            continue;
                        }
                        catch (Exception exception) {
                            System.err.println("Could not convert to double: " + string);
                            throw new Exception(exception.toString());
                        }
                    }
                }
                if (arrayList.isEmpty() && n2 == stringArray2.length) {
                    System.err.println("Error: Cannot convert to double: ");
                    System.err.println(string);
                    throw new NumberFormatException("Cannot convert");
                }
                arrayList.add(floatArray);
            }
            int n3 = process.waitFor();
            if (n3 != 0) {
                System.err.println("Command exited with non-zero status!!");
            }
            int n4 = stringArray2.length;
            if (n > -1) {
                --n4;
            }
            fArray = new float[arrayList.size()][n4];
            int n5 = 0;
            if (n > -1) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Float[] floatArray2 = new Float[stringArray2.length];
                    floatArray2 = (Float[])arrayList.get(i);
                    for (int j = 0; j < n4; ++j) {
                        if (n > -1 && j != n) {
                            n5 = j > n ? j - 1 : j;
                        }
                        fArray[i][n5] = floatArray2[j].floatValue();
                    }
                }
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Float[] floatArray3 = new Float[stringArray2.length];
                    floatArray3 = (Float[])arrayList.get(i);
                    for (int j = 0; j < n4; ++j) {
                        fArray[i][j] = floatArray3[j].floatValue();
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return fArray;
    }

    public long[][] execToLongArray(String[] stringArray) throws Exception {
        this.setArguments(stringArray);
        this.gen_exec_arguments();
        ArrayList<Long[]> arrayList = new ArrayList<Long[]>();
        if (this.LongArrayListCapacity > 0) {
            arrayList.ensureCapacity(this.LongArrayListCapacity);
        }
        long[][] lArray = null;
        int n = -1;
        ProcessBuilder processBuilder = null;
        logger.finest("\n\t***Setting launcher in exectToLongArray");
        try {
            processBuilder = this.setLauncher();
            logger.finest("\n\t***Launcher created sucessfully in exectToLongArray");
        }
        catch (Exception exception) {
            System.err.println("***Error in setting the system launcher:" + exception.toString());
            exception.printStackTrace();
        }
        try {
            String string;
            long l;
            logger.finest("\n\t***Starting launcher in exectToLongArray");
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String[] stringArray2 = null;
            Long[] longArray = null;
            char[] cArray = null;
            int n2 = 0;
            logger.finest("\n\t***Waiting for data stream from launcher...");
            long l2 = l = System.currentTimeMillis();
            while (!bufferedReader.ready()) {
                if (l2 - l > this.initialWaitTime) {
                    logger.finest("Process data stream wait time exceeded (" + this.initialWaitTime + "  milliseconds )");
                    logger.finest("\n\t***Could not get data stream, exiting...");
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                l2 = System.currentTimeMillis();
            }
            if (bufferedReader.ready()) {
                logger.finest("\n\t***Streamed communication received, checking if error or data...");
            }
            while ((string = bufferedReader.readLine()) != null) {
                stringArray2 = string.trim().split("\\s+");
                longArray = new Long[stringArray2.length];
                for (int i = 0; i < stringArray2.length; ++i) {
                    try {
                        longArray[i] = Long.valueOf(stringArray2[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (stringArray2[i].equals("-")) {
                            longArray[i] = Long.MIN_VALUE;
                            continue;
                        }
                        if (stringArray2[i].contains(":")) {
                            longArray[i] = Long.MIN_VALUE;
                            if (n < 0) {
                                n = i;
                            }
                            ++n2;
                            continue;
                        }
                        try {
                            cArray = stringArray2[i].toCharArray();
                            longArray[i] = cArray[0];
                            ++n2;
                            continue;
                        }
                        catch (Exception exception) {
                            System.err.println("Could not convert to double: " + string);
                            throw new Exception(exception.toString());
                        }
                    }
                }
                if (arrayList.isEmpty() && n2 == stringArray2.length) {
                    System.err.println("Error: Cannot convert to double: ");
                    System.err.println(string);
                    throw new NumberFormatException("Cannot convert");
                }
                arrayList.add(longArray);
            }
            int n3 = process.waitFor();
            if (n3 != 0) {
                System.err.println("Command exited with non-zero status!!");
            }
            int n4 = stringArray2.length;
            if (n > -1) {
                --n4;
            }
            lArray = new long[arrayList.size()][n4];
            int n5 = 0;
            if (n > -1) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Long[] longArray2 = new Long[stringArray2.length];
                    longArray2 = (Long[])arrayList.get(i);
                    for (int j = 0; j < n4; ++j) {
                        if (n > -1 && j != n) {
                            n5 = j > n ? j - 1 : j;
                        }
                        lArray[i][n5] = longArray2[j];
                    }
                }
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Long[] longArray3 = new Long[stringArray2.length];
                    longArray3 = (Long[])arrayList.get(i);
                    for (int j = 0; j < n4; ++j) {
                        lArray[i][j] = longArray3[j];
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return lArray;
    }

    public short[][] execToShortArray(String[] stringArray) throws Exception {
        this.setArguments(stringArray);
        this.gen_exec_arguments();
        ArrayList<Short[]> arrayList = new ArrayList<Short[]>();
        if (this.ShortArrayListCapacity > 0) {
            arrayList.ensureCapacity(this.ShortArrayListCapacity);
        }
        short[][] sArray = null;
        int n = -1;
        ProcessBuilder processBuilder = null;
        logger.finest("\n\t***Setting launcher in exectToShortArray");
        try {
            processBuilder = this.setLauncher();
            logger.finest("\n\t***Launcher created sucessfully in exectToShortArray");
        }
        catch (Exception exception) {
            System.err.println("***Error in setting the system launcher:" + exception.toString());
            exception.printStackTrace();
        }
        try {
            String string;
            long l;
            logger.finest("\n\t***Starting launcher in exectToShortArray");
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String[] stringArray2 = null;
            Short[] shortArray = null;
            char[] cArray = null;
            int n2 = 0;
            logger.finest("\n\t***Waiting for data stream from launcher...");
            long l2 = l = System.currentTimeMillis();
            while (!bufferedReader.ready()) {
                if (l2 - l > this.initialWaitTime) {
                    logger.finest("Process data stream wait time exceeded (" + this.initialWaitTime + "  milliseconds )");
                    logger.finest("\n\t***Could not get data stream, exiting...");
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                l2 = System.currentTimeMillis();
            }
            if (bufferedReader.ready()) {
                logger.finest("\n\t***Streamed communication received, checking if error or data...");
            }
            while ((string = bufferedReader.readLine()) != null) {
                stringArray2 = string.trim().split("\\s+");
                shortArray = new Short[stringArray2.length];
                for (int i = 0; i < stringArray2.length; ++i) {
                    try {
                        shortArray[i] = Short.valueOf(stringArray2[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (stringArray2[i].equals("-")) {
                            shortArray[i] = Short.MIN_VALUE;
                            continue;
                        }
                        if (stringArray2[i].contains(":")) {
                            shortArray[i] = Short.MIN_VALUE;
                            if (n < 0) {
                                n = i;
                            }
                            ++n2;
                            continue;
                        }
                        try {
                            cArray = stringArray2[i].toCharArray();
                            shortArray[i] = (short)cArray[0];
                            ++n2;
                            continue;
                        }
                        catch (Exception exception) {
                            System.err.println("Could not convert to double: " + string);
                            throw new Exception(exception.toString());
                        }
                    }
                }
                if (arrayList.isEmpty() && n2 == stringArray2.length) {
                    System.err.println("Error: Cannot convert to double: ");
                    System.err.println(string);
                    throw new NumberFormatException("Cannot convert");
                }
                arrayList.add(shortArray);
            }
            int n3 = process.waitFor();
            if (n3 != 0) {
                System.err.println("Command exited with non-zero status!!");
            }
            int n4 = stringArray2.length;
            if (n > -1) {
                --n4;
            }
            sArray = new short[arrayList.size()][n4];
            int n5 = 0;
            if (n > -1) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Short[] shortArray2 = new Short[stringArray2.length];
                    shortArray2 = (Short[])arrayList.get(i);
                    for (int j = 0; j < n4; ++j) {
                        if (n > -1 && j != n) {
                            n5 = j > n ? j - 1 : j;
                        }
                        sArray[i][n5] = shortArray2[j];
                    }
                }
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Short[] shortArray3 = new Short[stringArray2.length];
                    shortArray3 = (Short[])arrayList.get(i);
                    for (int j = 0; j < n4; ++j) {
                        sArray[i][j] = shortArray3[j];
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return sArray;
    }

    public void loadCurl() {
        SystemSettings.loadCurl(customArchFlag);
    }

    private synchronized ProcessBuilder setLauncher() throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.redirectErrorStream(false);
        env = processBuilder.environment();
        env.put("java.library.path", this.LD_PATH);
        if (osName.contains("mac")) {
            env.put("DYLD_LIBRARY_PATH", this.LD_PATH);
            logger.finer("\n\t***setting: DYLD_LIBRARY_PATH: " + this.LD_PATH);
            env.put("PATH", this.LD_PATH);
            logger.finer("\n\t***setting: MacOs PATH: " + this.LD_PATH);
        } else if (osName.contains("windows")) {
            env.put("Path", this.LD_PATH);
            logger.finer("\n\t***setting: Windows Path: " + this.LD_PATH);
        } else if (osName.contains("linux")) {
            env.put("LD_LIBRARY_PATH", this.LD_PATH);
            logger.finer("\n\t***setting: Linux LD_LIBRARY_PATH: " + this.LD_PATH);
        } else {
            env.put("LD_LIBRARY_PATH", this.LD_PATH);
            logger.finer("\n\tsetting: ***Defaulting to Linux LD_LIBRARY_PATH: " + this.LD_PATH);
        }
        env.put("WFDBNOSORT", "1");
        if (this.WFDB_PATH != null) {
            env.put("WFDB", this.WFDB_PATH);
            logger.finer("\n\tsetting: **WFDB PATH: " + this.WFDB_PATH);
        }
        if (this.WFDBCAL != null) {
            env.put("WFDBCAL", this.WFDBCAL);
        }
        processBuilder.environment().put("WFDBNOSORT", "1");
        logger.finest("\n\t***Setting executing process with command and arguments: " + this.commandInput);
        processBuilder.command(this.commandInput);
        if (EXECUTING_DIR != null) {
            processBuilder.directory(EXECUTING_DIR);
        }
        this.setInitialWaitTime(1000L);
        return processBuilder;
    }

    public List<String> getEnvironment() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("WFDB_JAVA_HOME= " + WFDB_JAVA_HOME);
        logger.finer("\n\t***WFDB_JAVA_HOME: " + WFDB_JAVA_HOME);
        arrayList.add("WFDB_NATIVE_BIN= " + this.WFDB_NATIVE_BIN);
        logger.finer("\n\t***WFDB_NATIVE_BIN: " + this.WFDB_NATIVE_BIN);
        arrayList.add("EXECUTING_DIR= " + EXECUTING_DIR);
        logger.finer("\n\t***Exec dir: " + EXECUTING_DIR);
        arrayList.add("osName= " + osName);
        logger.finer("\n\t***OS: " + osName);
        arrayList.add("fullOsName= " + System.getProperty("os.name"));
        logger.finer("\n\t***fullOsName: " + System.getProperty("os.name"));
        arrayList.add("osArch= " + osArch);
        logger.finer("\n\t***OS Arch: " + osArch);
        arrayList.add("customArchFlag= " + customArchFlag);
        logger.finer("\n\t***customArchFlag: " + customArchFlag);
        arrayList.add("OS Version= " + System.getProperty("os.version"));
        logger.finer("\n\t***OS Version: " + System.getProperty("os.version"));
        arrayList.add("JVM Version= " + System.getProperty("java.version"));
        logger.finer("\n\t***JVM Version: " + System.getProperty("java.version"));
        return arrayList;
    }

    public void printEnvironment() {
        for (String string : env.keySet()) {
            if (string == null) {
                System.out.println("Environment is null");
                continue;
            }
            System.out.println(string + " = " + env.get(string));
        }
    }

    public void setDoubleArrayListCapacity(int n) {
        this.DoubleArrayListCapacity = n;
    }

    public void setFloatArrayListCapacity(int n) {
        this.FloatArrayListCapacity = n;
    }

    public void setLongArrayListCapacity(int n) {
        this.LongArrayListCapacity = n;
    }

    public void setShortArrayListCapacity(int n) {
        this.ShortArrayListCapacity = n;
    }

    public void setLogLevel(int n) {
        Level level;
        switch (n) {
            case 0: {
                level = Level.OFF;
                break;
            }
            case 1: {
                level = Level.SEVERE;
                break;
            }
            case 2: {
                level = Level.WARNING;
                break;
            }
            case 3: {
                level = Level.INFO;
                break;
            }
            case 4: {
                level = Level.FINEST;
                break;
            }
            case 5: {
                level = Level.ALL;
                break;
            }
            default: {
                level = Level.OFF;
            }
        }
        Handler[] handlerArray = Logger.getLogger("").getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            handlerArray[i].setLevel(level);
        }
        Logger.getLogger("org.physionet").setLevel(level);
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Level level = Level.FINEST;
        if (level != null) {
            object = Logger.getLogger("").getHandlers();
            for (int i = 0; i < ((Handler[])object).length; ++i) {
                object[i].setLevel(level);
            }
            Logger.getLogger("org.physionet.wfdb.Wfdbexec").setLevel(level);
            Logger.getLogger("org.physionet.wfdb.SystemSettings").setLevel(level);
        }
        object = new Wfdbexec(stringArray[0], Boolean.getBoolean(stringArray[1]));
        double[][] dArray = ((Wfdbexec)object).execToDoubleArray(Arrays.copyOfRange(stringArray, 1, stringArray.length));
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                System.out.print(dArray[i][j] + " ");
            }
            System.out.println("");
        }
    }

    static {
        EXECUTING_DIR = null;
        logger = Logger.getLogger(Wfdbexec.class.getName());
        customArchFlag = false;
    }
}

