/*
 * Decompiled with CFR 0.152.
 */
package org.physionet.wfdb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.physionet.wfdb.Wfdbexec;

public class SystemSettings {
    static String fsep = System.getProperty("file.separator");

    public static void loadCurl(Boolean bl) {
        if (SystemSettings.getOsName().contains("windows")) {
            System.load(SystemSettings.getWFDB_NATIVE_BIN(bl) + "\\bin\\libcurl-4.dll");
        } else if (SystemSettings.getOsName().contains("mac")) {
            String string = SystemSettings.getWFDB_NATIVE_BIN(bl) + "bin/libcurl.4.dylib";
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkLink(string);
            }
            System.load(string);
        }
    }

    private static void loadLib(String string, Boolean bl) {
        if (SystemSettings.getOsName().contains("windows")) {
            String string2 = SystemSettings.getWFDB_NATIVE_BIN(bl) + "bin\\";
            String string3 = string2 + "lib" + string + ".dep";
            try {
                String string4;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string3));
                while ((string4 = bufferedReader.readLine()) != null) {
                    System.load(string2 + string4);
                }
            }
            catch (IOException iOException) {
                throw new UnsatisfiedLinkError("error reading " + string3);
            }
            System.load(string2 + "lib" + string + ".dll");
        } else if (SystemSettings.getOsName().contains("mac")) {
            System.load(SystemSettings.getWFDB_NATIVE_BIN(bl) + "/lib/lib" + string + ".dylib");
        } else {
            System.load(SystemSettings.getWFDB_NATIVE_BIN(bl) + "/lib/lib" + string + ".so");
        }
    }

    public static void loadLib(String string) {
        try {
            SystemSettings.loadLib(string, true);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            SystemSettings.loadLib(string, false);
        }
    }

    public static String getosArch() {
        return System.getProperty("os.arch");
    }

    public static String getOsName() {
        String string = System.getProperty("os.name");
        string = string.replace(" ", "");
        if ((string = string.toLowerCase()).startsWith("windows")) {
            string = "windows";
        }
        return string;
    }

    public static String getLD_PATH(boolean bl) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        Map<String, String> map = processBuilder.environment();
        String string = "";
        String string2 = SystemSettings.getWFDB_NATIVE_BIN(bl);
        String string3 = SystemSettings.getOsName();
        String string4 = "";
        String string5 = "";
        if (string3.contains("windows")) {
            string = map.get("Path");
            string5 = ";";
            String string6 = "PATH";
            string4 = string2 + "bin" + string5 + string2 + "lib";
        } else if (string3.contains("macosx")) {
            string = map.get("DYLD_LIBRARY_PATH");
            string5 = ":";
            String string7 = "DYLD_LIBRARY_PATH";
            string4 = string2 + "bin" + string5 + string2 + "lib64" + string5 + string2 + "lib";
        } else {
            string = map.get("LD_LIBRARY_PATH");
            string5 = ":";
            String string8 = "LD_LIBRARY_PATH";
            string4 = string2 + "bin" + string5 + string2 + "lib64" + string5 + string2 + "lib";
        }
        if (string == null) {
            string = string4;
        } else if (string.indexOf(string4) < 0) {
            string = string4 + string5 + string;
        }
        return string;
    }

    public static int getNumberOfProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static String getWFDB_JAVA_HOME() {
        String string = null;
        try {
            string = URLDecoder.decode(Wfdbexec.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "utf-8");
            string = new File(string).getPath();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("Could not get path location of WFDB JAR file.");
            unsupportedEncodingException.printStackTrace();
        }
        int n = string.lastIndexOf(fsep);
        string = string.substring(0, n + 1);
        string = string.replace("file:", "");
        return string.toString();
    }

    public static synchronized String getWFDB_NATIVE_BIN(boolean bl) {
        String string = SystemSettings.getWFDB_JAVA_HOME();
        String string2 = bl ? string + "nativelibs" + fsep + "custom" + fsep : string + "nativelibs" + fsep + SystemSettings.getOsName().toLowerCase() + fsep;
        return string2;
    }
}

