#!/usr/bin/env python

import numpy as np, os, sys
import joblib
from get_12ECG_features import get_12ECG_features

def run_12ECG_classifier(data,header_data,loaded_model):


    # Use your classifier here to obtain a label and score for each class.
    model1 = loaded_model[0]['model']
    model2 = loaded_model[1]['model']
    model3 = loaded_model[2]['model']
    
    imputer = loaded_model[1]['imputer']
    classes = loaded_model[1]['classes']
    
    top1 = [int(t) for t in np.array([45, 43, 21, 19, 15, 39, 139, 49, 0, 25, 141, 457, 978, 1134, 649, 145, 1115, 959, 476, 805, 301, 630, 260, 117, 115, 320, 786, 135, 133, 127, 129, 918, 223, 379, 1037, 1056, 41, 242, 121, 17, 57, 55, 147, 589, 708, 166, 111, 727, 123, 47, 71, 398, 204, 51, 1076, 137, 44, 3, 998, 140, 1095, 104, 1017, 23, 35, 1122, 138, 821, 20, 143, 53, 7, 103, 109, 185, 63, 125, 665, 105, 116, 9, 813, 18, 939, 669, 1147, 42, 492, 464, 5, 67, 13, 114, 795, 610, 126, 825, 69, 743, 128, 747, 1170, 819, 688, 281, 73, 102, 1142, 6, 99, 1035, 131, 1150, 8, 1126, 336, 920, 30, 68, 484, 92, 11, 1074, 262, 820, 437, 134, 591, 98, 766, 803, 74, 414, 66, 75, 512, 33, 667, 31, 1151, 1166, 818, 2, 1124, 784, 56, 26, 793, 14, 399, 994, 797, 1149, 1072, 113, 400, 282, 110, 377, 119, 90, 1148, 37, 1057, 86, 728, 704, 38, 418, 416, 626, 62, 50, 1132, 78, 496, 1154, 32, 729, 81, 122, 16, 508, 489, 490, 77, 822, 491, 466, 745, 80, 258, 27, 628, 87, 359, 79, 220, 59, 28, 381, 124, 468, 54, 88, 91, 1058, 4, 340, 40, 65, 841, 1138, 64, 297, 474, 706, 136, 112, 100, 782, 93, 283, 1064, 107, 955, 1044, 710, 321, 182, 1033, 61, 101, 97, 650, 837, 463, 1121, 212, 29, 95, 480, 46, 83, 76, 1039, 375, 657, 192, 230, 979, 637, 1167, 809, 1155, 89, 593, 52, 493, 810, 1172, 798, 85, 966, 611, 941, 514, 980, 221, 1171, 826, 386, 711, 382, 940, 800, 922, 264, 509, 923, 811, 48, 909, 590, 1135, 24, 144, 1224, 510, 1040, 130, 594, 10, 328, 22, 814, 513, 806, 788, 406, 12, 453, 132, 792, 1168, 651, 1245, 250, 799, 1136, 540, 322, 919, 1117, 265, 261, 515, 308, 842, 860, 908, 838, 1114, 823, 1139, 892, 477, 839, 532, 612, 916, 843, 566, 1186, 538, 1189, 986, 1118, 807, 875, 1127, 1111, 60, 1233, 789, 304, 142, 1236, 82, 893, 1060, 70, 801, 271, 880, 1173, 303, 1205, 870, 205, 844, 1217, 537, 459, 912, 895, 815, 597, 1226, 1196, 541, 1225, 1213, 529, 879, 1238, 259, 856, 1181, 106, 478, 1116, 108, 575, 385, 511, 633, 547, 1204, 579, 550, 705, 840, 1129, 576, 1229, 167, 460, 878, 58])]
 
    top2 = [int(t) for t in np.array([784, 667, 628, 745, 706, 589, 39, 135, 123, 45, 43, 49, 260, 51, 0, 512, 15, 27, 918, 1170, 3, 13, 99, 31, 139, 41, 996, 33, 141, 55, 47, 57, 1057, 137, 133, 19, 125, 21, 1058, 7, 841, 399, 81, 79, 129, 53, 109, 11, 1166, 400, 17, 145, 75, 728, 121, 9, 1035, 42, 87, 77, 111, 25, 91, 729, 29, 8, 131, 704, 127, 416, 98, 377, 5, 1074, 23, 116, 114, 922, 83, 338, 143, 381, 103, 113, 93, 119, 63, 101, 105, 102, 90, 508, 1171, 44, 89, 92, 86, 299, 837, 743, 650, 980, 509, 513, 85, 1039, 651, 265, 321, 67, 979, 923, 65, 95, 961, 283, 957, 18, 322, 375, 97, 303, 842, 1167, 1117, 104, 459, 138, 789, 59, 6, 1118, 117, 460, 710, 1235, 264, 665, 69, 906, 788, 54, 593, 414, 863, 140, 110, 78, 32, 122, 612, 1192, 128, 825, 35, 941, 1033, 633, 71, 107, 56, 126, 14, 1147, 74, 632, 115, 30, 718, 594, 304, 80, 919, 838, 61, 382, 282, 1072, 1126, 708, 220, 591, 379, 962, 786, 262, 20, 1037, 611, 2, 940, 455, 73, 577, 534, 920, 1115, 1040, 818, 68, 669, 797, 100, 167, 182, 26, 478, 1154, 1134, 66, 711, 1017, 1047, 62, 38, 821, 998, 336, 258, 457, 1113, 50, 243, 807, 590, 959, 921, 688, 223, 477, 805, 168, 696, 37, 4, 340, 1150, 938, 994, 496, 88, 134, 244, 909, 225, 261, 1136, 492, 132, 124, 205, 1135, 609, 1151, 389, 112, 630, 108, 476, 744, 120, 48, 747, 118, 1076, 908, 367, 149, 1224, 206, 301, 1142, 489, 361, 1019, 96, 418, 676, 263, 359, 84, 1073, 1111, 782, 1122, 690, 94, 360, 46, 592, 816, 580, 689, 16, 1232, 1236, 106, 806, 147, 76, 342, 1000, 24, 136, 280, 1240, 453, 144, 1005, 28, 40, 701, 130, 185, 1244, 347, 1095, 468, 64, 1018, 188, 794, 150, 12, 578, 1001, 226, 819, 1238, 1025, 1097, 1132, 420, 600, 680, 978, 82, 895, 187, 343, 415, 1124, 22, 602, 1116, 490, 820, 671, 10, 915, 297, 623, 907, 1114, 1155, 903, 1148, 624, 822, 1079, 421, 715, 142, 1149, 579, 411, 803, 911, 1145, 439, 1138, 768, 795, 514, 1044, 955, 242, 767, 956, 320, 281, 766, 750, 952, 931, 997, 566, 813, 675, 60, 610, 493, 504, 1061, 390, 649, 1096, 52, 631, 1123])]
    top3 = [int(t) for t in np.array([784, 667, 628, 745, 706, 589, 39, 135, 123, 45, 43, 49, 260, 51, 0, 512, 15, 27, 918, 1170, 3, 13, 99, 31, 139, 41, 996, 33, 141, 55, 47, 57, 1057, 137, 133, 19, 125, 21, 1058, 7, 841, 399, 81, 79, 129, 53, 109, 11, 1166, 400, 17, 145, 75, 728, 121, 9, 1035, 42, 87, 77, 111, 25, 91, 729, 29, 8, 131, 704, 127, 416, 98, 377, 5, 1074, 23, 116, 114, 922, 83, 338, 143, 381, 103, 113, 93, 119, 63, 101, 105, 102, 90, 508, 1171, 44, 89, 92, 86, 299, 837, 743, 650, 980, 509, 513, 85, 1039, 651, 265, 321, 67, 979, 923, 65, 95, 961, 283, 957, 18, 322, 375, 97, 303, 842, 1167, 1117, 104, 459, 138, 789, 59, 6])]
    
    
    features=np.asarray(get_12ECG_features(data,header_data))
    
    feats_reshape = features.reshape(1, -1)
    feats_reshape = imputer.transform(feats_reshape)
    current_label = model1.predict([[feats_reshape[0][t] for t in top1]])[0]
#    current_label = model1.predict(feats_reshape)[0]
    current_label=current_label.astype(int)
    #print(current_label)
    if current_label==1:
        #feats_reshape = [np.append(feats_reshape,current_label)]
        #current_label = model2.predict(feats_reshape)[0]

#        current_score = model2.predict_proba(feats_reshape)
        current_score = model2.predict_proba([[feats_reshape[0][t] for t in top2]])
         
    else:
        #current_label = model3.predict(feats_reshape)[0]
#        current_score = model3.predict_proba(feats_reshape)
        current_score = model3.predict_proba([[feats_reshape[0][t] for t in top3]])
    
    
    for k in np.arange(len(current_score)):
        if len(np.array(current_score[k][0]))==1:
            current_score[k] = np.array([[np.array(current_score[k][0])[0],0]])
    
    current_score=np.asarray(current_score)
    current_score=current_score[:,0,1]
    
    #get labels using probabilities
    score=np.copy(current_score)
    threshold = 3/len(score)
    cutoff = 3
    if max(score)<10/len(score) and max(score)>= 3/len(score):
        cutoff=4
    elif max(score)>10/len(score):
        threshold = 10/len(score)
        
    current_label = np.array(np.zeros(len(score)))
    
    for i in range(len(score)):
        s = np.array(score).flatten()
        s.sort()
        if score[i] >= max(threshold,s[-cutoff]):
            current_label[i] = 1
    
    current_label=current_label.astype(int)
    
    return current_label, current_score,classes

def load_12ECG_model(input_directory):
    # load the model from disk 
    f_out1='finalized_model_1.sav'
    f_out2='finalized_model_2.sav'
    f_out3='finalized_model_3.sav'
    
    filename1 = os.path.join(input_directory,f_out1)
    filename2 = os.path.join(input_directory,f_out2)
    filename3 = os.path.join(input_directory,f_out3)

    loaded_model1 = joblib.load(filename1)
    loaded_model2 = joblib.load(filename2)
    loaded_model3 = joblib.load(filename3)

    return loaded_model1, loaded_model2, loaded_model3
