# Copyright 2020, TATA Consultancy Services. All rights reserved.
# import tensorflow as tf
# from keras import backend as K
# from keras.layers import Layer
# from tensorflow.keras.models import Sequential
# from tensorflow.keras.layers import Dense, Conv2D, Flatten
# 4. Set `tensorflow` pseudo-random generator at a fixed value
# seed_value = 20
# tf.compat.v1.set_random_seed(seed_value)

# Copyright 2020, TATA Consultancy Services. All rights reserved.
# import tensorflow
# from tf.keras.models import Sequential
# import tensorflow
# seed_value = 42
# seed = 42
# tensorflow.compat.v1.set_random_seed(seed_value)
# tensorflow.random.set_seed(seed)
import tensorflow 
from tensorflow.keras.layers import Input, Dense, Conv2D, Flatten, MaxPooling2D,Activation,BatchNormalization,Dropout,concatenate
from tensorflow.keras.models import Model
from CNNetR import CNNetR

#===================================================
# import tensorflow as tf
# 4. Set `tensorflow` pseudo-random generator at a fixed value
# seed_value = 20


def CNNet(nrw,ncl,num_classes):
    
    # model = Sequential() # add model layers
    # model.add(Conv2D(32, (3, 3),padding="same",
    #                   input_shape=(nrw,ncl,1)))
    # model.add(Activation("relu"))
    # model.add(BatchNormalization(axis=2))
    # model.add(MaxPooling2D(pool_size=(3, 3)))
    # model.add(Dropout(0.2))
    # #
    # model.add(Conv2D(64, (3, 3), padding="same"))
    # model.add(Activation("relu"))
    # model.add(BatchNormalization(axis=2))
    # model.add(Conv2D(64, (3, 3), padding="same"))
    # model.add(Activation("relu"))
    # model.add(BatchNormalization(axis=2))
    # model.add(MaxPooling2D(pool_size=(2, 2)))
    # model.add(Dropout(0.2))
    # #
    # model.add(Conv2D(128, (3, 3), padding="same"))
    # model.add(Activation("relu"))
    # model.add(BatchNormalization(axis=2))
    # model.add(Conv2D(128, (3, 3), padding="same"))
    # model.add(Activation("relu"))
    # model.add(BatchNormalization(axis=2))
    # model.add(MaxPooling2D(pool_size=(2, 2)))
    # model.add(Dropout(0.5))
    # model.add(Flatten())
    # model.add(Dense(num_classes, activation='sigmoid'))#sigmoid
    # return model
    
    
    # model.add(Dense(256, activation='sigmoid'))#sigmoid
    # model.add(Dropout(0.5))
    # model.add(Dense(num_classes, activation='softmax'))#sigmoid
    # model = Sequential() # add model layers
    # model.add(Conv2D(32, (3, 3),padding="same",
    #                  input_shape=(nrw,ncl,1)))
    # model.add(Activation("relu"))
    # model.add(BatchNormalization(axis=2))
    # model.add(MaxPooling2D(pool_size=(3, 3)))
    # model.add(Dropout(0.25))
    # #
    # model.add(Conv2D(64, (3, 3), padding="same"))
    # model.add(Activation("relu"))
    # model.add(BatchNormalization(axis=2))    
    # model.add(Conv2D(64, (3, 3), padding="same"))
    # model.add(Activation("relu"))
    # model.add(BatchNormalization(axis=2))
    # model.add(MaxPooling2D(pool_size=(3, 3)))
    # model.add(Dropout(0.25))
    
    # model.add(Conv2D(128, (3, 3), padding="same"))
    # model.add(Activation("relu"))
    # model.add(BatchNormalization(axis=2))    
    # model.add(Conv2D(128, (3, 3), padding="same"))
    # model.add(Activation("relu"))
    # model.add(BatchNormalization(axis=2))
    # model.add(MaxPooling2D(pool_size=(3, 3)))
    # model.add(Dropout(0.25))

    # model.add(Conv2D(256, (3, 3), padding="same"))
    # model.add(Activation("relu"))
    # model.add(BatchNormalization(axis=2))    
    # model.add(Conv2D(256, (3, 3), padding="same"))
    # model.add(Activation("relu"))
    # model.add(BatchNormalization(axis=2))
    # model.add(MaxPooling2D(pool_size=(3, 3)))
    # model.add(Dropout(0.25))

  
    # model.add(Flatten())
    # model.add(Dense(128, activation='sigmoid'))
    # model.add(Dropout(0.5))
    # model.add(Dense(num_classes, activation='sigmoid'))
    # model.add(Dropout(0.5))

    # Resnet model
    input_resnet = Input(shape=(ncl, 1),
                   dtype='float32',
                   name='inputs')
    # Resnet output needs to be a flattened layer
    output_resnet = CNNetR(input_resnet)

    inputA = Input(shape=(nrw,ncl,1))
    outputA = Conv2D(filters=32, kernel_size=(3, 3),padding="same", activation='relu')(inputA)
    outputA = BatchNormalization(axis=2)(outputA)
    outputA = MaxPooling2D(pool_size=(3, 3))(outputA)
    outputA = Dropout(0.2)(outputA)
    
    outputA = Conv2D(filters=32, kernel_size=(3, 3),padding="same", activation='relu')(outputA)
    outputA = BatchNormalization(axis=2)(outputA)
    outputA = Conv2D(filters=32, kernel_size=(3, 3),padding="same", activation='relu')(outputA)
    outputA = BatchNormalization(axis=2)(outputA)
    outputA = MaxPooling2D(pool_size=(2, 2))(outputA)
    outputA = Dropout(0.2)(outputA)
    
    outputA = Conv2D(filters=32, kernel_size=(3, 3),padding="same", activation='relu')(outputA)
    outputA = BatchNormalization(axis=2)(outputA)
    outputA = Conv2D(filters=32, kernel_size=(3, 3),padding="same", activation='relu')(outputA)
    outputA = BatchNormalization(axis=2)(outputA)
    outputA = MaxPooling2D(pool_size=(2, 2))(outputA)
    outputA = Dropout(0.5)(outputA)
    
    # outputA = MaxPooling2D(pool_size=2)(outputA)
    # outputA = Conv2D(filters=64, kernel_size=5, activation='relu')(outputA)

    # outputA = Dropout(0.5)(outputA)
    # outputA = MaxPooling2D(pool_size=2)(outputA)
    # outputA = Conv2D(filters=64, kernel_size=5, activation='relu')(outputA)

    # outputA = Dropout(0.5)(outputA)
    # outputA = MaxPooling2D(pool_size=2)(outputA)

    outputA = Flatten()(outputA)
    ext_feat = Input(shape=(14,))
    concat_feat = concatenate([outputA, ext_feat],axis=1)
    # ext_feat = Input(shape=(50,))
#    ext_feat = ext_feat.reshape(ext_feat.shape[0],ext_feat.shape[1])
    concat_feat = concatenate([outputA, output_resnet, ext_feat])

    output = Dense(num_classes, activation='sigmoid')(concat_feat)
    # output = Dropout(0.5)(output)
    
    # output = Dense(64, activation='relu')(output)
    # output = Dropout(0.5)(output)
    # output = Dense(num_classes, activation='softmax')(output)
    
    # model = Model([inputA,ext_feat], [output])
    model = Model([inputA,input_resnet,ext_feat], [output])
    # model = Model([inputA], [output])

    #from tensorflow.keras.utils import plot_model
    #print(model.summary())
    #plot_model(model, to_file='multiple_inputs.png')

    return model
