#!/usr/bin/env python

import numpy as np, os, sys
import joblib
import get_12ECG_features
import constants

def run_12ECG_classifier(data,header_data,loaded_model):
    classifier = loaded_model['xgb_binary_classifier']

    feature, _ = get_12ECG_features.GenerateEngFeature([data[[1,6],:]],[header_data],0, constants.NUM_CORES)
    # pred = classifier.predict(feature[0])
    # score = classifier.predict_proba(feature[0])

    # feats_reshape = feature.reshape(1, -1)
    current_label = classifier.predict(feature)[0]
    current_label=current_label.astype(int)
    # print(current_label)

    current_score = [prob[0][0] for prob in classifier.predict_proba(feature)]
    # current_score = classifier.predict_proba(feature)
    # print(np.array(current_score))
    # current_score=np.asarray(current_score)
    # current_score=current_score[:,0,1]

    # result1 = np.array([int(i) for i in bin(pred).split('b')[1]])
    # result = np.pad(arr, (0,len(constants.LABELS) - len(result1)), 'constant')

    # scores = [clasf.predict_proba(feature)[0] for clasf in classifier]
    # labels = [clasf.predict(feature)[0] for clasf in classifier]

    return current_label, current_score, constants.LABELS

    # num_leads, ptID, gender, age,sample_Fs, lead_info = utility.parse_hea_file(header_data)

    # filtered_lead = []
    # r_peaks = []
    # for en in data:
    #     filtered_data = utility.filter_lead(en, sample_Fs)
    #     r_peak = utility.detect_peaks_1(filtered_data, sample_Fs)
    #     filtered_lead.append(filtered_data)
    #     r_peaks.append(r_peak)

    # peak_distances = np.diff(r_peaks)
    # avg_peak_distance = np.average(peak_distances)
    # std_peak_distance = np.std(peak_distances)


    # # Use your classifier here to obtain a label and score for each class.
    # model = loaded_model['model']
    # imputer = loaded_model['imputer']
    # classes = loaded_model['classes']

    # features=np.asarray(get_12ECG_features(data,header_data))
    # feats_reshape = features.reshape(1, -1)
    # feats_reshape = imputer.transform(feats_reshape)
    # current_label = model.predict(feats_reshape)[0]
    # current_label=current_label.astype(int)
    # current_score = model.predict_proba(feats_reshape)
    # current_score=np.asarray(current_score)
    # current_score=current_score[:,0,1]

    return current_label, current_score, classes

def load_12ECG_model(input_directory):
    filename = os.path.join(input_directory, 'xgb_classifier.sav')

    # fits = []
    # for label in constants.LABELS:
    #     filename = os.path.join(input_directory,  'xgb_classifier' + str(label) + '.sav')
    #     fits.append(joblib.load(filename)['model'])
    # # load the model from disk
    # # f_out='xgb_classifier.sav'
    # # filename = os.path.join(input_directory,f_out)
    # # loaded_model = joblib.load(filename)

    return {
        'xgb_binary_classifier' :  joblib.load(filename)['model']
    }
