#!/usr/bin/env python

import numpy as np, os, sys
import joblib
from get_12ECG_features import get_12ECG_features
from train_12ECG_classifier import generate_single_template

def run_12ECG_classifier(data,header_data,loaded_model):


    # Use your classifier here to obtain a label and score for each class.
    # Use your classifier here to obtain a label and score for each class.
    model = loaded_model[0]
    classes = loaded_model[1]
    best_thr = loaded_model[2]
    # Use your classifier here to obtain a label and score for each class.
    

    features=generate_single_template(data, header_data)
    #print(len(features))
    #print(features)
    feats_reshape = features.reshape(1,len(features), -1)
    #feats_reshape = imputer.transform(feats_reshape)
    current_label = model.predict(feats_reshape)
    
    #print(current_label)
    current_label=(current_label>best_thr).astype(int)
    current_label = list(current_label)

    #print(current_label)
    current_score = model.predict(feats_reshape)
    current_score=np.asarray(current_label)
    current_score = list(current_score)    

    #current_score=current_score[:,0,1]
    current_score = current_score/np.array(current_score).max()


    return current_label[0], current_score[0],classes



def load_12ECG_model(input_directory):

    # load the model from disk 
    f_out='finalized_model.h5'
    filename = os.path.join(input_directory,f_out)

    #loaded_model = joblib.load(filename)
    from numpy import loadtxt
    from keras.models import load_model
 
    model = load_model(filename)
    
    f_out='finalized_model.sav'
    filename = os.path.join(input_directory,f_out)

    #loaded_model = joblib.load(filename)
    savfile = joblib.load(filename)
    classes = savfile['classes']
    best_thr = savfile['best_thr']
    # load model
    loaded_model = [model, classes, best_thr]
    return loaded_model
