function  model = train_12ECG_classifier(input_directory,output_directory)

disp('Loading data...')

% Find files.
input_files = {};
for f = dir(input_directory)'
    if exist(fullfile(input_directory, f.name), 'file') == 2 && f.name(1) ~= '.' && all(f.name(end - 2 : end) == 'mat')
        input_files{end + 1} = f.name;
    end
end

% read number of unique classes
classes = get_classes(input_directory,input_files);
[classesAll,lenClasses,classesAllu] = get_classesEach(input_directory,input_files);
num_classes = length(classes);
num_files = length(input_files);



vecClassification=zeros(length(classesAll),length(classesAllu));
for i=1:length(classesAll)
    zclasses=classesAll{i};
    for k=1:length(zclasses)
        Index = find(contains(classesAllu,zclasses(k)));
        vecClassification(i,Index)=1;
    end
end
% save('second1');
disp('Training model..')

label=zeros(num_files,num_classes);
featuresAll={};
noParts=[];
noZeros={};
label=vecClassification;
sourcesChar={'A';'Q';'H';'E';'S';'I'};
sourcesAll={};

for i = 1:num_files
    disp(['    ', num2str(i), '/', num2str(num_files), '...']);
    file_tmp=strsplit(input_files{i},'.');
    tmp_input_file = fullfile(input_directory, file_tmp{1});
    valSource=zeros(1,6);
    for istr=1:length(sourcesChar)
        idx=strfind(tmp_input_file,sourcesChar{istr});
        if length(idx)>1
            idx=idx(end);
        end
        if isempty(idx)==0
            valSource(istr)=idx;
        end
    end
    [sourceMax,sourceIdx]=max(valSource);
    if sourceMax>0
        sourcesAll{i}=sourceIdx;
    else
        sourcesAll{i}=0;
    end
    
    [data,header_data] = load_challenge_data(tmp_input_file);
    %     data = Total_data{i};
    %     header_data = Total_header{i};
    featuresAdded = get_12ECG_features(header_data);
    featuresAddedall{i}=featuresAdded;
    %     tmp_features = get_12ECG_features(data,header_data);
    
    [featuresAll{i},noParts(i),noZeros{i}]=challengeUbasic(tmp_input_file,classesAll{i});
    %     features(i,:)=tmp_features;
end
sourcesAll=cell2mat(sourcesAll);
% save('set1');
% load set1
sourcesAll=sourcesAll(:);
%save('main1')
%save('set01');
% % load first1
% sourcesAll=zeros(sum(noParts),1);
% % save('first1');
newFeaturesMed=zeros(sum(noParts),size(featuresAll{1}{1}{1},2));
newFeaturesStd=zeros(sum(noParts),size(featuresAll{1}{1}{1},2));
newFeaturesMin=zeros(sum(noParts),size(featuresAll{1}{1}{1},2));
newFeaturesMax=zeros(sum(noParts),size(featuresAll{1}{1}{1},2));
% newFeaturesMean=zeros(sum(noParts),size(featuresAll{1}{1}{1},2));
featuresAddedallI=zeros(sum(noParts),size(featuresAddedall{1},2));

%     ik=0;
iz=0;
vecClassificationAll=[];
sourcesAlla=[];
for i=1:num_files
    i
    for kk=1:noParts(i)
        iz=iz+1;
        cfeature=featuresAll{i}{kk};
        cfeaturesMat=zeros(length(cfeature),size(featuresAll{1}{1}{1},2));
        
        for j=1:length(cfeature)
            %                 czeros=noZeros{i}(kk,j);
            cfeaturesMat(j,:)=cfeature{j};
        end
        ffzeros=find(noZeros{i}(kk,:)==1);
        if length(ffzeros)==1
            newFeaturesMed(iz,:)=(cfeaturesMat(ffzeros,:));
            newFeaturesStd(iz,:)=(cfeaturesMat(ffzeros,:));
            newFeaturesMax(iz,:)=(cfeaturesMat(ffzeros,:));
            newFeaturesMin(iz,:)=(cfeaturesMat(ffzeros,:));
            
        else
            if isempty(ffzeros)==1
                ffzeros=[1,2];
            end
            
            newFeaturesMed(iz,:)=median(cfeaturesMat(ffzeros,:));
            newFeaturesStd(iz,:)=std(cfeaturesMat(ffzeros,:));
            newFeaturesMax(iz,:)=max(cfeaturesMat(ffzeros,:));
            newFeaturesMin(iz,:)=min(cfeaturesMat(ffzeros,:));
        end
        vecClassificationAll(iz,:)=vecClassification(i,:);
        sourcesAlla(iz)=sourcesAll(i);
        featuresAddedallI(iz,:)=featuresAddedall{i};
    end
end
sourcesAlla=sourcesAlla(:);
theFeatures=[newFeaturesMed,newFeaturesStd,newFeaturesMin,newFeaturesMax];
selectedFeaturesAll=[];%should be 27 * 1000 or such

%first try with all features

mainClasses= [{'270492004'},{'164889003'},{'164890007'},{'426627000'},{'713427006'},{'713426002'},{'445118002'},{'39732003' },{'164909002'},{'251146004'},{'698252002'},{'10370003' },{'284470004'},{'427172004'},{'164947007'},{'111975006'},{'164917005'},{'47665007' },{'59118001' },{'427393009'},{'426177001'},{'426783006'},{'427084000'},{'63593006' },{'164934002'},{'59931005' },{'17338001' }];
correctIndices=zeros(1,27);
for i=1:length(mainClasses)
    for j=1:length(classesAllu)
        if strcmp(classesAllu{j},mainClasses{i})
            correctIndices(i)=j;
            break;
        end
    end
end
numberSamplesPerClass=sum(vecClassification);

numberOfClasses=27;

% sett={'RUSBoost','GentleBoost','GentleBoost','RUSBoost','RUSBoost','GentleBoost','RUSBoost','GentleBoost','RUSBoost','RUSBoost',...
%     'GentleBoost','RUSBoost','RUSBoost','GentleBoost','GentleBoost','RUSBoost','GentleBoost','GentleBoost','RUSBoost','RUSBoost',...
%     'RUSBoost','GentleBoost','RUSBoost','GentleBoost','RUSBoost','GentleBoost','RUSBoost'};
%Assume minmax
sett={'RUSBoost','GentleBoost','GentleBoost','RUSBoost','RUSBoost','GentleBoost','RUSBoost','GentleBoost','RUSBoost','RUSBoost',...
    'GentleBoost','RUSBoost','RUSBoost','GentleBoost','GentleBoost','RUSBoost','RUSBoost','GentleBoost','RUSBoost','RUSBoost',...
    'RUSBoost','GentleBoost','RUSBoost','GentleBoost','RUSBoost','GentleBoost','RUSBoost'};
%Assume minmax
selectedFeatures={};
for i=1:27
    selectedFeatures{i}=1:size(theFeatures,2);
end
selectedFeatures{2}=[1,2,3,4,5,6,10,11,12,23,25,27,28,29,30,31,37,39,40,41,44,45,46,47,48,49,51,52,53,54,56,58,59,63,64,65,73,74,75,76,77,78,79,85,87,88,89,91,92,93,95,96,103,104,109,115,116,117,118,119,120,123,124,126,127,128,129,130,131,132,133,134,136,145,146,148,149,150,151,152,155,157,161,162,193,202,206,208,209,211,213,214,218,220,223,224,225,226,228,229,230,232,233,234,235,240,242,244,245,246,247,249,250,251,252,254,255,256,257,259,263,265,266,268,270,271,272,273,276,299,300,301,304,306,307,308,309,310,311,312,314,315,316,317,319,320,321,324,327,328,329,332,334,339,340,341,342,344,346,347,348,349,350,352,354,357,358,359,362,363,364,368,370,373,374,376,377,379,380,381,384,385,392,393,394,395,396,397,404,405,406,407,408,409,415,416,417,418,419,420,421,427,428,431,432,433,439,440,441,442,443,444,446,448,453,455,456,457,461,462,463,466,468,469,470,473,475,476,477,479,480,481,482,483,484,486,487,488,489,490,491,492,493,494,497,498,501,502,503,504,505,508,509,511,512,513,517,519,520,521,523,524,526,527,528,529,531,533,540,541,542,543,544,546,547,549,550,551,552,553,554,555,556,557,558,559,560,561,563,565,566,567,568,569,570,571,572,573,574,575,576,577,579,580,581,582,583,584,585,586,587,588,589,590,591,592,593,594,595,596,597,598,599,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,616,617,618,619,620,622,623,624,625,626,628,630,631,632,633,634,635,636,637,638,641,644,646,647,649,650,651,652,653,654,655,657,658,659,662,663,665,667,668,669,671,672,676,678,683,685,691,693,695,700,702,704,705,706,708,709,710,711,712,715,717,718,719,720,721,722,723,724,725,726,728,729,730,731,732,733,735,736,737,739,740,742,743,744,746,748,750,751,753,756,761,762,763,765,766,767,768,769,770,771,775,777,780,781,782,783,784,785,787,788,789,790,791,792,793,794,795,796,797,798,799,804,805,813,814,815,816,818,825,826,827,829,830,831,833,834,835,836,843,844,857,858,859,860,861,862,863,865,867,868,871,872,873,874,875,877,878,885,886,887,888,891,894,895,897,899,902,941,943,946,947,949,951,954,958,959,965,966,968,969,970,971,973,974,975,979,980,982,985,986,987,989,990,991,994,998,1000,1001,1005,1006,1008,1010,1011,1012,1013,1015,1016,1038,1039,1040,1041,1043,1046,1047,1048,1049,1051,1052,1053,1054,1058,1060,1061,1062,1064,1067,1068,1069,1075,1079,1080,1081,1082,1085,1086,1088,1089,1090,1091,1092,1093,1094,1097,1098,1101,1102,1103,1106,1107,1110,1112,1114,1115,1116,1117,1118,1122,1124,1125,1132,1133,1134,1135,1136,1137,1144,1145,1147,1148,1149,1156,1158,1159,1160,1161,1168,1170,1171,1173,1179,1180,1183,1184,1185,1186,1188,1189,1190,1191,1193,1194,1195,1196,1198,1201,1202,1203,1204,1205,1207,1209,1210,1211,1212,1213,1214,1216,1219,1220,1222,1224,1225,1226,1227,1228,1229,1230,1231,1232,1233,1234,1235,1236,1237,1238,1239,1240,1241,1242,1245,1250,1251,1252,1253,1254,1256,1257,1258,1259,1260,1262,1263,1264,1265,1266,1271,1281,1282,1287,1288,1289,1290,1291,1292,1293,1294,1295,1296,1297,1298,1299,1300,1301,1303,1305,1308,1316,1318,1320,1322,1323,1324,1325,1326,1328,1331,1332,1333,1334,1336,1340,1341,1342,1343,1357,1359,1360,1365,1367,1369,1370,1371,1373,1374,1375,1376,1378,1381,1382,1384,1385,1386,1387,1388,1389,1390,1391,1392,1393,1394,1395,1396,1397,1398,1399,1401,1403,1405,1415,1417,1418,1419,1420,1425,1429,1434,1435,1437,1440,1443,1444,1446,1447,1448,1449,1450,1451,1456,1458,1459,1460,1461,1462,1464,1465,1466,1467,1468,1469,1470,1471,1472,1473,1474,1475,1476,1477,1478,1479,1480];
selectedFeatures{3}=[1:round(size(theFeatures,2)/2),round(3*size(theFeatures,2)/4)+1:size(theFeatures,2)];%max
selectedFeatures{5}=[1:round(3*size(theFeatures,2)/4)];%min
selectedFeatures{6}=[10,11,12,18,24,25,28,29,40,43,45,49,50,54,56,57,59,60,61,64,65,73,89,91,95,104,118,119,124,126,127,128,135,136,148,150,152,157,162,194,198,223,224,225,232,239,240,242,246,249,250,251,252,254,255,256,258,259,261,265,268,270,271,273,275,276,298,299,300,301,303,306,307,308,310,311,312,313,314,316,317,319,321,322,324,327,328,340,341,342,347,348,349,350,360,366,367,368,370,374,377,378,392,394,396,404,405,407,408,409,416,418,419,428,430,431,440,443,444,446,447,454,455,461,464,471,477,479,480,482,484,486,487,489,492,500,508,510,513,521,523,528,529,531,539,541,543,547,548,549,550,552,553,554,555,556,557,560,561,563,565,571,578,584,588,594,595,598,599,600,601,602,603,604,605,606,607,608,609,610,611,618,622,623,625,626,627,628,629,631,633,635,636,638,639,645,646,647,650,661,663,667,678,680,682,683,686,687,689,693,695,698,700,704,705,709,712,716,719,722,723,724,725,726,727,728,730,732,734,735,736,737,745,753,755,762,765,766,771,774,779,781,783,785,789,790,792,794,795,796,797,798,813,817,825,828,829,831,834,835,843,855,858,863,864,867,868,872,873,874,875,876,885,890,898,899,902,939,945,965,969,974,975,979,980,982,984,985,987,989,992,994,995,997,1006,1011,1042,1043,1048,1050,1052,1054,1058,1059,1061,1063,1068,1072,1080,1081,1082,1086,1087,1088,1089,1090,1092,1093,1094,1098,1100,1103,1106,1107,1108,1116,1119,1122,1124,1125,1135,1136,1137,1143,1144,1148,1149,1161,1169,1170,1171,1180,1181,1182,1187,1191,1194,1203,1204,1207,1211,1212,1213,1218,1219,1221,1223,1224,1226,1227,1230,1233,1234,1235,1236,1237,1238,1241,1243,1248,1250,1251,1252,1254,1256,1259,1261,1263,1264,1280,1282,1286,1287,1292,1295,1296,1298,1299,1300,1301,1303,1305,1310,1311,1317,1319,1325,1330,1342,1347,1349,1350,1352,1356,1364,1366,1378,1380,1391,1394,1398,1401,1404,1405,1420,1421,1425,1427,1456,1457,1459,1460,1461,1462,1463,1464,1466,1468,1469,1470,1471,1472,1475,1476,1477,1479,1480];
selectedFeatures{8}=[1:round(size(theFeatures,2)/2),round(3*size(theFeatures,2)/4)+1:size(theFeatures,2)];%max
selectedFeatures{9}=[1:round(3*size(theFeatures,2)/4)];%min
selectedFeatures{10}=[1:round(size(theFeatures,2)/2)];%normal
selectedFeatures{11}=[1,4,7,10,12,22,25,28,29,31,38,39,44,45,47,48,49,52,54,55,60,61,64,65,66,73,74,75,77,78,86,87,88,90,91,92,104,106,115,116,118,127,128,130,131,132,133,135,146,148,149,151,156,161,162,203,205,207,211,216,219,224,229,231,233,234,235,239,240,244,247,258,260,261,270,271,272,300,314,315,316,317,318,319,320,321,324,329,335,340,341,342,346,347,349,354,357,361,366,368,370,373,375,378,404,408,409,416,418,421,430,433,439,440,442,443,446,447,448,449,450,452,453,455,456,461,463,470,473,474,475,477,480,481,483,484,487,488,490,492,493,495,496,497,498,499,501,503,504,507,523,528,530,531,532,533,541,542,546,548,549,551,552,553,556,561,565,567,571,572,573,574,578,580,582,586,602,603,604,606,608,609,610,612,614,616,618,619,620,621,622,623,624,625,626,629,633,634,635,636,637,639,643,644,646,647,648,649,650,651,652,653,655,657,660,661,662,663,664,665,666,669,671,673,675,676,678,682,688,690,698,700,703,705,714,716,719,720,721,726,727,733,734,735,736,738,739,740,745,747,750,754,755,756,759,764,768,769,770,780,783,784,786,789,790,791,792,803,805,806,813,815,825,826,827,828,830,831,833,834,843,844,855,856,859,861,862,864,865,867,869,872,874,876,887,888,889,890,894,895,898,902,941,959,963,979,980,986,990,991,994,997,1001,1005,1006,1008,1039,1047,1049,1050,1051,1052,1058,1062,1066,1070,1080,1082,1084,1086,1089,1090,1091,1092,1093,1098,1100,1104,1108,1109,1111,1113,1116,1120,1124,1132,1133,1135,1137,1144,1145,1146,1148,1149,1157,1161,1182,1184,1185,1186,1188,1193,1195,1201,1203,1204,1206,1207,1209,1211,1212,1214,1218,1220,1223,1224,1225,1228,1229,1230,1231,1232,1235,1236,1238,1241,1243,1245,1248,1251,1260,1263,1264,1265,1270,1280,1282,1286,1288,1290,1291,1293,1294,1298,1299,1301,1310,1316,1319,1322,1325,1332,1336,1337,1339,1346,1354,1356,1367,1368,1369,1370,1371,1372,1373,1374,1378,1381,1382,1384,1385,1386,1388,1391,1392,1393,1394,1395,1396,1397,1398,1399,1400,1401,1402,1405,1406,1408,1410,1411,1418,1419,1420,1431,1433,1434,1437,1439,1440,1445,1451,1453,1454,1455,1457,1459,1460,1461,1462,1463,1466,1470,1471,1472,1473,1474,1475,1476,1479,1480];
selectedFeatures{12}=[1:round(size(theFeatures,2)/2)];%normal
selectedFeatures{15}=[1,2,4,6,7,8,12,15,21,22,23,24,28,29,35,36,37,41,43,44,47,49,51,53,54,56,57,60,62,63,64,66,78,85,86,87,89,91,92,93,95,96,103,104,115,116,117,118,119,120,122,123,124,126,128,131,132,134,136,145,148,151,153,156,157,158,161,193,194,199,201,203,205,208,213,214,219,223,224,225,226,228,229,231,237,240,242,244,252,258,272,275,303,307,308,309,315,317,318,319,320,321,322,324,327,329,330,334,335,346,347,349,351,352,355,368,369,370,371,372,373,374,375,379,380,384,385,392,393,396,397,403,404,405,407,408,409,415,416,418,419,430,432,433,440,441,442,445,448,449,452,462,463,464,467,473,475,477,478,479,481,484,485,486,487,488,489,490,492,494,495,499,501,502,503,504,505,510,511,515,517,518,520,525,527,528,529,532,540,542,547,548,549,550,553,554,555,558,560,561,565,566,570,574,575,576,578,580,582,586,589,590,591,592,593,594,595,599,601,602,603,605,606,607,609,610,611,612,613,614,615,618,619,620,621,622,623,624,626,627,628,629,633,636,637,638,639,641,644,645,646,647,648,651,652,653,654,655,661,662,665,667,670,671,672,674,675,676,677,678,683,684,687,689,690,691,692,694,695,699,704,705,709,710,712,713,720,723,724,725,726,728,730,731,734,735,736,737,738,739,741,742,743,744,745,746,750,752,755,758,764,765,766,767,770,774,776,777,780,781,782,784,785,787,789,790,791,792,793,794,796,797,799,800,803,804,805,806,814,815,816,817,818,825,826,827,828,829,832,834,844,859,861,862,864,867,872,873,874,876,885,896,897,898,899,900,901,902,935,938,939,940,941,946,948,953,954,959,960,961,964,969,973,974,982,984,987,990,991,992,995,998,1000,1001,1003,1006,1008,1010,1011,1016,1041,1046,1047,1048,1049,1050,1053,1054,1058,1060,1063,1064,1065,1067,1069,1070,1072,1074,1075,1081,1082,1086,1088,1089,1091,1092,1101,1106,1108,1109,1113,1114,1115,1117,1120,1121,1124,1132,1135,1137,1149,1157,1159,1160,1161,1169,1170,1171,1181,1183,1184,1185,1187,1189,1192,1194,1195,1196,1197,1198,1202,1204,1205,1207,1208,1210,1211,1215,1217,1220,1224,1225,1226,1230,1231,1233,1235,1236,1237,1238,1239,1240,1244,1247,1248,1249,1250,1251,1256,1257,1258,1260,1262,1265,1271,1272,1279,1280,1282,1286,1287,1288,1293,1294,1297,1299,1300,1303,1311,1321,1326,1328,1329,1331,1332,1334,1337,1338,1339,1344,1345,1347,1348,1351,1352,1354,1366,1367,1371,1372,1374,1375,1377,1381,1384,1385,1386,1389,1390,1391,1392,1393,1394,1395,1396,1397,1398,1401,1402,1403,1405,1406,1408,1409,1411,1420,1421,1426,1427,1429,1431,1432,1436,1437,1439,1446,1447,1453,1454,1456,1457,1459,1461,1462,1466,1468,1469,1470,1472,1473,1475,1476,1479];
selectedFeatures{18}=[1,2,3,4,6,10,11,12,19,22,23,25,27,28,30,37,38,41,43,44,46,47,51,52,55,56,60,61,64,65,74,75,76,77,85,86,87,88,91,94,95,104,115,116,117,118,119,120,123,124,125,132,135,136,145,147,149,151,152,153,155,161,206,209,211,216,223,224,230,231,232,239,240,242,244,246,252,255,256,257,259,260,261,263,265,269,270,271,272,276,301,309,311,312,313,314,315,316,318,319,320,324,328,335,342,346,347,348,349,351,354,356,358,368,370,377,378,395,397,408,409,415,416,417,419,420,440,442,443,448,452,456,461,464,467,470,474,476,477,483,484,485,488,493,495,497,498,499,500,504,512,517,518,527,529,540,543,546,547,548,551,552,553,554,557,558,559,563,565,567,570,571,582,589,591,595,600,602,603,606,609,613,615,616,617,620,621,622,623,627,628,629,630,631,632,633,634,635,636,640,643,645,646,647,648,649,650,651,652,653,654,656,657,660,663,664,665,668,677,681,682,691,692,693,698,699,703,714,715,717,720,725,728,730,731,733,735,737,738,739,751,753,754,758,764,765,766,767,768,770,771,777,782,784,787,790,791,794,795,798,816,818,826,827,828,833,836,843,858,859,862,863,864,865,866,867,868,869,870,873,874,875,877,885,886,888,895,897,902,938,939,941,943,946,953,960,969,971,972,973,974,979,982,985,990,991,997,998,1000,1001,1009,1011,1038,1043,1046,1048,1052,1055,1059,1062,1063,1069,1072,1074,1079,1080,1082,1084,1086,1087,1088,1089,1091,1092,1093,1095,1096,1097,1106,1111,1119,1120,1132,1137,1144,1145,1147,1148,1149,1155,1156,1157,1160,1170,1171,1172,1179,1180,1183,1184,1188,1190,1195,1197,1199,1204,1206,1213,1228,1230,1238,1240,1250,1251,1256,1258,1261,1263,1265,1270,1271,1273,1279,1280,1282,1287,1288,1289,1290,1291,1293,1295,1297,1301,1305,1307,1309,1317,1334,1347,1351,1370,1385,1386,1387,1388,1389,1390,1391,1392,1393,1394,1395,1397,1398,1399,1404,1405,1410,1411,1425,1427,1436,1438,1441,1455,1456,1457,1458,1460,1462,1466,1467,1468,1472,1474,1477,1479];
selectedFeatures{19}=[1:round(size(theFeatures,2)/2)];%normal
selectedFeatures{20}=[1:round(3*size(theFeatures,2)/4)];%min
selectedFeatures{21}=[1:round(size(theFeatures,2)/2)];%normal
selectedFeatures{22}=[1,2,3,4,5,7,9,10,11,12,13,16,20,23,24,25,27,28,30,35,36,37,41,43,44,45,46,48,49,50,51,53,54,56,57,58,59,60,61,62,63,64,65,73,74,75,76,77,78,89,90,91,92,93,95,103,104,110,115,116,118,119,120,123,125,126,128,129,130,131,132,133,135,136,137,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,162,199,201,202,204,205,206,211,213,219,220,221,223,224,225,228,229,230,231,234,235,237,239,240,242,243,244,245,246,247,249,251,252,254,256,257,258,259,261,263,265,266,267,271,272,273,275,300,303,307,308,309,310,312,315,317,318,319,322,324,326,328,329,332,334,335,339,340,341,342,345,346,348,349,350,355,360,362,365,366,367,368,369,370,371,373,378,381,382,383,385,392,393,395,396,397,403,404,405,406,408,409,416,418,419,427,428,430,431,433,440,441,442,445,446,448,449,454,455,456,457,462,463,464,466,467,469,470,471,474,477,478,479,480,482,483,484,485,486,487,488,491,492,493,494,495,496,497,499,500,501,502,503,506,507,508,509,510,512,513,514,517,518,520,525,527,529,531,532,539,540,541,542,546,547,548,549,550,551,553,555,556,557,558,559,560,561,563,565,568,569,571,572,575,576,577,578,580,581,582,583,584,586,587,588,589,590,592,593,594,597,598,599,602,603,604,606,607,608,610,611,613,614,616,617,618,619,620,621,623,624,625,626,628,629,630,631,632,634,636,637,638,639,641,643,644,645,646,647,648,649,650,651,652,653,655,656,657,658,659,660,661,662,663,665,666,668,669,670,675,678,682,683,684,685,686,687,691,692,696,700,705,710,711,713,714,715,717,721,722,723,724,725,726,730,731,732,733,734,735,737,739,740,742,743,745,751,753,754,755,756,757,758,759,760,761,762,763,766,767,768,769,770,772,777,778,781,783,785,786,787,788,789,791,793,794,795,796,797,798,799,800,801,803,806,814,816,818,826,827,828,829,830,831,832,833,834,835,836,843,844,855,856,858,859,860,861,863,864,866,867,868,869,870,871,872,873,874,876,878,885,886,888,889,897,898,901,902,936,937,941,943,947,949,953,954,960,961,965,966,969,970,974,975,977,979,980,982,984,985,986,987,989,990,991,992,994,995,996,997,1000,1003,1005,1008,1009,1011,1012,1013,1015,1016,1040,1041,1043,1046,1047,1048,1049,1052,1053,1054,1057,1058,1059,1060,1061,1062,1063,1064,1068,1069,1072,1074,1080,1081,1082,1084,1086,1087,1088,1089,1091,1093,1095,1096,1098,1101,1106,1107,1111,1112,1113,1114,1117,1121,1124,1125,1132,1133,1134,1136,1137,1144,1145,1146,1147,1148,1149,1156,1157,1158,1160,1168,1169,1170,1171,1172,1173,1179,1180,1182,1183,1184,1185,1188,1191,1192,1195,1197,1199,1201,1202,1203,1204,1205,1206,1207,1208,1209,1210,1212,1213,1214,1215,1216,1218,1219,1220,1222,1223,1224,1225,1226,1227,1230,1231,1232,1233,1234,1235,1236,1237,1238,1239,1240,1241,1242,1243,1245,1246,1249,1250,1252,1257,1258,1259,1260,1262,1265,1266,1269,1272,1279,1280,1282,1287,1288,1289,1290,1291,1292,1293,1294,1295,1296,1297,1298,1299,1300,1301,1303,1305,1313,1315,1316,1317,1318,1324,1325,1329,1330,1331,1332,1337,1339,1340,1348,1354,1356,1358,1363,1365,1366,1368,1369,1370,1371,1372,1373,1374,1376,1377,1378,1379,1382,1384,1385,1386,1387,1388,1389,1390,1391,1392,1393,1394,1395,1396,1399,1400,1401,1404,1405,1406,1407,1409,1413,1414,1429,1432,1433,1439,1440,1443,1445,1446,1450,1451,1452,1453,1454,1456,1457,1458,1459,1460,1461,1463,1464,1465,1466,1469,1470,1471,1472,1473,1474,1475,1477,1478,1479,1480];
selectedFeatures{23}=[1:round(size(theFeatures,2)/2)];%normal
selectedFeatures{24}=[2,3,7,21,30,31,35,41,51,52,54,56,59,66,77,85,87,91,93,96,115,116,117,118,122,124,127,128,132,149,153,158,160,199,218,224,235,242,255,259,268,275,276,298,300,301,321,322,327,329,334,339,345,346,347,349,350,366,373,378,380,395,396,404,409,432,468,471,482,483,490,495,502,503,511,521,539,541,553,555,556,557,558,566,567,577,579,586,601,625,628,635,658,667,718,730,731,739,740,755,769,775,780,783,787,790,793,825,826,830,855,858,859,860,864,885,894,895,970,974,980,982,990,995,1039,1048,1052,1063,1069,1070,1074,1075,1079,1082,1085,1087,1088,1110,1115,1117,1135,1144,1156,1160,1172,1192,1208,1213,1219,1220,1222,1225,1230,1237,1238,1242,1246,1251,1265,1281,1286,1289,1296,1297,1298,1299,1337,1338,1339,1352,1369,1372,1394,1421,1458,1469,1470,1472];
selectedFeatures{26}=[1,2,3,5,6,7,10,11,12,13,18,19,23,24,25,28,29,30,34,36,37,38,40,41,43,44,45,46,47,48,49,50,51,53,54,55,56,57,58,59,60,61,63,64,76,77,78,85,87,88,89,90,92,93,94,95,96,104,115,117,118,120,123,124,125,127,128,129,130,132,136,149,154,155,157,158,159,161,162,194,197,199,205,206,211,220,221,224,225,226,227,229,230,231,233,234,235,237,240,244,245,246,247,249,250,251,252,254,255,257,258,259,260,263,265,266,268,270,271,272,273,275,298,299,300,301,302,303,306,308,309,310,311,312,313,314,315,316,317,318,321,322,323,324,327,328,329,330,332,334,335,339,340,346,347,348,349,351,355,356,357,358,360,366,367,370,371,374,375,376,377,378,379,383,392,393,395,396,397,403,404,405,406,407,408,409,415,416,417,418,419,420,421,428,429,430,431,432,433,439,440,441,442,445,446,447,448,452,453,454,455,456,457,459,462,463,464,467,468,469,470,471,474,475,476,477,480,481,482,483,484,485,486,487,488,489,491,493,494,496,498,499,501,503,506,507,508,509,510,511,512,513,516,517,519,525,526,528,529,539,541,542,543,546,547,551,552,553,554,555,557,558,559,560,561,563,567,568,569,571,572,573,574,575,577,581,585,586,587,588,589,590,591,593,594,596,600,602,604,606,607,608,609,610,612,613,614,617,619,621,622,624,625,626,628,630,632,633,634,635,636,637,642,643,646,648,649,650,652,653,654,655,657,659,664,670,671,673,678,679,682,684,686,688,690,691,692,694,695,698,704,708,709,715,716,717,718,719,720,721,723,724,725,726,727,728,731,732,733,734,737,738,739,740,742,743,744,745,746,749,750,751,752,754,755,759,762,765,767,768,769,773,774,777,778,779,783,786,787,788,789,790,793,794,795,796,797,798,799,800,803,805,806,813,814,816,817,818,825,826,827,828,829,830,831,834,835,836,843,855,856,857,858,859,860,861,862,863,864,867,868,870,871,873,876,877,885,886,889,890,891,892,894,896,897,898,899,900,901,902,939,940,941,945,951,953,958,959,960,961,965,966,968,969,970,972,974,979,980,984,987,989,990,991,992,995,996,997,998,999,1000,1001,1003,1005,1006,1013,1015,1016,1038,1039,1040,1041,1043,1046,1047,1048,1049,1051,1052,1053,1054,1056,1058,1059,1061,1062,1064,1065,1067,1068,1069,1070,1072,1074,1079,1082,1085,1086,1087,1088,1089,1091,1092,1093,1094,1095,1096,1097,1098,1102,1104,1105,1106,1107,1112,1113,1116,1118,1119,1122,1123,1132,1134,1135,1136,1137,1143,1144,1145,1146,1147,1148,1149,1155,1156,1157,1158,1161,1168,1169,1170,1171,1173,1179,1180,1181,1182,1183,1185,1186,1187,1191,1192,1194,1195,1197,1198,1199,1202,1204,1206,1207,1208,1209,1210,1213,1214,1216,1217,1218,1219,1220,1221,1222,1223,1224,1225,1226,1227,1228,1229,1230,1233,1234,1236,1237,1238,1239,1240,1241,1244,1249,1250,1251,1252,1253,1254,1256,1259,1260,1261,1262,1263,1265,1266,1270,1279,1281,1282,1283,1286,1287,1288,1290,1293,1294,1295,1298,1300,1301,1305,1309,1314,1318,1322,1327,1328,1331,1333,1341,1344,1346,1347,1348,1350,1352,1353,1354,1356,1358,1361,1362,1363,1366,1367,1370,1371,1372,1373,1375,1376,1377,1384,1385,1387,1388,1390,1395,1398,1403,1407,1411,1412,1416,1418,1422,1425,1426,1427,1437,1438,1443,1447,1450,1451,1452,1453,1455,1458,1460,1461,1463,1464,1466,1467,1468,1470,1472,1474,1475,1476,1477,1478,1480];
noClassifiers=[300,25,25,300,300,100,300,25,300,300,100,100,300,25,25,300,100,100,300,300,100,100,100,100,300,25,300];
noClassifiers(17)=300;
noClassifiers(noClassifiers==300)=499;
noClassifiers(12)=300;


theFeatures=[theFeatures,featuresAddedallI];

for i=1:27
    selectedFeatures{i}=[selectedFeatures{i},2961,2962];
end
% settC=[1,3,1,1,1,1,1,1,3,1,1,1,1,1,1,1,1,2,3,1,1,3,2,1,1,1,1];
% settC=ones(1,length(settN));
% for i=1:length(settC)
%     if strcmp(sett{i},'AdaboostM1')==1
%        settC(i)=2;
%     end
%     if strcmp(sett{i},'GentleBoost')==1
%        settC(i)=3;
%     end
% end
useMainRows=1;
if useMainRows==1
    ffc=find(correctIndices>0);
    vecClassificationAllc=vecClassificationAll(:,correctIndices(correctIndices>0));
    ss=sum(vecClassificationAllc,2);
    ff1=find(ss>0);
    vecClassificationAll=vecClassificationAll(ff1,:);
    theFeatures=theFeatures(ff1,:);
    sourcesAlla=sourcesAlla(ff1);
end

scoresfAll={};
scoresgAll={};
scoresAll={};
model={};
for selectedClass=1:numberOfClasses
    selectedClass
    if correctIndices(selectedClass)>0
        usources=unique(sourcesAll);
        numberFolds=length(usources);
        scoresf=zeros(1,numberFolds);
        scoresg=zeros(1,numberFolds);
        scores=zeros(1,numberFolds);
        
        
        
        Y=vecClassificationAll(:,correctIndices(selectedClass));
        
        
%         for i=1:1
            %         fftrain=find(sourcesS~=i);
            %         fftest=find(sources==i);
            %         [trainX,trainY,sourcesS]=balanceSource2(theFeatures(~cv.test(i),selectedF),Y(~cv.test(i),:),sources(~cv.test(i)));
            % [trainX,trainY]=balanceClass(theFeatures,Y);sourcesS=sources;
            
            trainX=theFeatures(:,:);trainY=Y(:);
            theMethod=sett{selectedClass};
            
            if selectedClass==5
                selectedClass2=19;
                Y2=vecClassificationAll(:,correctIndices(selectedClass2));
                trainY=trainY+Y2;trainY(trainY>1)=1;
            end
            
            if selectedClass==19
                selectedClass2=5;
                Y2=vecClassificationAll(:,correctIndices(selectedClass2));
                trainY=trainY+Y2;trainY(trainY>1)=1;
            end
            
            
            if selectedClass==13
                selectedClass2=24;
                Y2=vecClassificationAll(:,correctIndices(selectedClass2));
                trainY=trainY+Y2;trainY(trainY>1)=1;
            end
            
            
            
            if selectedClass==24
                selectedClass2=13;
                Y2=vecClassificationAll(:,correctIndices(selectedClass2));
                trainY=trainY+Y2;trainY(trainY>1)=1;
            end
            
            if selectedClass==14
                selectedClass2=27;
                Y2=vecClassificationAll(:,correctIndices(selectedClass2));
                trainY=trainY+Y2;trainY(trainY>1)=1;
            end
            
            
            if selectedClass==27
                selectedClass2=14;
                Y2=vecClassificationAll(:,correctIndices(selectedClass2));
                trainY=trainY+Y2;trainY(trainY>1)=1;
                
            end
         
            if strcmp('GentleBoost',theMethod)==1
                %                 [trainX,trainY,sourcesS]=balanceSource2(trainX,trainY,sourcesAll(:));
                [trainX,trainY,sourcesS]=balanceClassSource(trainX,trainY,sourcesAlla);
            end
            Mdl=fitcensemble(trainX(:,selectedFeatures{selectedClass}),trainY,'Method',theMethod,'ScoreTransform','logit','NumLearningCycles',noClassifiers(selectedClass)); 
				Mdl=compact(Mdl);
            %             [outs,outsprob]=Mdl.predict(theFeatures(cv.test(i),:));
            %         outsprob1=outsprob(:,1);outsprob1(outsprob1>.5)=1;outsprob1(outsprob1<.5)=0;
            %     [outs,outss]=Mdl.predict(theFeaturesO(cv.test(i),:));
            %             [accuracy,f_measure,cscore,g_beta] = compute_beta_score1class(Y(cv.test(i)),outs);[accuracy,f_measure,cscore,g_beta]
            %             scoresf(i)=cscore;
            %             scores(i)=cscore/2+g_beta/2;
            %             scoresg(i)=g_beta;
%         end
        model{selectedClass}=Mdl;
        
    end
    %     scoresfAll{selectedClass}=scoresf;
    %     scoresAll{selectedClass}=scores;
    %     scoresgAll{selectedClass}=scoresg;
    %     save('xrusboostResults3Foldst1','scoresfAll','scoresAll','scoresgAll')
end
%save('main1');
save_12_ECG_model(model,output_directory,classes,correctIndices);
end

function save_12_ECG_model(model,output_directory,classes,correctIndices)
% Save results.
tmp_file = 'finalized_model.mat';
filename=fullfile(output_directory,tmp_file);
save(filename,'model','classes','correctIndices','-v7.3');
disp('Done.')
end


% find unique number of classes
function classes = get_classes(input_directory,files)

classes={};
num_files = length(files);
k=1;
for i = 1:num_files
    g = strrep(files{i},'.mat','.hea');
    input_file = fullfile(input_directory, g);
    fid=fopen(input_file);
    tline = fgetl(fid);
    tlines = cell(0,1);
    
    while ischar(tline)
        tlines{end+1,1} = tline;
        tline = fgetl(fid);
        if startsWith(tline,'#Dx')
            tmp = strsplit(tline,': ');
            tmp_c = strsplit(tmp{2},',');
            for j=1:length(tmp_c)
                idx2 = find(strcmp(classes,tmp_c{j}));
                if isempty(idx2)
                    classes{k}=tmp_c{j};
                    k=k+1;
                end
            end
            break
        end
    end
    
    fclose(fid);
    
end
classes=sort(classes);
end

function [data,tlines] = load_challenge_data(filename)

% Opening header file
fid=fopen([filename '.hea']);

if (fid<=0)
    disp(['error in opening file ' filename]);
end

tline = fgetl(fid);
tlines = cell(0,1);
while ischar(tline)
    tlines{end+1,1} = tline;
    tline = fgetl(fid);
end
fclose(fid);

f=load([filename '.mat']);

try
    data = f.val;
catch ex
    rethrow(ex);
end

end
