function [trainedClassifier, validationAccuracy] = trainClassifierBest(trainingData)
% [trainedClassifier, validationAccuracy] = trainClassifier(trainingData)
% returns a trained classifier and its accuracy. This code recreates the
% classification model trained in Classification Learner app. Use the
% generated code to automate training the same model with new data, or to
% learn how to programmatically train models.
%
%  Input:
%      trainingData: a matrix with the same number of columns and data type
%       as imported into the app.
%
%  Output:
%      trainedClassifier: a struct containing the trained classifier. The
%       struct contains various fields with information about the trained
%       classifier.
%
%      trainedClassifier.predictFcn: a function to make predictions on new
%       data.
%
%      validationAccuracy: a double containing the accuracy in percent. In
%       the app, the History list displays this overall accuracy score for
%       each model.
%
% Use the code to train the model with new data. To retrain your
% classifier, call the function from the command line with your original
% data or new data as the input argument trainingData.
%
% For example, to retrain a classifier trained with the original data set
% T, enter:
%   [trainedClassifier, validationAccuracy] = trainClassifier(T)
%
% To make predictions with the returned 'trainedClassifier' on new data T2,
% use
%   yfit = trainedClassifier.predictFcn(T2)
%
% T2 must be a matrix containing only the predictor columns used for
% training. For details, enter:
%   trainedClassifier.HowToPredict

% Auto-generated by MATLAB on 03-Mar-2020 16:18:14


% Extract predictors and response
% This code processes the data into the right shape for training the
% model.
% Convert input to table
inputTable = array2table(trainingData, 'VariableNames', {'column_1', 'column_2', 'column_3', 'column_4', 'column_5', 'column_6', 'column_7', 'column_8', 'column_9', 'column_10', 'column_11', 'column_12', 'column_13', 'column_14', 'column_15', 'column_16', 'column_17', 'column_18', 'column_19', 'column_20', 'column_21', 'column_22', 'column_23', 'column_24', 'column_25', 'column_26', 'column_27', 'column_28', 'column_29', 'column_30', 'column_31', 'column_32', 'column_33', 'column_34', 'column_35', 'column_36', 'column_37', 'column_38', 'column_39', 'column_40', 'column_41', 'column_42', 'column_43', 'column_44', 'column_45', 'column_46', 'column_47', 'column_48', 'column_49', 'column_50', 'column_51', 'column_52', 'column_53', 'column_54', 'column_55', 'column_56', 'column_57', 'column_58', 'column_59', 'column_60', 'column_61', 'column_62', 'column_63', 'column_64', 'column_65', 'column_66', 'column_67', 'column_68', 'column_69', 'column_70', 'column_71', 'column_72', 'column_73', 'column_74', 'column_75', 'column_76', 'column_77', 'column_78', 'column_79', 'column_80', 'column_81', 'column_82', 'column_83', 'column_84', 'column_85', 'column_86', 'column_87', 'column_88', 'column_89', 'column_90', 'column_91', 'column_92', 'column_93', 'column_94', 'column_95', 'column_96', 'column_97', 'column_98', 'column_99', 'column_100', 'column_101', 'column_102', 'column_103', 'column_104', 'column_105', 'column_106', 'column_107', 'column_108', 'column_109', 'column_110', 'column_111', 'column_112', 'column_113', 'column_114', 'column_115', 'column_116', 'column_117', 'column_118', 'column_119', 'column_120', 'column_121', 'column_122', 'column_123', 'column_124', 'column_125', 'column_126', 'column_127', 'column_128', 'column_129', 'column_130', 'column_131', 'column_132', 'column_133', 'column_134', 'column_135', 'column_136', 'column_137', 'column_138', 'column_139', 'column_140', 'column_141', 'column_142', 'column_143', 'column_144', 'column_145', 'column_146', 'column_147', 'column_148', 'column_149', 'column_150', 'column_151', 'column_152', 'column_153', 'column_154', 'column_155', 'column_156', 'column_157', 'column_158', 'column_159', 'column_160', 'column_161', 'column_162', 'column_163', 'column_164', 'column_165', 'column_166', 'column_167', 'column_168', 'column_169', 'column_170', 'column_171', 'column_172', 'column_173', 'column_174', 'column_175', 'column_176', 'column_177', 'column_178', 'column_179', 'column_180', 'column_181', 'column_182', 'column_183', 'column_184', 'column_185', 'column_186', 'column_187', 'column_188', 'column_189', 'column_190', 'column_191', 'column_192', 'column_193', 'column_194', 'column_195', 'column_196', 'column_197', 'column_198', 'column_199', 'column_200', 'column_201', 'column_202', 'column_203', 'column_204', 'column_205', 'column_206', 'column_207', 'column_208', 'column_209', 'column_210', 'column_211', 'column_212', 'column_213', 'column_214', 'column_215', 'column_216', 'column_217', 'column_218', 'column_219', 'column_220', 'column_221', 'column_222', 'column_223', 'column_224', 'column_225', 'column_226', 'column_227', 'column_228', 'column_229', 'column_230', 'column_231', 'column_232', 'column_233', 'column_234', 'column_235', 'column_236', 'column_237', 'column_238', 'column_239', 'column_240', 'column_241', 'column_242', 'column_243', 'column_244', 'column_245', 'column_246', 'column_247', 'column_248', 'column_249', 'column_250', 'column_251', 'column_252', 'column_253', 'column_254', 'column_255', 'column_256', 'column_257', 'column_258', 'column_259', 'column_260', 'column_261', 'column_262', 'column_263', 'column_264', 'column_265', 'column_266', 'column_267', 'column_268', 'column_269', 'column_270', 'column_271', 'column_272', 'column_273', 'column_274', 'column_275', 'column_276', 'column_277', 'column_278', 'column_279', 'column_280', 'column_281', 'column_282', 'column_283', 'column_284', 'column_285', 'column_286', 'column_287', 'column_288', 'column_289', 'column_290', 'column_291', 'column_292', 'column_293', 'column_294', 'column_295', 'column_296', 'column_297', 'column_298', 'column_299', 'column_300', 'column_301', 'column_302', 'column_303', 'column_304', 'column_305', 'column_306', 'column_307', 'column_308', 'column_309', 'column_310', 'column_311', 'column_312', 'column_313', 'column_314', 'column_315', 'column_316', 'column_317', 'column_318', 'column_319', 'column_320', 'column_321', 'column_322', 'column_323', 'column_324', 'column_325', 'column_326', 'column_327', 'column_328', 'column_329', 'column_330', 'column_331', 'column_332', 'column_333', 'column_334', 'column_335', 'column_336', 'column_337', 'column_338', 'column_339', 'column_340', 'column_341', 'column_342', 'column_343', 'column_344', 'column_345', 'column_346', 'column_347', 'column_348', 'column_349', 'column_350', 'column_351', 'column_352', 'column_353', 'column_354', 'column_355', 'column_356', 'column_357', 'column_358', 'column_359', 'column_360', 'column_361', 'column_362', 'column_363', 'column_364', 'column_365', 'column_366', 'column_367', 'column_368', 'column_369', 'column_370', 'column_371', 'column_372', 'column_373', 'column_374', 'column_375', 'column_376', 'column_377', 'column_378', 'column_379', 'column_380', 'column_381', 'column_382', 'column_383', 'column_384', 'column_385', 'column_386', 'column_387', 'column_388', 'column_389', 'column_390', 'column_391', 'column_392', 'column_393', 'column_394', 'column_395', 'column_396', 'column_397', 'column_398', 'column_399', 'column_400', 'column_401', 'column_402', 'column_403', 'column_404', 'column_405', 'column_406', 'column_407', 'column_408', 'column_409', 'column_410', 'column_411', 'column_412', 'column_413', 'column_414', 'column_415', 'column_416', 'column_417', 'column_418', 'column_419', 'column_420', 'column_421', 'column_422', 'column_423', 'column_424', 'column_425', 'column_426', 'column_427', 'column_428', 'column_429', 'column_430', 'column_431', 'column_432', 'column_433', 'column_434', 'column_435', 'column_436', 'column_437', 'column_438', 'column_439', 'column_440', 'column_441', 'column_442', 'column_443', 'column_444', 'column_445', 'column_446', 'column_447', 'column_448', 'column_449', 'column_450', 'column_451', 'column_452', 'column_453', 'column_454', 'column_455', 'column_456', 'column_457', 'column_458', 'column_459', 'column_460', 'column_461', 'column_462', 'column_463', 'column_464', 'column_465', 'column_466', 'column_467', 'column_468', 'column_469', 'column_470', 'column_471', 'column_472', 'column_473', 'column_474', 'column_475', 'column_476', 'column_477', 'column_478', 'column_479', 'column_480', 'column_481', 'column_482', 'column_483', 'column_484', 'column_485', 'column_486', 'column_487', 'column_488', 'column_489', 'column_490', 'column_491', 'column_492', 'column_493', 'column_494', 'column_495', 'column_496', 'column_497', 'column_498', 'column_499', 'column_500', 'column_501', 'column_502', 'column_503', 'column_504', 'column_505', 'column_506', 'column_507', 'column_508', 'column_509', 'column_510', 'column_511', 'column_512', 'column_513', 'column_514', 'column_515', 'column_516', 'column_517', 'column_518', 'column_519', 'column_520', 'column_521', 'column_522', 'column_523', 'column_524', 'column_525', 'column_526', 'column_527', 'column_528', 'column_529', 'column_530', 'column_531', 'column_532', 'column_533', 'column_534', 'column_535', 'column_536', 'column_537', 'column_538', 'column_539', 'column_540', 'column_541', 'column_542', 'column_543', 'column_544', 'column_545', 'column_546', 'column_547', 'column_548', 'column_549', 'column_550', 'column_551', 'column_552', 'column_553', 'column_554', 'column_555', 'column_556', 'column_557', 'column_558', 'column_559', 'column_560', 'column_561', 'column_562', 'column_563', 'column_564', 'column_565', 'column_566', 'column_567', 'column_568', 'column_569', 'column_570', 'column_571', 'column_572', 'column_573', 'column_574', 'column_575', 'column_576', 'column_577', 'column_578', 'column_579', 'column_580', 'column_581', 'column_582', 'column_583', 'column_584', 'column_585', 'column_586', 'column_587', 'column_588', 'column_589', 'column_590', 'column_591', 'column_592', 'column_593', 'column_594', 'column_595', 'column_596', 'column_597', 'column_598', 'column_599', 'column_600', 'column_601', 'column_602', 'column_603', 'column_604', 'column_605', 'column_606', 'column_607', 'column_608', 'column_609', 'column_610', 'column_611', 'column_612', 'column_613', 'column_614', 'column_615', 'column_616', 'column_617', 'column_618', 'column_619', 'column_620', 'column_621', 'column_622', 'column_623', 'column_624', 'column_625', 'column_626', 'column_627', 'column_628', 'column_629', 'column_630', 'column_631', 'column_632', 'column_633', 'column_634', 'column_635', 'column_636', 'column_637', 'column_638', 'column_639', 'column_640', 'column_641', 'column_642', 'column_643', 'column_644', 'column_645', 'column_646', 'column_647', 'column_648', 'column_649', 'column_650', 'column_651', 'column_652', 'column_653', 'column_654', 'column_655', 'column_656', 'column_657', 'column_658', 'column_659', 'column_660', 'column_661', 'column_662', 'column_663', 'column_664', 'column_665', 'column_666', 'column_667', 'column_668', 'column_669', 'column_670', 'column_671', 'column_672', 'column_673', 'column_674', 'column_675', 'column_676', 'column_677', 'column_678', 'column_679', 'column_680', 'column_681', 'column_682', 'column_683', 'column_684', 'column_685', 'column_686', 'column_687', 'column_688', 'column_689', 'column_690', 'column_691', 'column_692', 'column_693', 'column_694', 'column_695', 'column_696', 'column_697', 'column_698', 'column_699', 'column_700', 'column_701', 'column_702', 'column_703', 'column_704', 'column_705', 'column_706', 'column_707', 'column_708', 'column_709', 'column_710', 'column_711', 'column_712', 'column_713', 'column_714', 'column_715', 'column_716', 'column_717', 'column_718', 'column_719', 'column_720', 'column_721', 'column_722', 'column_723', 'column_724', 'column_725', 'column_726', 'column_727', 'column_728', 'column_729', 'column_730', 'column_731', 'column_732', 'column_733', 'column_734', 'column_735', 'column_736', 'column_737', 'column_738', 'column_739', 'column_740', 'column_741', 'column_742', 'column_743', 'column_744', 'column_745', 'column_746', 'column_747', 'column_748', 'column_749', 'column_750', 'column_751', 'column_752', 'column_753', 'column_754', 'column_755', 'column_756', 'column_757', 'column_758', 'column_759', 'column_760', 'column_761', 'column_762', 'column_763', 'column_764', 'column_765', 'column_766', 'column_767', 'column_768', 'column_769', 'column_770', 'column_771', 'column_772', 'column_773', 'column_774', 'column_775', 'column_776', 'column_777', 'column_778', 'column_779', 'column_780', 'column_781', 'column_782', 'column_783', 'column_784', 'column_785', 'column_786', 'column_787', 'column_788', 'column_789', 'column_790', 'column_791', 'column_792', 'column_793', 'column_794', 'column_795', 'column_796', 'column_797', 'column_798', 'column_799', 'column_800', 'column_801', 'column_802', 'column_803', 'column_804', 'column_805', 'column_806', 'column_807', 'column_808', 'column_809', 'column_810', 'column_811', 'column_812', 'column_813', 'column_814', 'column_815', 'column_816', 'column_817', 'column_818', 'column_819', 'column_820', 'column_821', 'column_822', 'column_823', 'column_824', 'column_825', 'column_826', 'column_827', 'column_828', 'column_829', 'column_830', 'column_831', 'column_832', 'column_833', 'column_834', 'column_835', 'column_836', 'column_837', 'column_838', 'column_839', 'column_840', 'column_841', 'column_842', 'column_843', 'column_844', 'column_845', 'column_846', 'column_847', 'column_848', 'column_849', 'column_850', 'column_851', 'column_852', 'column_853', 'column_854', 'column_855', 'column_856', 'column_857', 'column_858', 'column_859', 'column_860', 'column_861', 'column_862', 'column_863', 'column_864', 'column_865', 'column_866', 'column_867', 'column_868', 'column_869', 'column_870', 'column_871', 'column_872', 'column_873', 'column_874', 'column_875', 'column_876', 'column_877', 'column_878', 'column_879', 'column_880', 'column_881', 'column_882', 'column_883', 'column_884', 'column_885', 'column_886', 'column_887', 'column_888', 'column_889', 'column_890', 'column_891', 'column_892', 'column_893', 'column_894', 'column_895', 'column_896', 'column_897', 'column_898', 'column_899', 'column_900', 'column_901', 'column_902', 'column_903', 'column_904', 'column_905', 'column_906', 'column_907', 'column_908', 'column_909', 'column_910', 'column_911', 'column_912', 'column_913', 'column_914', 'column_915', 'column_916', 'column_917', 'column_918', 'column_919', 'column_920', 'column_921', 'column_922', 'column_923', 'column_924', 'column_925', 'column_926', 'column_927', 'column_928', 'column_929', 'column_930', 'column_931', 'column_932', 'column_933', 'column_934', 'column_935', 'column_936', 'column_937', 'column_938', 'column_939', 'column_940', 'column_941', 'column_942', 'column_943', 'column_944', 'column_945', 'column_946', 'column_947', 'column_948', 'column_949', 'column_950', 'column_951', 'column_952', 'column_953', 'column_954', 'column_955', 'column_956', 'column_957', 'column_958', 'column_959', 'column_960', 'column_961', 'column_962', 'column_963', 'column_964', 'column_965', 'column_966', 'column_967', 'column_968', 'column_969', 'column_970', 'column_971', 'column_972', 'column_973', 'column_974', 'column_975', 'column_976', 'column_977', 'column_978', 'column_979', 'column_980', 'column_981', 'column_982', 'column_983', 'column_984', 'column_985', 'column_986', 'column_987', 'column_988', 'column_989', 'column_990', 'column_991', 'column_992', 'column_993', 'column_994', 'column_995', 'column_996', 'column_997', 'column_998', 'column_999', 'column_1000', 'column_1001', 'column_1002', 'column_1003', 'column_1004', 'column_1005', 'column_1006', 'column_1007', 'column_1008', 'column_1009', 'column_1010', 'column_1011', 'column_1012', 'column_1013', 'column_1014', 'column_1015', 'column_1016', 'column_1017', 'column_1018', 'column_1019', 'column_1020', 'column_1021', 'column_1022', 'column_1023', 'column_1024', 'column_1025', 'column_1026', 'column_1027', 'column_1028', 'column_1029', 'column_1030', 'column_1031', 'column_1032', 'column_1033', 'column_1034', 'column_1035', 'column_1036', 'column_1037', 'column_1038', 'column_1039', 'column_1040', 'column_1041', 'column_1042', 'column_1043', 'column_1044', 'column_1045', 'column_1046', 'column_1047', 'column_1048', 'column_1049', 'column_1050', 'column_1051', 'column_1052', 'column_1053', 'column_1054', 'column_1055', 'column_1056', 'column_1057', 'column_1058', 'column_1059', 'column_1060', 'column_1061', 'column_1062', 'column_1063', 'column_1064', 'column_1065', 'column_1066', 'column_1067', 'column_1068', 'column_1069', 'column_1070'});

predictorNames = {'column_1', 'column_2', 'column_3', 'column_4', 'column_5', 'column_6', 'column_7', 'column_8', 'column_9', 'column_10', 'column_11', 'column_12', 'column_13', 'column_14', 'column_15', 'column_16', 'column_17', 'column_18', 'column_19', 'column_20', 'column_21', 'column_22', 'column_23', 'column_24', 'column_25', 'column_26', 'column_27', 'column_28', 'column_29', 'column_30', 'column_31', 'column_32', 'column_33', 'column_34', 'column_35', 'column_36', 'column_37', 'column_38', 'column_39', 'column_40', 'column_41', 'column_42', 'column_43', 'column_44', 'column_45', 'column_46', 'column_47', 'column_48', 'column_49', 'column_50', 'column_51', 'column_52', 'column_53', 'column_54', 'column_55', 'column_56', 'column_57', 'column_58', 'column_59', 'column_60', 'column_61', 'column_62', 'column_63', 'column_64', 'column_65', 'column_66', 'column_67', 'column_68', 'column_69', 'column_70', 'column_71', 'column_72', 'column_73', 'column_74', 'column_75', 'column_76', 'column_77', 'column_78', 'column_79', 'column_80', 'column_85', 'column_86', 'column_87', 'column_88', 'column_89', 'column_90', 'column_91', 'column_92', 'column_93', 'column_94', 'column_95', 'column_96', 'column_97', 'column_98', 'column_103', 'column_104', 'column_105', 'column_106', 'column_107', 'column_108', 'column_109', 'column_110', 'column_111', 'column_112', 'column_113', 'column_114', 'column_115', 'column_116', 'column_117', 'column_118', 'column_119', 'column_120', 'column_121', 'column_122', 'column_123', 'column_124', 'column_125', 'column_126', 'column_127', 'column_128', 'column_129', 'column_130', 'column_131', 'column_132', 'column_133', 'column_134', 'column_135', 'column_136', 'column_137', 'column_138', 'column_139', 'column_140', 'column_141', 'column_142', 'column_143', 'column_144', 'column_145', 'column_146', 'column_147', 'column_148', 'column_149', 'column_150', 'column_151', 'column_152', 'column_153', 'column_154', 'column_155', 'column_156', 'column_157', 'column_158', 'column_159', 'column_160', 'column_161', 'column_162', 'column_163', 'column_164', 'column_165', 'column_166', 'column_167', 'column_168', 'column_169', 'column_170', 'column_171', 'column_172', 'column_173', 'column_174', 'column_175', 'column_176', 'column_177', 'column_178', 'column_179', 'column_180', 'column_181', 'column_182', 'column_183', 'column_184', 'column_185', 'column_186', 'column_187', 'column_188', 'column_189', 'column_190', 'column_191', 'column_192', 'column_193', 'column_194', 'column_195', 'column_196', 'column_197', 'column_198', 'column_199', 'column_200', 'column_201', 'column_202', 'column_203', 'column_204', 'column_205', 'column_206', 'column_207', 'column_208', 'column_209', 'column_210', 'column_211', 'column_213', 'column_214', 'column_216', 'column_217', 'column_218', 'column_219', 'column_220', 'column_221', 'column_222', 'column_223', 'column_224', 'column_225', 'column_226', 'column_227', 'column_228', 'column_229', 'column_230', 'column_231', 'column_232', 'column_233', 'column_234', 'column_235', 'column_236', 'column_237', 'column_238', 'column_239', 'column_240', 'column_241', 'column_242', 'column_243', 'column_244', 'column_245', 'column_246', 'column_247', 'column_249', 'column_250', 'column_251', 'column_252', 'column_253', 'column_254', 'column_255', 'column_256', 'column_257', 'column_258', 'column_259', 'column_260', 'column_261', 'column_262', 'column_263', 'column_264', 'column_265', 'column_266', 'column_267', 'column_268', 'column_269', 'column_270', 'column_271', 'column_272', 'column_273', 'column_275', 'column_276', 'column_277', 'column_278', 'column_279', 'column_280', 'column_281', 'column_282', 'column_283', 'column_284', 'column_285', 'column_286', 'column_287', 'column_288', 'column_289', 'column_290', 'column_291', 'column_292', 'column_293', 'column_294', 'column_295', 'column_296', 'column_297', 'column_298', 'column_299', 'column_300', 'column_301', 'column_302', 'column_303', 'column_304', 'column_305', 'column_306', 'column_307', 'column_308', 'column_309', 'column_310', 'column_311', 'column_312', 'column_313', 'column_314', 'column_315', 'column_316', 'column_317', 'column_318', 'column_319', 'column_320', 'column_321', 'column_322', 'column_323', 'column_324', 'column_325', 'column_326', 'column_327', 'column_328', 'column_329', 'column_330', 'column_331', 'column_332', 'column_333', 'column_334', 'column_335', 'column_336', 'column_337', 'column_338', 'column_339', 'column_340', 'column_341', 'column_342', 'column_343', 'column_344', 'column_345', 'column_346', 'column_347', 'column_348', 'column_349', 'column_350', 'column_351', 'column_352', 'column_353', 'column_354', 'column_355', 'column_356', 'column_357', 'column_358', 'column_359', 'column_360', 'column_361', 'column_362', 'column_363', 'column_364', 'column_365', 'column_366', 'column_367', 'column_368', 'column_369', 'column_370', 'column_371', 'column_372', 'column_373', 'column_374', 'column_375', 'column_376', 'column_377', 'column_378', 'column_379', 'column_380', 'column_381', 'column_382', 'column_383', 'column_384', 'column_385', 'column_386', 'column_387', 'column_388', 'column_389', 'column_390', 'column_391', 'column_392', 'column_393', 'column_394', 'column_395', 'column_396', 'column_397', 'column_398', 'column_399', 'column_400', 'column_401', 'column_402', 'column_403', 'column_404', 'column_406', 'column_407', 'column_409', 'column_410', 'column_411', 'column_412', 'column_413', 'column_414', 'column_415', 'column_416', 'column_417', 'column_418', 'column_419', 'column_420', 'column_421', 'column_422', 'column_423', 'column_424', 'column_425', 'column_426', 'column_427', 'column_428', 'column_429', 'column_430', 'column_431', 'column_432', 'column_433', 'column_434', 'column_435', 'column_436', 'column_437', 'column_438', 'column_439', 'column_440', 'column_441', 'column_442', 'column_443', 'column_444', 'column_445', 'column_446', 'column_447', 'column_448', 'column_449', 'column_450', 'column_451', 'column_452', 'column_453', 'column_454', 'column_455', 'column_456', 'column_457', 'column_458', 'column_459', 'column_460', 'column_461', 'column_462', 'column_463', 'column_464', 'column_465', 'column_466', 'column_467', 'column_468', 'column_469', 'column_470', 'column_471', 'column_472', 'column_473', 'column_474', 'column_475', 'column_476', 'column_477', 'column_478', 'column_479', 'column_480', 'column_481', 'column_482', 'column_483', 'column_484', 'column_485', 'column_486', 'column_487', 'column_488', 'column_489', 'column_490', 'column_491', 'column_492', 'column_493', 'column_494', 'column_495', 'column_496', 'column_497', 'column_498', 'column_499', 'column_500', 'column_501', 'column_502', 'column_503', 'column_504', 'column_505', 'column_506', 'column_507', 'column_508', 'column_509', 'column_510', 'column_511', 'column_512', 'column_513', 'column_514', 'column_515', 'column_516', 'column_517', 'column_518', 'column_519', 'column_520', 'column_521', 'column_522', 'column_523', 'column_524', 'column_525', 'column_526', 'column_527', 'column_528', 'column_529', 'column_530', 'column_531', 'column_532', 'column_533', 'column_534', 'column_535', 'column_536', 'column_537', 'column_538', 'column_539', 'column_540', 'column_541', 'column_542', 'column_543', 'column_544', 'column_545', 'column_546', 'column_547', 'column_548', 'column_549', 'column_550', 'column_551', 'column_552', 'column_553', 'column_554', 'column_555', 'column_556', 'column_557', 'column_558', 'column_559', 'column_560', 'column_561', 'column_562', 'column_563', 'column_564', 'column_565', 'column_566', 'column_567', 'column_568', 'column_569', 'column_570', 'column_571', 'column_572', 'column_573', 'column_574', 'column_575', 'column_576', 'column_577', 'column_578', 'column_579', 'column_580', 'column_581', 'column_582', 'column_583', 'column_584', 'column_585', 'column_586', 'column_587', 'column_588', 'column_589', 'column_590', 'column_591', 'column_592', 'column_593', 'column_594', 'column_595', 'column_596', 'column_597', 'column_598', 'column_599', 'column_600', 'column_601', 'column_602', 'column_603', 'column_604', 'column_605', 'column_606', 'column_607', 'column_608', 'column_609', 'column_610', 'column_611', 'column_612', 'column_613', 'column_614', 'column_615', 'column_616', 'column_617', 'column_618', 'column_619', 'column_620', 'column_621', 'column_622', 'column_623', 'column_624', 'column_625', 'column_626', 'column_627', 'column_628', 'column_629', 'column_630', 'column_631', 'column_632', 'column_633', 'column_634', 'column_635', 'column_636', 'column_637', 'column_638', 'column_639', 'column_640', 'column_641', 'column_642', 'column_643', 'column_644', 'column_645', 'column_646', 'column_647', 'column_648', 'column_649', 'column_650', 'column_651', 'column_652', 'column_653', 'column_654', 'column_655', 'column_656', 'column_657', 'column_658', 'column_659', 'column_660', 'column_661', 'column_662', 'column_663', 'column_664', 'column_665', 'column_666', 'column_667', 'column_668', 'column_669', 'column_670', 'column_671', 'column_672', 'column_673', 'column_674', 'column_675', 'column_676', 'column_677', 'column_678', 'column_679', 'column_680', 'column_681', 'column_682', 'column_683', 'column_684', 'column_685', 'column_686', 'column_687', 'column_693', 'column_694', 'column_695', 'column_696', 'column_697', 'column_698', 'column_699', 'column_700', 'column_701', 'column_702', 'column_703', 'column_704', 'column_705', 'column_706', 'column_707', 'column_708', 'column_709', 'column_710', 'column_711', 'column_712', 'column_713', 'column_714', 'column_715', 'column_716', 'column_717', 'column_718', 'column_719', 'column_720', 'column_721', 'column_722', 'column_723', 'column_724', 'column_725', 'column_726', 'column_727', 'column_728', 'column_729', 'column_730', 'column_731', 'column_732', 'column_733', 'column_734', 'column_735', 'column_736', 'column_737', 'column_738', 'column_739', 'column_740', 'column_741', 'column_742', 'column_743', 'column_744', 'column_745', 'column_746', 'column_747', 'column_748', 'column_749', 'column_750', 'column_751', 'column_752', 'column_753', 'column_754', 'column_755', 'column_757', 'column_758', 'column_759', 'column_760', 'column_761', 'column_762', 'column_763', 'column_764', 'column_765', 'column_766', 'column_767', 'column_768', 'column_769', 'column_770', 'column_771', 'column_772', 'column_773', 'column_774', 'column_775', 'column_776', 'column_777', 'column_778', 'column_779', 'column_780', 'column_781', 'column_782', 'column_783', 'column_784', 'column_786', 'column_787', 'column_788', 'column_789', 'column_790', 'column_791', 'column_792', 'column_793', 'column_794', 'column_795', 'column_796', 'column_797', 'column_798', 'column_799', 'column_800', 'column_801', 'column_802', 'column_803', 'column_804', 'column_805', 'column_806', 'column_807', 'column_808', 'column_809', 'column_810', 'column_811', 'column_812', 'column_813', 'column_815', 'column_816', 'column_817', 'column_818', 'column_819', 'column_820', 'column_821', 'column_822', 'column_823', 'column_824', 'column_825', 'column_826', 'column_827', 'column_828', 'column_829', 'column_830', 'column_831', 'column_832', 'column_833', 'column_834', 'column_835', 'column_836', 'column_837', 'column_838', 'column_839', 'column_840', 'column_841', 'column_842', 'column_843', 'column_844', 'column_845', 'column_846', 'column_847', 'column_848', 'column_849', 'column_850', 'column_851', 'column_852', 'column_853', 'column_854', 'column_855', 'column_856', 'column_857', 'column_858', 'column_859', 'column_860', 'column_861', 'column_862', 'column_863', 'column_864', 'column_865', 'column_866', 'column_867', 'column_868', 'column_869', 'column_870', 'column_871', 'column_872', 'column_873', 'column_874', 'column_875', 'column_876', 'column_877', 'column_878', 'column_879', 'column_880', 'column_881', 'column_882', 'column_883', 'column_884', 'column_885', 'column_886', 'column_887', 'column_888', 'column_889', 'column_890', 'column_891', 'column_892', 'column_894', 'column_895', 'column_896', 'column_897', 'column_898', 'column_899', 'column_900', 'column_901', 'column_902', 'column_903', 'column_904', 'column_905', 'column_906', 'column_907', 'column_908', 'column_909', 'column_910', 'column_911', 'column_912', 'column_913', 'column_914', 'column_915', 'column_916', 'column_917', 'column_918', 'column_919', 'column_920', 'column_921', 'column_922', 'column_923', 'column_924', 'column_925', 'column_926', 'column_927', 'column_928', 'column_929', 'column_930', 'column_931', 'column_932', 'column_933', 'column_934', 'column_935', 'column_936', 'column_937', 'column_938', 'column_939', 'column_940', 'column_941', 'column_942', 'column_943', 'column_944', 'column_945', 'column_946', 'column_947', 'column_948', 'column_949', 'column_950', 'column_951', 'column_952', 'column_953', 'column_954', 'column_955', 'column_956', 'column_957', 'column_958', 'column_959', 'column_960', 'column_961', 'column_962', 'column_963', 'column_964', 'column_965', 'column_966', 'column_967', 'column_968', 'column_969', 'column_970', 'column_971', 'column_972', 'column_973', 'column_974', 'column_975', 'column_976', 'column_977', 'column_978', 'column_979', 'column_980', 'column_981', 'column_982', 'column_983', 'column_984', 'column_985', 'column_986', 'column_987', 'column_988', 'column_989', 'column_990', 'column_991', 'column_992', 'column_993', 'column_994', 'column_995', 'column_996', 'column_997', 'column_998', 'column_999', 'column_1000', 'column_1001', 'column_1002', 'column_1003', 'column_1004', 'column_1005', 'column_1006', 'column_1007', 'column_1008', 'column_1009', 'column_1010', 'column_1011', 'column_1012', 'column_1013', 'column_1014', 'column_1015', 'column_1016', 'column_1017', 'column_1018', 'column_1019', 'column_1020', 'column_1021', 'column_1022', 'column_1023', 'column_1024', 'column_1025', 'column_1026', 'column_1027', 'column_1028', 'column_1029', 'column_1030', 'column_1031', 'column_1032', 'column_1033', 'column_1034', 'column_1035', 'column_1036', 'column_1037', 'column_1038', 'column_1039', 'column_1040', 'column_1041', 'column_1042', 'column_1043', 'column_1044', 'column_1045', 'column_1046', 'column_1047', 'column_1048', 'column_1049', 'column_1050', 'column_1051', 'column_1052', 'column_1053', 'column_1054', 'column_1055', 'column_1056', 'column_1057', 'column_1058', 'column_1059', 'column_1060', 'column_1061', 'column_1062', 'column_1063', 'column_1064', 'column_1065', 'column_1066', 'column_1067', 'column_1068', 'column_1069'};
predictors = inputTable(:, predictorNames);
response = inputTable.column_1070;
isCategoricalPredictor = [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false];

% Train a classifier
% This code specifies all the classifier options and trains the classifier.
template = templateTree(...
    'MaxNumSplits', 7358);
classificationEnsemble = fitcensemble(...
    predictors, ...
    response, ...
    'Method', 'RUSBoost', ...
    'NumLearningCycles', 230, ...
    'Learners', template, ...
    'LearnRate', 0.025, ...
    'ClassNames', [1; 2; 3; 4; 5; 6; 7; 8; 9]);

% Create the result struct with predict function
predictorExtractionFcn = @(x) array2table(x, 'VariableNames', predictorNames);
ensemblePredictFcn = @(x) predict(classificationEnsemble, x);
trainedClassifier.predictFcn = @(x) ensemblePredictFcn(predictorExtractionFcn(x));

% Add additional fields to the result struct
trainedClassifier.ClassificationEnsemble = classificationEnsemble;
trainedClassifier.About = 'This struct is a trained model exported from Classification Learner R2019a.';
trainedClassifier.HowToPredict = sprintf('To make predictions on a new predictor column matrix, X, use: \n  yfit = c.predictFcn(X) \nreplacing ''c'' with the name of the variable that is this struct, e.g. ''trainedModel''. \n \nX must contain exactly 1046 columns because this model was trained using 1046 predictors. \nX must contain only predictor columns in exactly the same order and format as your training \ndata. Do not include the response column or any columns you did not import into the app. \n \nFor more information, see <a href="matlab:helpview(fullfile(docroot, ''stats'', ''stats.map''), ''appclassification_exportmodeltoworkspace'')">How to predict using an exported model</a>.');

% Extract predictors and response
% This code processes the data into the right shape for training the
% model.
% Convert input to table
inputTable = array2table(trainingData, 'VariableNames', {'column_1', 'column_2', 'column_3', 'column_4', 'column_5', 'column_6', 'column_7', 'column_8', 'column_9', 'column_10', 'column_11', 'column_12', 'column_13', 'column_14', 'column_15', 'column_16', 'column_17', 'column_18', 'column_19', 'column_20', 'column_21', 'column_22', 'column_23', 'column_24', 'column_25', 'column_26', 'column_27', 'column_28', 'column_29', 'column_30', 'column_31', 'column_32', 'column_33', 'column_34', 'column_35', 'column_36', 'column_37', 'column_38', 'column_39', 'column_40', 'column_41', 'column_42', 'column_43', 'column_44', 'column_45', 'column_46', 'column_47', 'column_48', 'column_49', 'column_50', 'column_51', 'column_52', 'column_53', 'column_54', 'column_55', 'column_56', 'column_57', 'column_58', 'column_59', 'column_60', 'column_61', 'column_62', 'column_63', 'column_64', 'column_65', 'column_66', 'column_67', 'column_68', 'column_69', 'column_70', 'column_71', 'column_72', 'column_73', 'column_74', 'column_75', 'column_76', 'column_77', 'column_78', 'column_79', 'column_80', 'column_81', 'column_82', 'column_83', 'column_84', 'column_85', 'column_86', 'column_87', 'column_88', 'column_89', 'column_90', 'column_91', 'column_92', 'column_93', 'column_94', 'column_95', 'column_96', 'column_97', 'column_98', 'column_99', 'column_100', 'column_101', 'column_102', 'column_103', 'column_104', 'column_105', 'column_106', 'column_107', 'column_108', 'column_109', 'column_110', 'column_111', 'column_112', 'column_113', 'column_114', 'column_115', 'column_116', 'column_117', 'column_118', 'column_119', 'column_120', 'column_121', 'column_122', 'column_123', 'column_124', 'column_125', 'column_126', 'column_127', 'column_128', 'column_129', 'column_130', 'column_131', 'column_132', 'column_133', 'column_134', 'column_135', 'column_136', 'column_137', 'column_138', 'column_139', 'column_140', 'column_141', 'column_142', 'column_143', 'column_144', 'column_145', 'column_146', 'column_147', 'column_148', 'column_149', 'column_150', 'column_151', 'column_152', 'column_153', 'column_154', 'column_155', 'column_156', 'column_157', 'column_158', 'column_159', 'column_160', 'column_161', 'column_162', 'column_163', 'column_164', 'column_165', 'column_166', 'column_167', 'column_168', 'column_169', 'column_170', 'column_171', 'column_172', 'column_173', 'column_174', 'column_175', 'column_176', 'column_177', 'column_178', 'column_179', 'column_180', 'column_181', 'column_182', 'column_183', 'column_184', 'column_185', 'column_186', 'column_187', 'column_188', 'column_189', 'column_190', 'column_191', 'column_192', 'column_193', 'column_194', 'column_195', 'column_196', 'column_197', 'column_198', 'column_199', 'column_200', 'column_201', 'column_202', 'column_203', 'column_204', 'column_205', 'column_206', 'column_207', 'column_208', 'column_209', 'column_210', 'column_211', 'column_212', 'column_213', 'column_214', 'column_215', 'column_216', 'column_217', 'column_218', 'column_219', 'column_220', 'column_221', 'column_222', 'column_223', 'column_224', 'column_225', 'column_226', 'column_227', 'column_228', 'column_229', 'column_230', 'column_231', 'column_232', 'column_233', 'column_234', 'column_235', 'column_236', 'column_237', 'column_238', 'column_239', 'column_240', 'column_241', 'column_242', 'column_243', 'column_244', 'column_245', 'column_246', 'column_247', 'column_248', 'column_249', 'column_250', 'column_251', 'column_252', 'column_253', 'column_254', 'column_255', 'column_256', 'column_257', 'column_258', 'column_259', 'column_260', 'column_261', 'column_262', 'column_263', 'column_264', 'column_265', 'column_266', 'column_267', 'column_268', 'column_269', 'column_270', 'column_271', 'column_272', 'column_273', 'column_274', 'column_275', 'column_276', 'column_277', 'column_278', 'column_279', 'column_280', 'column_281', 'column_282', 'column_283', 'column_284', 'column_285', 'column_286', 'column_287', 'column_288', 'column_289', 'column_290', 'column_291', 'column_292', 'column_293', 'column_294', 'column_295', 'column_296', 'column_297', 'column_298', 'column_299', 'column_300', 'column_301', 'column_302', 'column_303', 'column_304', 'column_305', 'column_306', 'column_307', 'column_308', 'column_309', 'column_310', 'column_311', 'column_312', 'column_313', 'column_314', 'column_315', 'column_316', 'column_317', 'column_318', 'column_319', 'column_320', 'column_321', 'column_322', 'column_323', 'column_324', 'column_325', 'column_326', 'column_327', 'column_328', 'column_329', 'column_330', 'column_331', 'column_332', 'column_333', 'column_334', 'column_335', 'column_336', 'column_337', 'column_338', 'column_339', 'column_340', 'column_341', 'column_342', 'column_343', 'column_344', 'column_345', 'column_346', 'column_347', 'column_348', 'column_349', 'column_350', 'column_351', 'column_352', 'column_353', 'column_354', 'column_355', 'column_356', 'column_357', 'column_358', 'column_359', 'column_360', 'column_361', 'column_362', 'column_363', 'column_364', 'column_365', 'column_366', 'column_367', 'column_368', 'column_369', 'column_370', 'column_371', 'column_372', 'column_373', 'column_374', 'column_375', 'column_376', 'column_377', 'column_378', 'column_379', 'column_380', 'column_381', 'column_382', 'column_383', 'column_384', 'column_385', 'column_386', 'column_387', 'column_388', 'column_389', 'column_390', 'column_391', 'column_392', 'column_393', 'column_394', 'column_395', 'column_396', 'column_397', 'column_398', 'column_399', 'column_400', 'column_401', 'column_402', 'column_403', 'column_404', 'column_405', 'column_406', 'column_407', 'column_408', 'column_409', 'column_410', 'column_411', 'column_412', 'column_413', 'column_414', 'column_415', 'column_416', 'column_417', 'column_418', 'column_419', 'column_420', 'column_421', 'column_422', 'column_423', 'column_424', 'column_425', 'column_426', 'column_427', 'column_428', 'column_429', 'column_430', 'column_431', 'column_432', 'column_433', 'column_434', 'column_435', 'column_436', 'column_437', 'column_438', 'column_439', 'column_440', 'column_441', 'column_442', 'column_443', 'column_444', 'column_445', 'column_446', 'column_447', 'column_448', 'column_449', 'column_450', 'column_451', 'column_452', 'column_453', 'column_454', 'column_455', 'column_456', 'column_457', 'column_458', 'column_459', 'column_460', 'column_461', 'column_462', 'column_463', 'column_464', 'column_465', 'column_466', 'column_467', 'column_468', 'column_469', 'column_470', 'column_471', 'column_472', 'column_473', 'column_474', 'column_475', 'column_476', 'column_477', 'column_478', 'column_479', 'column_480', 'column_481', 'column_482', 'column_483', 'column_484', 'column_485', 'column_486', 'column_487', 'column_488', 'column_489', 'column_490', 'column_491', 'column_492', 'column_493', 'column_494', 'column_495', 'column_496', 'column_497', 'column_498', 'column_499', 'column_500', 'column_501', 'column_502', 'column_503', 'column_504', 'column_505', 'column_506', 'column_507', 'column_508', 'column_509', 'column_510', 'column_511', 'column_512', 'column_513', 'column_514', 'column_515', 'column_516', 'column_517', 'column_518', 'column_519', 'column_520', 'column_521', 'column_522', 'column_523', 'column_524', 'column_525', 'column_526', 'column_527', 'column_528', 'column_529', 'column_530', 'column_531', 'column_532', 'column_533', 'column_534', 'column_535', 'column_536', 'column_537', 'column_538', 'column_539', 'column_540', 'column_541', 'column_542', 'column_543', 'column_544', 'column_545', 'column_546', 'column_547', 'column_548', 'column_549', 'column_550', 'column_551', 'column_552', 'column_553', 'column_554', 'column_555', 'column_556', 'column_557', 'column_558', 'column_559', 'column_560', 'column_561', 'column_562', 'column_563', 'column_564', 'column_565', 'column_566', 'column_567', 'column_568', 'column_569', 'column_570', 'column_571', 'column_572', 'column_573', 'column_574', 'column_575', 'column_576', 'column_577', 'column_578', 'column_579', 'column_580', 'column_581', 'column_582', 'column_583', 'column_584', 'column_585', 'column_586', 'column_587', 'column_588', 'column_589', 'column_590', 'column_591', 'column_592', 'column_593', 'column_594', 'column_595', 'column_596', 'column_597', 'column_598', 'column_599', 'column_600', 'column_601', 'column_602', 'column_603', 'column_604', 'column_605', 'column_606', 'column_607', 'column_608', 'column_609', 'column_610', 'column_611', 'column_612', 'column_613', 'column_614', 'column_615', 'column_616', 'column_617', 'column_618', 'column_619', 'column_620', 'column_621', 'column_622', 'column_623', 'column_624', 'column_625', 'column_626', 'column_627', 'column_628', 'column_629', 'column_630', 'column_631', 'column_632', 'column_633', 'column_634', 'column_635', 'column_636', 'column_637', 'column_638', 'column_639', 'column_640', 'column_641', 'column_642', 'column_643', 'column_644', 'column_645', 'column_646', 'column_647', 'column_648', 'column_649', 'column_650', 'column_651', 'column_652', 'column_653', 'column_654', 'column_655', 'column_656', 'column_657', 'column_658', 'column_659', 'column_660', 'column_661', 'column_662', 'column_663', 'column_664', 'column_665', 'column_666', 'column_667', 'column_668', 'column_669', 'column_670', 'column_671', 'column_672', 'column_673', 'column_674', 'column_675', 'column_676', 'column_677', 'column_678', 'column_679', 'column_680', 'column_681', 'column_682', 'column_683', 'column_684', 'column_685', 'column_686', 'column_687', 'column_688', 'column_689', 'column_690', 'column_691', 'column_692', 'column_693', 'column_694', 'column_695', 'column_696', 'column_697', 'column_698', 'column_699', 'column_700', 'column_701', 'column_702', 'column_703', 'column_704', 'column_705', 'column_706', 'column_707', 'column_708', 'column_709', 'column_710', 'column_711', 'column_712', 'column_713', 'column_714', 'column_715', 'column_716', 'column_717', 'column_718', 'column_719', 'column_720', 'column_721', 'column_722', 'column_723', 'column_724', 'column_725', 'column_726', 'column_727', 'column_728', 'column_729', 'column_730', 'column_731', 'column_732', 'column_733', 'column_734', 'column_735', 'column_736', 'column_737', 'column_738', 'column_739', 'column_740', 'column_741', 'column_742', 'column_743', 'column_744', 'column_745', 'column_746', 'column_747', 'column_748', 'column_749', 'column_750', 'column_751', 'column_752', 'column_753', 'column_754', 'column_755', 'column_756', 'column_757', 'column_758', 'column_759', 'column_760', 'column_761', 'column_762', 'column_763', 'column_764', 'column_765', 'column_766', 'column_767', 'column_768', 'column_769', 'column_770', 'column_771', 'column_772', 'column_773', 'column_774', 'column_775', 'column_776', 'column_777', 'column_778', 'column_779', 'column_780', 'column_781', 'column_782', 'column_783', 'column_784', 'column_785', 'column_786', 'column_787', 'column_788', 'column_789', 'column_790', 'column_791', 'column_792', 'column_793', 'column_794', 'column_795', 'column_796', 'column_797', 'column_798', 'column_799', 'column_800', 'column_801', 'column_802', 'column_803', 'column_804', 'column_805', 'column_806', 'column_807', 'column_808', 'column_809', 'column_810', 'column_811', 'column_812', 'column_813', 'column_814', 'column_815', 'column_816', 'column_817', 'column_818', 'column_819', 'column_820', 'column_821', 'column_822', 'column_823', 'column_824', 'column_825', 'column_826', 'column_827', 'column_828', 'column_829', 'column_830', 'column_831', 'column_832', 'column_833', 'column_834', 'column_835', 'column_836', 'column_837', 'column_838', 'column_839', 'column_840', 'column_841', 'column_842', 'column_843', 'column_844', 'column_845', 'column_846', 'column_847', 'column_848', 'column_849', 'column_850', 'column_851', 'column_852', 'column_853', 'column_854', 'column_855', 'column_856', 'column_857', 'column_858', 'column_859', 'column_860', 'column_861', 'column_862', 'column_863', 'column_864', 'column_865', 'column_866', 'column_867', 'column_868', 'column_869', 'column_870', 'column_871', 'column_872', 'column_873', 'column_874', 'column_875', 'column_876', 'column_877', 'column_878', 'column_879', 'column_880', 'column_881', 'column_882', 'column_883', 'column_884', 'column_885', 'column_886', 'column_887', 'column_888', 'column_889', 'column_890', 'column_891', 'column_892', 'column_893', 'column_894', 'column_895', 'column_896', 'column_897', 'column_898', 'column_899', 'column_900', 'column_901', 'column_902', 'column_903', 'column_904', 'column_905', 'column_906', 'column_907', 'column_908', 'column_909', 'column_910', 'column_911', 'column_912', 'column_913', 'column_914', 'column_915', 'column_916', 'column_917', 'column_918', 'column_919', 'column_920', 'column_921', 'column_922', 'column_923', 'column_924', 'column_925', 'column_926', 'column_927', 'column_928', 'column_929', 'column_930', 'column_931', 'column_932', 'column_933', 'column_934', 'column_935', 'column_936', 'column_937', 'column_938', 'column_939', 'column_940', 'column_941', 'column_942', 'column_943', 'column_944', 'column_945', 'column_946', 'column_947', 'column_948', 'column_949', 'column_950', 'column_951', 'column_952', 'column_953', 'column_954', 'column_955', 'column_956', 'column_957', 'column_958', 'column_959', 'column_960', 'column_961', 'column_962', 'column_963', 'column_964', 'column_965', 'column_966', 'column_967', 'column_968', 'column_969', 'column_970', 'column_971', 'column_972', 'column_973', 'column_974', 'column_975', 'column_976', 'column_977', 'column_978', 'column_979', 'column_980', 'column_981', 'column_982', 'column_983', 'column_984', 'column_985', 'column_986', 'column_987', 'column_988', 'column_989', 'column_990', 'column_991', 'column_992', 'column_993', 'column_994', 'column_995', 'column_996', 'column_997', 'column_998', 'column_999', 'column_1000', 'column_1001', 'column_1002', 'column_1003', 'column_1004', 'column_1005', 'column_1006', 'column_1007', 'column_1008', 'column_1009', 'column_1010', 'column_1011', 'column_1012', 'column_1013', 'column_1014', 'column_1015', 'column_1016', 'column_1017', 'column_1018', 'column_1019', 'column_1020', 'column_1021', 'column_1022', 'column_1023', 'column_1024', 'column_1025', 'column_1026', 'column_1027', 'column_1028', 'column_1029', 'column_1030', 'column_1031', 'column_1032', 'column_1033', 'column_1034', 'column_1035', 'column_1036', 'column_1037', 'column_1038', 'column_1039', 'column_1040', 'column_1041', 'column_1042', 'column_1043', 'column_1044', 'column_1045', 'column_1046', 'column_1047', 'column_1048', 'column_1049', 'column_1050', 'column_1051', 'column_1052', 'column_1053', 'column_1054', 'column_1055', 'column_1056', 'column_1057', 'column_1058', 'column_1059', 'column_1060', 'column_1061', 'column_1062', 'column_1063', 'column_1064', 'column_1065', 'column_1066', 'column_1067', 'column_1068', 'column_1069', 'column_1070'});

predictorNames = {'column_1', 'column_2', 'column_3', 'column_4', 'column_5', 'column_6', 'column_7', 'column_8', 'column_9', 'column_10', 'column_11', 'column_12', 'column_13', 'column_14', 'column_15', 'column_16', 'column_17', 'column_18', 'column_19', 'column_20', 'column_21', 'column_22', 'column_23', 'column_24', 'column_25', 'column_26', 'column_27', 'column_28', 'column_29', 'column_30', 'column_31', 'column_32', 'column_33', 'column_34', 'column_35', 'column_36', 'column_37', 'column_38', 'column_39', 'column_40', 'column_41', 'column_42', 'column_43', 'column_44', 'column_45', 'column_46', 'column_47', 'column_48', 'column_49', 'column_50', 'column_51', 'column_52', 'column_53', 'column_54', 'column_55', 'column_56', 'column_57', 'column_58', 'column_59', 'column_60', 'column_61', 'column_62', 'column_63', 'column_64', 'column_65', 'column_66', 'column_67', 'column_68', 'column_69', 'column_70', 'column_71', 'column_72', 'column_73', 'column_74', 'column_75', 'column_76', 'column_77', 'column_78', 'column_79', 'column_80', 'column_85', 'column_86', 'column_87', 'column_88', 'column_89', 'column_90', 'column_91', 'column_92', 'column_93', 'column_94', 'column_95', 'column_96', 'column_97', 'column_98', 'column_103', 'column_104', 'column_105', 'column_106', 'column_107', 'column_108', 'column_109', 'column_110', 'column_111', 'column_112', 'column_113', 'column_114', 'column_115', 'column_116', 'column_117', 'column_118', 'column_119', 'column_120', 'column_121', 'column_122', 'column_123', 'column_124', 'column_125', 'column_126', 'column_127', 'column_128', 'column_129', 'column_130', 'column_131', 'column_132', 'column_133', 'column_134', 'column_135', 'column_136', 'column_137', 'column_138', 'column_139', 'column_140', 'column_141', 'column_142', 'column_143', 'column_144', 'column_145', 'column_146', 'column_147', 'column_148', 'column_149', 'column_150', 'column_151', 'column_152', 'column_153', 'column_154', 'column_155', 'column_156', 'column_157', 'column_158', 'column_159', 'column_160', 'column_161', 'column_162', 'column_163', 'column_164', 'column_165', 'column_166', 'column_167', 'column_168', 'column_169', 'column_170', 'column_171', 'column_172', 'column_173', 'column_174', 'column_175', 'column_176', 'column_177', 'column_178', 'column_179', 'column_180', 'column_181', 'column_182', 'column_183', 'column_184', 'column_185', 'column_186', 'column_187', 'column_188', 'column_189', 'column_190', 'column_191', 'column_192', 'column_193', 'column_194', 'column_195', 'column_196', 'column_197', 'column_198', 'column_199', 'column_200', 'column_201', 'column_202', 'column_203', 'column_204', 'column_205', 'column_206', 'column_207', 'column_208', 'column_209', 'column_210', 'column_211', 'column_213', 'column_214', 'column_216', 'column_217', 'column_218', 'column_219', 'column_220', 'column_221', 'column_222', 'column_223', 'column_224', 'column_225', 'column_226', 'column_227', 'column_228', 'column_229', 'column_230', 'column_231', 'column_232', 'column_233', 'column_234', 'column_235', 'column_236', 'column_237', 'column_238', 'column_239', 'column_240', 'column_241', 'column_242', 'column_243', 'column_244', 'column_245', 'column_246', 'column_247', 'column_249', 'column_250', 'column_251', 'column_252', 'column_253', 'column_254', 'column_255', 'column_256', 'column_257', 'column_258', 'column_259', 'column_260', 'column_261', 'column_262', 'column_263', 'column_264', 'column_265', 'column_266', 'column_267', 'column_268', 'column_269', 'column_270', 'column_271', 'column_272', 'column_273', 'column_275', 'column_276', 'column_277', 'column_278', 'column_279', 'column_280', 'column_281', 'column_282', 'column_283', 'column_284', 'column_285', 'column_286', 'column_287', 'column_288', 'column_289', 'column_290', 'column_291', 'column_292', 'column_293', 'column_294', 'column_295', 'column_296', 'column_297', 'column_298', 'column_299', 'column_300', 'column_301', 'column_302', 'column_303', 'column_304', 'column_305', 'column_306', 'column_307', 'column_308', 'column_309', 'column_310', 'column_311', 'column_312', 'column_313', 'column_314', 'column_315', 'column_316', 'column_317', 'column_318', 'column_319', 'column_320', 'column_321', 'column_322', 'column_323', 'column_324', 'column_325', 'column_326', 'column_327', 'column_328', 'column_329', 'column_330', 'column_331', 'column_332', 'column_333', 'column_334', 'column_335', 'column_336', 'column_337', 'column_338', 'column_339', 'column_340', 'column_341', 'column_342', 'column_343', 'column_344', 'column_345', 'column_346', 'column_347', 'column_348', 'column_349', 'column_350', 'column_351', 'column_352', 'column_353', 'column_354', 'column_355', 'column_356', 'column_357', 'column_358', 'column_359', 'column_360', 'column_361', 'column_362', 'column_363', 'column_364', 'column_365', 'column_366', 'column_367', 'column_368', 'column_369', 'column_370', 'column_371', 'column_372', 'column_373', 'column_374', 'column_375', 'column_376', 'column_377', 'column_378', 'column_379', 'column_380', 'column_381', 'column_382', 'column_383', 'column_384', 'column_385', 'column_386', 'column_387', 'column_388', 'column_389', 'column_390', 'column_391', 'column_392', 'column_393', 'column_394', 'column_395', 'column_396', 'column_397', 'column_398', 'column_399', 'column_400', 'column_401', 'column_402', 'column_403', 'column_404', 'column_406', 'column_407', 'column_409', 'column_410', 'column_411', 'column_412', 'column_413', 'column_414', 'column_415', 'column_416', 'column_417', 'column_418', 'column_419', 'column_420', 'column_421', 'column_422', 'column_423', 'column_424', 'column_425', 'column_426', 'column_427', 'column_428', 'column_429', 'column_430', 'column_431', 'column_432', 'column_433', 'column_434', 'column_435', 'column_436', 'column_437', 'column_438', 'column_439', 'column_440', 'column_441', 'column_442', 'column_443', 'column_444', 'column_445', 'column_446', 'column_447', 'column_448', 'column_449', 'column_450', 'column_451', 'column_452', 'column_453', 'column_454', 'column_455', 'column_456', 'column_457', 'column_458', 'column_459', 'column_460', 'column_461', 'column_462', 'column_463', 'column_464', 'column_465', 'column_466', 'column_467', 'column_468', 'column_469', 'column_470', 'column_471', 'column_472', 'column_473', 'column_474', 'column_475', 'column_476', 'column_477', 'column_478', 'column_479', 'column_480', 'column_481', 'column_482', 'column_483', 'column_484', 'column_485', 'column_486', 'column_487', 'column_488', 'column_489', 'column_490', 'column_491', 'column_492', 'column_493', 'column_494', 'column_495', 'column_496', 'column_497', 'column_498', 'column_499', 'column_500', 'column_501', 'column_502', 'column_503', 'column_504', 'column_505', 'column_506', 'column_507', 'column_508', 'column_509', 'column_510', 'column_511', 'column_512', 'column_513', 'column_514', 'column_515', 'column_516', 'column_517', 'column_518', 'column_519', 'column_520', 'column_521', 'column_522', 'column_523', 'column_524', 'column_525', 'column_526', 'column_527', 'column_528', 'column_529', 'column_530', 'column_531', 'column_532', 'column_533', 'column_534', 'column_535', 'column_536', 'column_537', 'column_538', 'column_539', 'column_540', 'column_541', 'column_542', 'column_543', 'column_544', 'column_545', 'column_546', 'column_547', 'column_548', 'column_549', 'column_550', 'column_551', 'column_552', 'column_553', 'column_554', 'column_555', 'column_556', 'column_557', 'column_558', 'column_559', 'column_560', 'column_561', 'column_562', 'column_563', 'column_564', 'column_565', 'column_566', 'column_567', 'column_568', 'column_569', 'column_570', 'column_571', 'column_572', 'column_573', 'column_574', 'column_575', 'column_576', 'column_577', 'column_578', 'column_579', 'column_580', 'column_581', 'column_582', 'column_583', 'column_584', 'column_585', 'column_586', 'column_587', 'column_588', 'column_589', 'column_590', 'column_591', 'column_592', 'column_593', 'column_594', 'column_595', 'column_596', 'column_597', 'column_598', 'column_599', 'column_600', 'column_601', 'column_602', 'column_603', 'column_604', 'column_605', 'column_606', 'column_607', 'column_608', 'column_609', 'column_610', 'column_611', 'column_612', 'column_613', 'column_614', 'column_615', 'column_616', 'column_617', 'column_618', 'column_619', 'column_620', 'column_621', 'column_622', 'column_623', 'column_624', 'column_625', 'column_626', 'column_627', 'column_628', 'column_629', 'column_630', 'column_631', 'column_632', 'column_633', 'column_634', 'column_635', 'column_636', 'column_637', 'column_638', 'column_639', 'column_640', 'column_641', 'column_642', 'column_643', 'column_644', 'column_645', 'column_646', 'column_647', 'column_648', 'column_649', 'column_650', 'column_651', 'column_652', 'column_653', 'column_654', 'column_655', 'column_656', 'column_657', 'column_658', 'column_659', 'column_660', 'column_661', 'column_662', 'column_663', 'column_664', 'column_665', 'column_666', 'column_667', 'column_668', 'column_669', 'column_670', 'column_671', 'column_672', 'column_673', 'column_674', 'column_675', 'column_676', 'column_677', 'column_678', 'column_679', 'column_680', 'column_681', 'column_682', 'column_683', 'column_684', 'column_685', 'column_686', 'column_687', 'column_693', 'column_694', 'column_695', 'column_696', 'column_697', 'column_698', 'column_699', 'column_700', 'column_701', 'column_702', 'column_703', 'column_704', 'column_705', 'column_706', 'column_707', 'column_708', 'column_709', 'column_710', 'column_711', 'column_712', 'column_713', 'column_714', 'column_715', 'column_716', 'column_717', 'column_718', 'column_719', 'column_720', 'column_721', 'column_722', 'column_723', 'column_724', 'column_725', 'column_726', 'column_727', 'column_728', 'column_729', 'column_730', 'column_731', 'column_732', 'column_733', 'column_734', 'column_735', 'column_736', 'column_737', 'column_738', 'column_739', 'column_740', 'column_741', 'column_742', 'column_743', 'column_744', 'column_745', 'column_746', 'column_747', 'column_748', 'column_749', 'column_750', 'column_751', 'column_752', 'column_753', 'column_754', 'column_755', 'column_757', 'column_758', 'column_759', 'column_760', 'column_761', 'column_762', 'column_763', 'column_764', 'column_765', 'column_766', 'column_767', 'column_768', 'column_769', 'column_770', 'column_771', 'column_772', 'column_773', 'column_774', 'column_775', 'column_776', 'column_777', 'column_778', 'column_779', 'column_780', 'column_781', 'column_782', 'column_783', 'column_784', 'column_786', 'column_787', 'column_788', 'column_789', 'column_790', 'column_791', 'column_792', 'column_793', 'column_794', 'column_795', 'column_796', 'column_797', 'column_798', 'column_799', 'column_800', 'column_801', 'column_802', 'column_803', 'column_804', 'column_805', 'column_806', 'column_807', 'column_808', 'column_809', 'column_810', 'column_811', 'column_812', 'column_813', 'column_815', 'column_816', 'column_817', 'column_818', 'column_819', 'column_820', 'column_821', 'column_822', 'column_823', 'column_824', 'column_825', 'column_826', 'column_827', 'column_828', 'column_829', 'column_830', 'column_831', 'column_832', 'column_833', 'column_834', 'column_835', 'column_836', 'column_837', 'column_838', 'column_839', 'column_840', 'column_841', 'column_842', 'column_843', 'column_844', 'column_845', 'column_846', 'column_847', 'column_848', 'column_849', 'column_850', 'column_851', 'column_852', 'column_853', 'column_854', 'column_855', 'column_856', 'column_857', 'column_858', 'column_859', 'column_860', 'column_861', 'column_862', 'column_863', 'column_864', 'column_865', 'column_866', 'column_867', 'column_868', 'column_869', 'column_870', 'column_871', 'column_872', 'column_873', 'column_874', 'column_875', 'column_876', 'column_877', 'column_878', 'column_879', 'column_880', 'column_881', 'column_882', 'column_883', 'column_884', 'column_885', 'column_886', 'column_887', 'column_888', 'column_889', 'column_890', 'column_891', 'column_892', 'column_894', 'column_895', 'column_896', 'column_897', 'column_898', 'column_899', 'column_900', 'column_901', 'column_902', 'column_903', 'column_904', 'column_905', 'column_906', 'column_907', 'column_908', 'column_909', 'column_910', 'column_911', 'column_912', 'column_913', 'column_914', 'column_915', 'column_916', 'column_917', 'column_918', 'column_919', 'column_920', 'column_921', 'column_922', 'column_923', 'column_924', 'column_925', 'column_926', 'column_927', 'column_928', 'column_929', 'column_930', 'column_931', 'column_932', 'column_933', 'column_934', 'column_935', 'column_936', 'column_937', 'column_938', 'column_939', 'column_940', 'column_941', 'column_942', 'column_943', 'column_944', 'column_945', 'column_946', 'column_947', 'column_948', 'column_949', 'column_950', 'column_951', 'column_952', 'column_953', 'column_954', 'column_955', 'column_956', 'column_957', 'column_958', 'column_959', 'column_960', 'column_961', 'column_962', 'column_963', 'column_964', 'column_965', 'column_966', 'column_967', 'column_968', 'column_969', 'column_970', 'column_971', 'column_972', 'column_973', 'column_974', 'column_975', 'column_976', 'column_977', 'column_978', 'column_979', 'column_980', 'column_981', 'column_982', 'column_983', 'column_984', 'column_985', 'column_986', 'column_987', 'column_988', 'column_989', 'column_990', 'column_991', 'column_992', 'column_993', 'column_994', 'column_995', 'column_996', 'column_997', 'column_998', 'column_999', 'column_1000', 'column_1001', 'column_1002', 'column_1003', 'column_1004', 'column_1005', 'column_1006', 'column_1007', 'column_1008', 'column_1009', 'column_1010', 'column_1011', 'column_1012', 'column_1013', 'column_1014', 'column_1015', 'column_1016', 'column_1017', 'column_1018', 'column_1019', 'column_1020', 'column_1021', 'column_1022', 'column_1023', 'column_1024', 'column_1025', 'column_1026', 'column_1027', 'column_1028', 'column_1029', 'column_1030', 'column_1031', 'column_1032', 'column_1033', 'column_1034', 'column_1035', 'column_1036', 'column_1037', 'column_1038', 'column_1039', 'column_1040', 'column_1041', 'column_1042', 'column_1043', 'column_1044', 'column_1045', 'column_1046', 'column_1047', 'column_1048', 'column_1049', 'column_1050', 'column_1051', 'column_1052', 'column_1053', 'column_1054', 'column_1055', 'column_1056', 'column_1057', 'column_1058', 'column_1059', 'column_1060', 'column_1061', 'column_1062', 'column_1063', 'column_1064', 'column_1065', 'column_1066', 'column_1067', 'column_1068', 'column_1069'};
predictors = inputTable(:, predictorNames);
response = inputTable.column_1070;
isCategoricalPredictor = [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false];

% Perform cross-validation
partitionedModel = crossval(trainedClassifier.ClassificationEnsemble, 'KFold', 5);

% Compute validation predictions
[validationPredictions, validationScores] = kfoldPredict(partitionedModel);

% Compute validation accuracy
validationAccuracy = 1 - kfoldLoss(partitionedModel, 'LossFun', 'ClassifError');
