function features=qrsClassify(yp,QRS)
rr=yp(QRS);
rra=abs(rr);
medv=median(rra);
ffType1=find((rra)<=1.5*medv);
ffType2=find((rra)>1.5*medv);
ffTypes=ones(length(rr),1);
ffTypes(ffType2)=2;
ratio1=length(ffType1)/length(rra);
ratio2=length(ffType2)/length(rra);
len=length(yp);
peakMag1=yp(QRS(ffType1));
peakMag2=yp(QRS(ffType2));
diffsType1=[];diffsType2=[];
for k=1:length(QRS)-1
    if ffTypes(k)==1 && ffTypes(k+1)==1
        diffsType1=[diffsType1,QRS(k+1)-QRS(k)];
    else
        if ffTypes(k)==2 && ffTypes(k+1)==2
            diffsType2=[diffsType2,QRS(k+1)-QRS(k)];
        end
    end
end
val1=std(peakMag1);
val2=std(peakMag2);
valm1=mean(peakMag1)/max(rra);
valm2=mean(peakMag2)/max(rra);
llp1=median(diffsType1);
llp2=median(diffsType2);
vala1=std(diffsType1);
vala2=std(diffsType2);
valb1=vala1/llp1;
valb2=vala2/llp2;
features=[ratio1,val1,valm1,llp1,vala1,valb1,ratio2,val2,valm2,llp2,vala2,valb2];
features(isnan(features)==1)=0;
% type1QRS=rr();
% averageDiff=median(diff(QRS));
feats1=[];feats2=[];feats3=[];feats4=[];feats5=[];feats6=[];feats7=[];feats8=[];feats9=[];
feats10=[];feats11=[];feats12=[];feats13=[];feats14=[];feats15=[];feats16=[];feats17=[];
feats18=[];feats19=[];feats20=[];feats21=[];feats22=[];feats23=[];feats24=[];feats25=[];
for i=1:length(QRS)-1
    if ffTypes(i)==1 && ffTypes(i+1)==1
        ypp=yp(QRS(i)+1:QRS(i+1));
        ypps=sort(ypp);
        went1=wentropy(ypps(1:round(end/5)),'shannon');
        went2=wentropy(ypps(round(end/5):round(2*end/5)),'shannon');
        went3=wentropy(ypps(round(2*end/5):round(3*end/5)),'shannon');
        went4=wentropy(ypps(round(3*end/5):round(4*end/5)),'shannon');
        went5=wentropy(ypps(round(4*end/5):round(end)),'shannon');
        %     wents=sort([went1,went2,went3,went4]);
        wents=min([went1,went2,went3,went4,went5]);
        wents2=median([went1,went2,went3,went4,went5]);
        wents3=max([went1,went2,went3,went4,went5]);
        feats1=[feats1,mean(ypp)];
        feats2=[feats2,std(ypp)];
        [peakLoc1, peakMag1] = peakfinder(ypp);
        val3=std(peakMag1);
        llp=length(peakLoc1);
        val4=std(peakLoc1);
        if isnan(val3)==1
            val3=0;llp=0;val4=0;
        end
        feats3=[feats3,llp];
        feats4=[feats4,moment(ypp,4)];
        feats5=[feats5,kurtosis(ypp)];
        feats6=[feats6,moment(ypp,6)];
        feats7=[feats7,wents];
        feats8=[feats8,val3];
        feats9=[feats9,val4];
        za=mvsampen_fullA(ypp(:)');
        feats24=[feats24,za];
        feats10=[feats10,wents3];
        feats11=[feats11,wents2];
        feats12=[feats12,wents];
        feats13=[feats13,meanfreq(ypp)];
        feats14=[feats14,median(dutycycle(ypp))];
        z1=statelevels(ypp);
        feats15=[feats15,min(z1)];
        feats16=[feats16,max(z1)];
        feats17=[feats17,median(pulseperiod(ypp))];
        feats18=[feats18,median(falltime(ypp))];
        feats19=[feats19,median(pulsewidth(ypp))];
        feats20=[feats20,median(abs(fft(ypp)))];
        feats21=[feats21,median(angle(fft(ypp)))];
        feats22=[feats22,median(overshoot(ypp))];
        feats23=[feats23,median(histcounts(ypp))];
        %     else
        %         if ffTypes(i)==2 && ffTypes(i+1)==2
        %             ypp=yp(QRS(i)+1:QRS(i+1));
        
        %         end
    end
end
features1=[median(feats1),median(feats2),median(feats3),median(feats4),median(feats5),median(feats6),median(feats7),median(feats8),...
    median(feats9),median(feats10),median(feats11),median(feats12),median(feats13),median(feats14),median(feats15),median(feats16),median(feats17),median(feats18),...
    median(feats19),median(feats20),median(feats21),median(feats22),median(feats23),median(feats24)];
features1=[features1,std(feats1),std(feats2),std(feats3),std(feats4),std(feats5),std(feats6),std(feats7),std(feats8),...
    std(feats9),std(feats10),std(feats11),std(feats12),std(feats13),std(feats14),std(feats15),std(feats16),std(feats17),std(feats18),...
    std(feats19),std(feats20),std(feats21),std(feats22),std(feats23),std(feats24)];
feats1=[];feats2=[];feats3=[];feats4=[];feats5=[];feats6=[];feats7=[];feats8=[];feats9=[];
feats10=[];feats11=[];feats12=[];feats13=[];feats14=[];feats15=[];feats16=[];feats17=[];
feats18=[];feats19=[];feats20=[];feats21=[];feats22=[];feats23=[];feats24=[];feats25=[];

for i=1:length(QRS)-1
    %     feats24=[feats24,meanfreq(ypp)];
    %     feats25=[feats25,meanfreq(ypp)];
    if ffTypes(i)==2 && ffTypes(i+1)==2
        %             ypp=yp(QRS(i)+1:QRS(i+1));
        ypp=yp(QRS(i)+1:QRS(i+1));
        ypps=sort(ypp);
        went1=wentropy(ypps(1:round(end/5)),'shannon');
        went2=wentropy(ypps(round(end/5):round(2*end/5)),'shannon');
        went3=wentropy(ypps(round(2*end/5):round(3*end/5)),'shannon');
        went4=wentropy(ypps(round(3*end/5):round(4*end/5)),'shannon');
        went5=wentropy(ypps(round(4*end/5):round(end)),'shannon');
        %     wents=sort([went1,went2,went3,went4]);
        wents=min([went1,went2,went3,went4,went5]);
        wents2=median([went1,went2,went3,went4,went5]);
        wents3=max([went1,went2,went3,went4,went5]);
        feats1=[feats1,mean(ypp)];
        feats2=[feats2,std(ypp)];
        [peakLoc1, peakMag1] = peakfinder(ypp);
        val3=std(peakMag1);
        llp=length(peakLoc1);
        val4=std(peakLoc1);
        if isnan(val3)==1
            val3=0;llp=0;val4=0;
        end
        feats3=[feats3,llp];
        feats4=[feats4,moment(ypp,4)];
        feats5=[feats5,kurtosis(ypp)];
        feats6=[feats6,moment(ypp,6)];
        feats7=[feats7,wents];
        feats8=[feats8,val3];
        feats9=[feats9,val4];
        za=mvsampen_fullA(ypp(:)');
        feats24=[feats24,za];
        feats10=[feats10,wents3];
        feats11=[feats11,wents2];
        feats12=[feats12,wents];
        feats13=[feats13,meanfreq(ypp)];
        feats14=[feats14,median(dutycycle(ypp))];
        z1=statelevels(ypp);
        feats15=[feats15,min(z1)];
        feats16=[feats16,max(z1)];
        feats17=[feats17,median(pulseperiod(ypp))];
        feats18=[feats18,median(falltime(ypp))];
        feats19=[feats19,median(pulsewidth(ypp))];
        feats20=[feats20,median(abs(fft(ypp)))];
        feats21=[feats21,median(angle(fft(ypp)))];
        feats22=[feats22,median(overshoot(ypp))];
        feats23=[feats23,median(histcounts(ypp))];
    end
end

features2=[median(feats1),median(feats2),median(feats3),median(feats4),median(feats5),median(feats6),median(feats7),median(feats8),...
    median(feats9),median(feats10),median(feats11),median(feats12),median(feats13),median(feats14),median(feats15),median(feats16),median(feats17),median(feats18),...
    median(feats19),median(feats20),median(feats21),median(feats22),median(feats23),median(feats24)];
features2=[features2,std(feats1),std(feats2),std(feats3),std(feats4),std(feats5),std(feats6),std(feats7),std(feats8),...
    std(feats9),std(feats10),std(feats11),std(feats12),std(feats13),std(feats14),std(feats15),std(feats16),std(feats17),std(feats18),...
    std(feats19),std(feats20),std(feats21),std(feats22),std(feats23),std(feats24)];


features=[features,features1,features2];
features(isnan(features)==1)=0;
