function [otherFeatures,qz] = getECGresultsOther3(signal)

dataSize = 3500;

fs = 500;

chanResult.qrs=[];
chanResult.group=[];
chanResult.rr=[];
chanResult.lfMaxLength=0;



if size(signal,2) == 1
    signal = signal';
end

% filter

f = 20;
[b,a] = butter(3, 2*f/fs, 'low');
signal = filtfilt(b,a,signal);

% distance and ratio
min_samp_to_next = fix(fs*0.11);

winSize = 0.15*200;
winStep = 5;
limitVarRange = 5;


rawVRsignal = zeros(dataSize,1);

for pos = 1:winStep:dataSize-winSize
    
    winStart = floor(pos);
    winEnd = floor(pos+winSize);
    
    block = signal(min(winStart,end):min(winEnd,end));
    varRange = max(block)-min(block);
    
    halfPos = floor(winSize/2);
    
    leftAVG = mean(block(1:min(halfPos,end)));
    rightAVG = mean(block(min(halfPos,end):end));
    
    if (rightAVG>leftAVG) || (varRange>=limitVarRange)
        
        rawVRsignal(min(winStart,end):min(winEnd,end)) = varRange;
    end
end

f = 3;
[b,a] = butter(3, 2*f/fs, 'low');
smoothVR = filtfilt(b,a,rawVRsignal);


markList = [];

% if max(smoothVR)>5
[vals,locs] = findpeaks(smoothVR,'MinPeakHeight',.2*max(smoothVR));



areaDomSize = 50;

perc = prctile(smoothVR,50);

for m=1:length(locs)
    
    adl = locs(m)-areaDomSize/2;
    adr = locs(m)+areaDomSize/2;
    
    if adl<1
        adl = 1;
    end
    
    if adr>dataSize
        adr = dataSize;
    end
    
    bm = smoothVR(adl:adr);
    
    maxValue = smoothVR(locs(m));
    
    if max(bm)<=maxValue && maxValue>perc
        markList(length(markList)+1)=locs(m);
    end
    
end
% end

chanResult.qrs = markList;
chanResult.rr = diff(chanResult.qrs)/fs;
% size(chanResult.qrs(:))
% size(chanResult.rr(:))
qz=chanResult.qrs(:);
otherFeatures=[min(chanResult.rr(:)),median(chanResult.rr(:)),max(chanResult.rr(:)),std(chanResult.rr(:)),moment(chanResult.rr(:),3),moment(chanResult.rr(:),5)];
otherFeatures(find(isnan(otherFeatures)))=0;
if length(otherFeatures)<6
    otherFeatures=zeros(1,6);
end
df=diff(qz);
otherFeatures2=[min(df),median(df),max(df),std(df),moment(df,3),moment(df,7)];
otherFeatures2(find(isnan(otherFeatures2)))=0;
if length(otherFeatures2)<6
    otherFeatures2=zeros(1,6);
end
otherFeatures=[otherFeatures,otherFeatures2];
