function [otherFeatures,qz] = getECGresultsOther(signal)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here


dataLF = hobalka(signal.*1,200,1,10).*1;
dataMF = hobalka(signal.*1,200,5,25).*1;
dataHF = hobalka(signal.*1,200,50,70).*1;

minPeakDistance = 0.11 * 200;
% p75samples = 0.5 * 200;

statRawSamples = 0.12 * 200;% //--velikost okna pro posuzovn statistiky surovch dat - krtkodob oblast
statRawLongSamples = 0.5 * 200; % //--dlouhodob oblast

statRawKVR = 0.5 ;% //-- nejmen pomr mezi VR krtk a dlouh oblasti
kHFminRation = 1;% //--kolikrt mus bt MF sloka u ECG vt ne HF sloka, aby byl peak pijat jako potenciln znaka


rMin = 0.03; %//--nejmen vka peaku, detekovanho na ECG oblce v rozdlu R=MF-LF


dataR = max(dataMF-dataHF,0);




[peaks,locs] = findpeaks(dataR);



% vyberu jen ty sprvn peaky
lastAcceptedPos = -minPeakDistance;

acceptedX = [];
acceptedY = [];

acceptedNum=1;

statPerc95 = prctile(dataR.*1,85);

for i=1:size(locs,1)
    
    accept = true;
    
    testedPos = locs(i); %index prv testovan pozice
    
    
    
    if (testedPos<3) || (testedPos>length(signal)-3)  %ignoruji peaky, kter by byly pmo na kraji. To smrd.
        continue
    end
    
    
    
    statRawStart = max(locs(i)-floor(statRawSamples/2),1);
    statRawEnd = min (locs(i)+floor(statRawSamples/2),size(signal,1));
    
    statRawLongStart = max(locs(i)- floor(statRawLongSamples/2),1);
    statRawLongEnd = min (locs(i)+ floor(statRawLongSamples/2),size(signal,1));
    
    statRawBlockShort = dataR(statRawStart:statRawEnd);
    statRawBlockLong = dataR(statRawLongStart:statRawLongEnd);
    
    shortBlockVR =  max(statRawBlockShort)-min(statRawBlockShort);
    longBlockVR = max(statRawBlockLong)-min(statRawBlockLong);
    
    accept = accept && (testedPos>lastAcceptedPos+minPeakDistance); %oeten proti pli blkm peakm
    accept = accept && (dataR(testedPos)>= kHFminRation * dataHF(testedPos)); %oeten proti rychlm kmitm
    accept = accept && (dataR(testedPos)>=rMin); %oeten proti pli slabm peakm
    accept =accept && (dataR(testedPos) > statPerc95); %kontrola na velikost v rmci statistiky vyetovanch 10 sekund
    
    accept = accept && (shortBlockVR>longBlockVR*statRawKVR);
    
    accept = accept && (max(statRawBlockShort) == max (statRawBlockLong));
    
    %kontrola, e to nesoused s nevalidn oblast
    accept = accept && (dataR(testedPos+2)>0) && (dataR(testedPos-2)>0);
    
    if (accept)
        
        acceptedX(acceptedNum) = testedPos;
        acceptedY(acceptedNum) = peaks(i);
        
        chanResult.group(acceptedNum) = dataLF(testedPos)>dataR(testedPos);
        
        lastAcceptedPos = testedPos;
        
        acceptedNum = acceptedNum+1;
    end
end




chanResult.qrs = acceptedX;
chanResult.rr = diff(chanResult.qrs)/200;



% nalezen nejdelho LF bloku
lfStart=1;
lfEnd=1;
maxLFlength=0;
maxLFstart=0;
maxLFend = 0;

for i=1:length(dataLF)
    if ((dataLF(i)<dataR(i)))
        
        lfEnd = i;
        
        lfLength = lfEnd-lfStart;
        
        if (lfLength>maxLFlength)
            maxLFstart = lfStart;
            maxLFend = lfEnd;
            maxLFlength = lfLength;
        end
        
        lfStart=i;
        continue
    end
    lfEnd = i;
end

if ((dataLF(end)>dataR(end)) || (lfEnd>0))
    lfLength = lfEnd-lfStart;
    if (lfLength>maxLFlength)
        maxLFstart = lfStart;
        maxLFend = lfEnd;
        maxLFlength = lfLength;
    end
end

maxLFlength = maxLFlength/200;
qz=chanResult.qrs(:);
% size(chanResult.qrs(:))
% size(chanResult.rr(:))
otherFeatures=[min(chanResult.rr(:)),median(chanResult.rr(:)),max(chanResult.rr(:)),std(chanResult.rr(:)),moment(chanResult.rr(:),3),maxLFlength];
otherFeatures(find(isnan(otherFeatures)))=0;
if length(otherFeatures)<6
    otherFeatures=zeros(1,6);
end
df=diff(qz);
otherFeatures2=[min(df),median(df),max(df),std(df),moment(df,3),moment(df,7)];
otherFeatures2(find(isnan(otherFeatures2)))=0;
if length(otherFeatures2)<6
    otherFeatures2=zeros(1,6);
end
otherFeatures=[otherFeatures,otherFeatures2];