function [features]=findMortezaFeatures(yp)

x=yp';
level = 5;
[c,l] = wavedec(x,level,'db4');

a5 = appcoef(c,l,'db4');
det5 = detcoef(c,l,level);
det4 = detcoef(c,l,level-1);
det3 = detcoef(c,l,level-2);
%--------------------------------------------------------------------------
f7 = log2(var(det3));                                       %7
%--------------------------------------------------------------------------
xx = downsample(x, 16);
[f14, ~, f15] = Spectral(xx);                               %13 14
%--------------------------------------------------------------------------
[lp] = lpc(double(x),10);
f161821232425 = lp([2 4 7 9 10 11]);                        %16 18 21 23 24 25
%--------------------------------------------------------------------------
N = length(x);
xdft = fft(x);
xdft = xdft(1:round(N/2)+1);
psdx = (1/(2*pi*N)) * abs(xdft).^2;
psdx(2:end-1) = 2*psdx(2:end-1);
Fs=500;
f = Fs*(0:(N/2))/N;
% save('local1','f','psdx')
frequency_centroid = (sum(f(:).*(psdx(1:length(f)).^2)))/(sum(psdx(1:length(f)).^2));   %26
%-------------------------------------------------------------
nbins = 50;
[counts,centers] = hist(x,nbins);
thr = mean((diff(centers))/2);
centers(2,:) = centers + thr;
for i=1:length(x)
    p1 = find(x(i)<=centers(2,:));
    if ~isempty(p1)
        p(i) = counts(p1(1));
    else
        p(i) = counts(end);
    end
end
p = p / length(x);
q = 2;
Shannon = -1*sum(p.*log(p));                                %29
Tsallis = (1/(q-1))*sum(1 - p.^q);                          %31
%-------------------------------------------------------------
clear p counts centers thr
[counts,centers] = hist(a5,nbins);
thr = mean((diff(centers))/2);
centers(2,:) = centers + thr;
for i=1:length(x)
    p1 = find(x(i)<=centers(2,:));
    if ~isempty(p1)
        p(i) = counts(p1(1));
    else
        p(i) = counts(end);
    end
end
p = p / length(x);
Shannon_a5 = -1*sum(p.*log(p));                             %32
%-------------------------------------------------------------
clear p counts centers thr
[counts,centers] = hist(det5,nbins);
thr = mean((diff(centers))/2);
centers(2,:) = centers + thr;
for i=1:length(x)
    p1 = find(x(i)<=centers(2,:));
    if ~isempty(p1)
        p(i) = counts(p1(1));
    else
        p(i) = counts(end);
    end
end
p = p / length(x);
q = 2;
Renyi_d5 = (1/(q-1))*log(sum(p.^q));                        %36
%-------------------------------------------------------------
clear p counts centers thr
[counts,centers] = hist(det4,nbins);
thr = mean((diff(centers))/2);
centers(2,:) = centers + thr;
for i=1:length(x)
    p1 = find(x(i)<=centers(2,:));
    if ~isempty(p1)
        p(i) = counts(p1(1));
    else
        p(i) = counts(end);
    end
end
p = p / length(x);
Shannon_d4 = -1*sum(p.*log(p));                             %38
% ------------------------------------------------------------------------
featuresMorteza = [f7 f14 f15 f161821232425 frequency_centroid,...
    Shannon Tsallis Shannon_a5 Renyi_d5 Shannon_d4];
% size(featuresMorteza)

% featuresMorteza=zeros(1,15);
% features=[features1,features2,features3,features4,features5,features6,features7,features8,features9,...
%     features10,features11,features12,features13,features14,features15,features16,features17,features18,...
%     features19,features20,features21,features22,features23,features24,features25,features26,...
%     features1a,features2a,features3a,features4a,features5a,features6a,features7a,featuresMed,featuresKurt,featuresSkew];
% size(features)
features=[featuresMorteza];
% features=[features1,features2,features3,features4,features5,features6,features7,features8,features9,features1a,features2a,features3a,features4a,features5a,features6a,features7a,features8,features9];
% features=[features1,features2,features3,features4,features5,features6,features7,features9,features1a,features2a,features3a,features4a,features5a,features6a,features7a];
