function [accuracy,f_measure,f_beta,g_beta] = compute_beta_score2(labels, outputs,beta,num_classes)
% Check inputs for errors.
if length(outputs) ~= length(labels)
    error('Numbers of outputs and labels must be the same.');
end

[num_recordings,num_classes_from_lab] = size(labels);

% Check inputs for errors.
if length(num_classes) ~= length(num_classes_from_lab)
    error('Numbers of classes and labels must be the same.');
end

% Populate contingency table.

fbeta_l = zeros(1,num_classes);
gbeta_l = zeros(1,num_classes);
fmeasure_l = zeros(1,num_classes);
accuracy_l = zeros(1,num_classes);

f_beta = 0;
g_beta = 0;
f_measure = 0;
accuracy = 0;

% Weigth function
C_l = ones(1,num_classes);

for j=1:num_classes
    tp = 0;
    fp = 0;
    fn = 0;
    tn = 0;
    
    for i = 1 : num_recordings
        
        num_labels = sum(labels(i,:));
        if num_labels<1
            
            num_labels=1;
        end
        if labels(i,j)==1 && outputs(i,j)==1
            tp = tp + 1/num_labels;
        elseif labels(i,j)~=1 && outputs(i,j)==1
            fp = fp + 1/num_labels;
        elseif labels(i,j)==1 && outputs(i,j)~=1
            fn = fn + 1/num_labels;
        elseif labels(i,j)~=1 && outputs(i,j)~=1
            tn = tn + 1/num_labels;
        end
    end
    
    % Summarize contingency table.
    if ((1+beta^2)*tp + (beta*fn) + fp) > 0
        fbeta_l(j) = ((1+beta^2)*tp) / ((1+beta^2)*tp + (beta^2*fn) + fp);
    else
        fbeta_l(j) = 1;
    end
    
    if (tp + (beta*fn) + fp) > 0
        gbeta_l(j) = tp / (tp + (beta*fn) + fp);
    else
        gbeta_l(j) = 1;
    end
    
    if (tp + fp + fn + tn) > 0
        accuracy_l(j) = (tp+tn) / (tp+fp+fn+tn);
    else
        accuracy_l(j) = 1;
    end
    
    if (2*tp + fp + tn) >0
        fmeasure_l(j) = (2*tp)/((2*tp)+fp+fn);
    else
        fmeasure_l(j) = 1;
    end
    
end

for i = 1:num_classes
    f_beta = f_beta + fbeta_l(i)*C_l(i);
    g_beta = g_beta + gbeta_l(i)*C_l(i);
    f_measure = f_measure + fmeasure_l(i)*C_l(i);
    accuracy = accuracy + accuracy_l(i)*C_l(i);
end

f_beta = f_beta/num_classes;
g_beta = g_beta/num_classes;
f_measure = f_measure/num_classes;
accuracy = accuracy/num_classes;

end

% The compute_auc function computes AUROC and AUPRC as well as other summary
% statistics (TP, FP, FN, TN, TPR, TNR, PPV, NPV, etc.) that can be exposed
% from this function.
%
% Inputs:
%   'labels' are the true classes of the recording
%
%   'output' are the output classes of your model
%
%   'beta' is the weight
%
%
% Outputs:
%   'auroc' is a scalar that gives the AUROC of the algorithm using its
%   output probabilities, where specificity is interpolated for intermediate
%   sensitivity values.
%
%   'auprc' is a scalar that gives the AUPRC of the algorithm using its
%   output probabilities, where precision is a piecewise constant function of
%   recall.
%

function [auroc, auprc] = compute_auc(labels,probabilities,num_classes)

% Check inputs for errors.
if length(probabilities) ~= length(labels)
    error('Numbers of probabilities and labels must be the same.');
end

probabilities(isnan(probabilities))=0;


auroc_l = zeros(1,num_classes);
auprc_l = zeros(1,num_classes);

auroc = 0;
auprc = 0;

% Weigth function
C_l = ones(1,num_classes);

[num_recordings,num_classes_from_lab] = size(labels);

for k = 1:num_classes
    % Find probabilities thresholds.
    thresholds = flipud(unique(probabilities(:,k)));
    
    if thresholds(1) ~= 1
        thresholds = [1; thresholds];
    end
    
    if thresholds(end) ~= 0
        thresholds = [thresholds; 0];
    end
    
    m = length(thresholds);
    
    % Populate contingency table across probabilities thresholds.
    tp = zeros(1, m);
    fp = zeros(1, m);
    fn = zeros(1, m);
    tn = zeros(1, m);
    
    % Find indices that sort predicted probabilities from largest to smallest.
    [~, idx] = sort(probabilities(:,k), 'descend');
    
    
    i = 1;
    for j = 1 : m
        % Initialize contingency table for j-th probabilities threshold.
        if j == 1
            tp(j) = 0;
            fp(j) = 0;
            fn(j) = sum(labels(:,k));
            tn(j) = num_recordings - fn(j);
        else
            tp(j) = tp(j - 1);
            fp(j) = fp(j - 1);
            fn(j) = fn(j - 1);
            tn(j) = tn(j - 1);
        end
        
        % Update contingency table for i-th largest probabilities probability.
        while i <= num_recordings && probabilities(idx(i),k) >= thresholds(j)
            if labels(idx(i),k) == 1
                tp(j) = tp(j) + 1;
                fn(j) = fn(j) - 1;
            else
                fp(j) = fp(j) + 1;
                tn(j) = tn(j) - 1;
            end
            i = i + 1;
        end
    end
    
    
    
    % Summarize contingency table.
    tpr = zeros(1, m);
    tnr = zeros(1, m);
    ppv = zeros(1, m);
    npv = zeros(1, m);
    
    for j = 1 : m
        if tp(j) + fn(j) > 0
            tpr(j) = tp(j) / (tp(j) + fn(j));
        else
            tpr(j) = 1;
        end
        
        if fp(j) + tn(j) > 0
            tnr(j) = tn(j) / (fp(j) + tn(j));
        else
            tnr(j) = 1;
        end
        
        if tp(j) + fp(j) > 0
            ppv(j) = tp(j) / (tp(j) + fp(j));
        else
            ppv(j) = 1;
        end
        
        if fn(j) + tn(j) > 0
            npv(j) = tn(j) / (fn(j) + tn(j));
        else
            npv(j) = 1;
        end
    end
    
    % Compute AUROC as the area under a piecewise linear function of TPR /
    % sensitivity (x-axis) and TNR / specificity (y-axis) and AUPRC as the area
    % under a piecewise constant of TPR / recall (x-axis) and PPV / precision
    % (y-axis).
    
    for j = 1 : m - 1
        auroc_l(k) = auroc_l(k) + 0.5 * (tpr(j + 1) - tpr(j)) * (tnr(j + 1) + tnr(j));
        auprc_l(k) = auprc_l(k) + (tpr(j + 1) - tpr(j)) * ppv(j + 1);
    end
end


for i =1:num_classes
    auroc = auroc + auroc_l(i)*C_l(i);
    auprc = auprc + auprc_l(i)*C_l(i);
end

auroc = auroc/num_classes;
auprc = auprc/num_classes;
end

% function to obtain the true labels

function [recording_label,classes_label,single_recording_labels]=get_true_labels(input_file,classes)

classes_label=classes;
single_recording_labels=zeros(1,length(classes));

fid=fopen(input_file);
tline = fgetl(fid);
tmp_str = strsplit(tline,' ');
recording_label = tmp_str{1};

tlines = cell(0,1);
while ischar(tline)
    tlines{end+1,1} = tline;
    tline = fgetl(fid);
    if startsWith(tline,'#Dx')
        tmp = strsplit(tline,': ');
        tmp_c = strsplit(tmp{2},',');
        for j=1:length(tmp_c)
            idx2 = find(strcmp(classes,tmp_c{j}));
            single_recording_labels(idx2)=1;
        end
        break
    end
end
fclose(fid);

end


% find unique number of classes
function classes = get_classes(input_directory,files)

classes={};
num_files = length(files);
k=1;
for i = 1:num_files
    input_file = fullfile(input_directory, files{i});
    fid=fopen(input_file);
    tline = fgetl(fid);
    tlines = cell(0,1);
    while ischar(tline)
        tlines{end+1,1} = tline;
        tline = fgetl(fid);
        if startsWith(tline,'#Dx')
            tmp = strsplit(tline,': ');
            tmp_c = strsplit(tmp{2},',');
            for j=1:length(tmp_c)
                idx2 = find(strcmp(classes,tmp_c{j}));
                if isempty(idx2)
                    classes{k}=tmp_c{j};
                    k=k+1;
                end
            end
            break
        end
    end
    fclose(fid);
end
classes=sort(classes);
end

