function classifyResult = challengeNew(recordName)
%
% Sample entry for the 2017 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     N = normal rhythm
%                     A = AF
%                     O = other rhythm
%                     ~ = noisy recording (poor signal quality)
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2017/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
%
% Version 1.0
%
%
% Written by: Chengyu Liu and Qiao Li January 20 2017
%             chengyu.liu@emory.edu  qiao.li@emory.edu
%
% Last modified by:
%
%

% recordName
%% AF determination
[~,ecg,fs,~]=rdmat(recordName);

[classifyResult,QRS,ecg,AFEv,RR,QRSamp,QRSa,ATEv,OrgIdx,OriginCount,IrrEv,PACEv] = challengeECG(ecg);
[classifyResult1,QRS1,ecg1,AFEv1,RR1,QRSamp1,QRSa1,ATEv1,OrgIdx1,OriginCount1,IrrEv1,PACEv1] = challengeECG(ecg(1:round(end/3)));
[classifyResult2,QRS2,ecg2,AFEv2,RR2,QRSamp2,QRSa2,ATEv2,OrgIdx2,OriginCount2,IrrEv2,PACEv2] = challengeECG(ecg(round(end/3):round(2*end/3)));
[classifyResult3,QRS3,ecg3,AFEv3,RR3,QRSamp3,QRSa3,ATEv3,OrgIdx3,OriginCount3,IrrEv3,PACEv3] = challengeECG(ecg(round(2*end/3):end));
[classifyResult4,QRS4,ecg4,AFEv4,RR4,QRSamp4,QRSa4,ATEv4,OrgIdx4,OriginCount4,IrrEv4,PACEv4] = challengeECG(ecg(round(1*end/2):end));
[classifyResult5,QRS5,ecg5,AFEv5,RR5,QRSamp5,QRSa5,ATEv5,OrgIdx5,OriginCount5,IrrEv5,PACEv5] = challengeECG(ecg(1:round(end/2)));
classifyResults=classifyResult;
maxLengthEcg=18286;
lle=length(ecg);
nor=ceil(maxLengthEcg/lle);
cecg = repmat(ecg,[nor 1]);
ecgTrain=cecg(1:maxLengthEcg);
cqrts=length(QRS);
averageDiff=200;
if (cqrts)>2
    diff1=abs(diff(QRS));
    averageDiff=median(diff1);
end
if averageDiff>400
    averageDiff=200;
end
if isnan(averageDiff)
    averageDiff=200;
end
[peakLoc1, peakMag1] = peakfinder(ecgTrain);
val3=std(peakMag1);
llp=median(diff(peakLoc1));
val4=std(diff(peakLoc1));
wdt = pulsewidth(ecgTrain);
if isnan(val3)==1
    val3=0;llp=0;val4=0;
end
[QRS,diffo]=findBestQRS1(ecg,QRS,QRS1,QRS2,QRS3,QRS4,QRS5);
%     [zzsMean,zzs]=calculateNoisyRatio(ecg,QRS);

%     [averageDiff,features1]=findBasicFeatures(ecgTrainVec(i,:),QRS);
%     [featuresTrain(i,:)]=findBasicFeatures(ecgTrainVec(i,:));
%     [averageDiffTrain(i),featuresTrain(i,1:72)]=findECGpeaksNewFeaturesPlay(ecgTrainVec(i,:),averageDiff);
%     max(QRS)
%     size(ecgTrainVec(i,:))
featuresQ=findQRSRelatedFeatures(ecgTrain,QRS,QRS1,QRS2,QRS3,QRS4,QRS5);
%     [averageDiffTrain(i),zzz]=findECGpeaksNewFeaturesPlayQRSWenADenoising(ecgTrainVec(i,:),QRS,zzs);
[averageDiff,zzz]=findECGpeaksNewFeaturesPlayQRSWenA(ecgTrain,QRS);

featuresA=zzz;
cres=classifyResult3+classifyResult2+classifyResult1+classifyResult4+classifyResults+classifyResult5;
%     cmax=max([abs(OriginCount1-OriginCount2),abs(OriginCount3-OriginCount1),abs(OriginCount3-OriginCount2)]);
featuresB=[averageDiff,AFEv,AFEv1,AFEv2,...
    AFEv3,AFEv4,AFEv5,ATEv,ATEv1,...
    ATEv2,ATEv3,ATEv4,ATEv5,IrrEv,...
    IrrEv1,IrrEv2,IrrEv3,IrrEv4,IrrEv5,...
    PACEv,PACEv1,PACEv2,PACEv3,PACEv4,PACEv5,...
    OriginCount,OriginCount1,OriginCount2,OriginCount3,...
    OriginCount4,OriginCount5,classifyResults,classifyResult1,...
    classifyResult2,classifyResult3,classifyResult4,classifyResult5,...
    cres,OrgIdx,OrgIdx1,OrgIdx2,OrgIdx3,OrgIdx4,OrgIdx5];
featuresMed=[median([AFEv,AFEv1,AFEv2,AFEv3,AFEv4]),...
    median([IrrEv,IrrEv1,IrrEv2,IrrEv3,IrrEv4,IrrEv5]),...
    median([ATEv,ATEv1,ATEv2,ATEv3,ATEv4,ATEv5]),...
    median([OrgIdx,OrgIdx1,OrgIdx2,OrgIdx3,OrgIdx4,OrgIdx5]),...
    median([PACEv,PACEv1,PACEv2,PACEv3,PACEv4,PACEv5])];

% featuresB=[featuresB,featuresMed,llp,val3,val4,mean(wdt),std(wdt),featuresQ,0];
featuresB=[featuresB,featuresMed,llp,val3,val4,featuresQ,0];
features=[featuresA,featuresB];
save('testA1')
ssss
load EnsembleAA;
[labelsS,~]=EnsembleA.predict(features);
% classifyResult='N';
switch labelsS
    case 1
        classifyResult='N';
    case 2
        classifyResult='A';
    case 3
        classifyResult='O';
    case 4
        classifyResult='~';
end

