function features=calculateFeaturesPbad(QRS,badIndices)
Fs=500;
RRs=diff(QRS)/Fs;
resultb = bradyIsRegularActivity(RRs);
resulta = asystIsRegularActivity(RRs);
resultf1 = fibIsRegularActivity1(RRs);
resultf2 = fibIsRegularActivity2(RRs);
resultf3 = fibIsRegularActivity3(RRs);
resultt = tachyIsTachyActivity(RRs);
resultv1 = ventIsRegularActivity1(RRs);
resultv2 = ventIsRegularActivity2(RRs);
resultv3 = ventIsRegularActivity3(RRs);
% features=[resultb,resulta,resultf1,resultf2,resultf3,resultt,resultv1,resultv2,resultv3];


resultb1 = bradyIsRegularActivity1(RRs,badIndices);
resulta1 = asystIsRegularActivity1(RRs,badIndices);
resultf11 = fibIsRegularActivity11(RRs,badIndices);
resultf21 = fibIsRegularActivity21(RRs,badIndices);
resultf31 = fibIsRegularActivity31(RRs,badIndices);
resultt1 = tachyIsTachyActivity1(RRs,badIndices);
resultv11 = ventIsRegularActivity11(RRs,badIndices);
resultv21 = ventIsRegularActivity21(RRs,badIndices);
resultv31 = ventIsRegularActivity31(RRs,badIndices);

features=[resultb,resulta,resultf1,resultf2,resultf3,resultt,resultv1,resultv2,resultv3,resultb1,resulta1,resultf11,resultf21,resultf31,resultt1,resultv11,resultv21,resultv31];


features=[features,mean(features),std(features)];
bpm = getBPMs(RRs,badIndices);
bpmO = getBPM(RRs);

len=length(RRs);
bpms=zeros(1,len-2);
stdev = std(RRs);

for k=1:len-2
    bpms(k)=getBPM(RRs(k:k+2));
end

bpmsMax=zeros(1,len-2);
% stdev = std(RRs);
if isempty(bpmsMax)==1
    bpmsMax=[1,2];
end
for k=1:len-2
    bpmsMax(k)=getBPMMax(RRs(k:k+2));
end

bpmsMin=zeros(1,len-2);
% stdev = std(RRs);

for k=1:len-2
    bpmsMin(k)=getBPMMin(RRs(k:k+2));
end
if isempty(bpmsMin)==1
    bpmsMin=[1,2];
end
if isempty(bpms)==1
    bpms=[1,2];
end
sbpms=sort(bpms);
% sbpms
% sbpms
minBPM=sbpms(min(2,length(sbpms)));
maxBPM=sbpms(max(end-1,1));
diffBPM=diff(bpms);
if isempty(diffBPM)==1
    diffBPM=0;
end
stdRRs=[0,zeros(1,len-3)];
for k=1:len-2
    stdRRs(k)=std(RRs(k:k+2));
end
otherFeatures=[sum(RRs),median(bpmsMin),min(bpmsMin),max(bpmsMin),std(bpmsMin),std(bpmsMax),median(bpmsMax),min(bpmsMax),max(bpmsMax),bpm,bpmO,median(bpms),std(bpms),moment(bpms,3),moment(bpms,4),stdev,mean(RRs),median(stdRRs),min(bpms),max(bpms),min(diffBPM),max(diffBPM),std(stdRRs),min(stdRRs),max(stdRRs),minBPM,maxBPM,std(diffBPM),mean(diffBPM)];
features=[features,otherFeatures,otherFeatures.^2,otherFeatures.^3];
% features=[features];
end

function result = bradyIsRegularActivity(RRs)

result = 0;

rrc = length(RRs);

% if (rrc>8) %7 pro 2500

bpm = getBPM(RRs);

stdev = std(RRs);


timeSum = sum(RRs);


bpmLowLimit = 45; %nejmen BPM, kter je povaovan za normln

sumLimit=12; % kolik asu mus bt pokryto QRS znakami

stdevLimit = 0.1; %kolik me bt maximln stdev


result = (bpm>bpmLowLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

% end
end



function result = asystIsRegularActivity(RRs)

result = 0;

rrc = length(RRs);

% if (rrc>5) %4 pro 2500

bpm = getBPM(RRs);

stdev = std(RRs);

minRRs = 11; %10 pro 2500
minMed = 0.6;

med = median(RRs);

timeSum = sum(RRs);


bpmLowLimit = 45; %nejmen BPM, kter je povaovan za normln
bpmHighLimit = 250; %nejvy BPM, povaovan za normln. Tady je extremne vysoke, ale uleh to ivot

sumLimit=11.5; % kolik asu mus bt pokryto QRS znakami

maxlimit = 3; %nejvt povolen dra = RR

stdevLimit = 0.2; %kolik me bt maximln stdev


result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && ((stdev<stdevLimit)|| (med>minMed && rrc>minRRs))  && max(RRs)<maxlimit;

% end
end



function result = fibIsRegularActivity1(RRs)

result = 0;

% if (length(RRs)>2)

bpm = getBPM(RRs);

stdev = std(RRs);

timeSum = sum(RRs);


bpmLowLimit = 45; %nejmen BPM, kter je povaovan za normln
bpmHighLimit = 250; %nejvy BPM, povaovan za normln. Tady je extremne vysoke, ale uleh to ivot

sumLimit=11; % kolik asu mus bt pokryto QRS znakami

stdevLimit = 0.15; %kolik me bt maximln stdev


result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

% end
end


function result = tachyIsTachyActivity(RRs)

result = 0;

rrc = length(RRs);

% if (rrc>21)

bpm = getBPM(RRs);

stdev = std(RRs);


timeSum = sum(RRs);


bpmLowLimit = 135; %nejmen BPM, kter je povaovan za tachy

sumLimit=13; % kolik asu mus bt pokryto QRS znakami

stdevLimit = 0.2; %kolik me bt maximln stdev


result = (bpm>bpmLowLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

% end
end


function result = fibIsRegularActivity2(RRs)

result = 0;

% if (length(RRs)>2)

bpm = getBPM(RRs);

stdev = std(RRs);

timeSum = sum(RRs);


bpmLowLimit = 45; %nejmen BPM, kter je povaovan za normln
bpmHighLimit = 250; %nejvy BPM, povaovan za normln. Tady je extremne vysoke, ale uleh to ivot

sumLimit=11;

stdevLimit = 0.15;


result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

% end
end



function result = fibIsRegularActivity3(RRs)

result = 0;

% if (length(RRs)>2)

bpm = getBPM(RRs);

stdev = std(RRs);

timeSum = sum(RRs);


bpmLowLimit = 45;
bpmHighLimit = 250;     sumLimit=11;

stdevLimit = 0.15;


result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

% end
end



function result = ventIsRegularActivity1(RRs)

result = 0;

% if (length(RRs)>2)

bpm = getBPM(RRs);

stdev = std(RRs);

timeSum = sum(RRs);


bpmLowLimit = 35;
bpmHighLimit = 95;

sumLimit=7;

stdevLimit = 0.1;



result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

if timeSum>8 && length(RRs)>9 && stdev<0.01
    result = 1;
end

% end
end

function result = ventIsRegularActivity2(RRs)

result = 0;

% if (length(RRs)>5)

bpm = getBPM(RRs);

stdev = std(RRs);

timeSum = sum(RRs);


bpmLowLimit = 35;
bpmHighLimit = 120;

sumLimit=11;

stdevLimit = 0.1;



result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

if timeSum>11 && length(RRs)>12 && stdev<0.01 %8 / 9
    result = 1;
end

% end
end

function result = ventIsRegularActivity3(RRs)

result = 0;

% if (length(RRs)>2)

bpm = getBPM(RRs);

stdev = std(RRs);

timeSum = sum(RRs);


bpmLowLimit = 35;
bpmHighLimit = 95;

sumLimit=11;

stdevLimit = 0.1;



result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

if timeSum>12 && length(RRs)>10 && stdev<0.03
    result = 1;
end
% end
end



function result = bradyIsRegularActivity1(RRs,badIndices)

result = 0;

rrc = length(RRs);

% if (rrc>8) %7 pro 2500

bpm = getBPMs(RRs,badIndices);
stdev = std(RRs);


timeSum = sum(RRs);


bpmLowLimit = 45; %nejmen BPM, kter je povaovan za normln

sumLimit=12; % kolik asu mus bt pokryto QRS znakami

stdevLimit = 0.1; %kolik me bt maximln stdev


result = (bpm>bpmLowLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

% end
end



function result = asystIsRegularActivity1(RRs,badIndices)

result = 0;

rrc = length(RRs);

% if (rrc>5) %4 pro 2500

bpm = getBPMs(RRs,badIndices);

stdev = std(RRs);

minRRs = 11; %10 pro 2500
minMed = 0.6;

med = median(RRs);

timeSum = sum(RRs);


bpmLowLimit = 45; %nejmen BPM, kter je povaovan za normln
bpmHighLimit = 250; %nejvy BPM, povaovan za normln. Tady je extremne vysoke, ale uleh to ivot

sumLimit=11.5; % kolik asu mus bt pokryto QRS znakami

maxlimit = 3; %nejvt povolen dra = RR

stdevLimit = 0.2; %kolik me bt maximln stdev


result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && ((stdev<stdevLimit)|| (med>minMed && rrc>minRRs))  && max(RRs)<maxlimit;

% end
end



function result = fibIsRegularActivity11(RRs,badIndices)

result = 0;

% if (length(RRs)>2)

bpm = getBPMs(RRs,badIndices);

stdev = std(RRs);

timeSum = sum(RRs);


bpmLowLimit = 45; %nejmen BPM, kter je povaovan za normln
bpmHighLimit = 250; %nejvy BPM, povaovan za normln. Tady je extremne vysoke, ale uleh to ivot

sumLimit=11; % kolik asu mus bt pokryto QRS znakami

stdevLimit = 0.15; %kolik me bt maximln stdev


result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

% end
end


function result = tachyIsTachyActivity1(RRs,badIndices)

result = 0;

rrc = length(RRs);

% if (rrc>21)

bpm = getBPMs(RRs,badIndices);

stdev = std(RRs);


timeSum = sum(RRs);


bpmLowLimit = 135; %nejmen BPM, kter je povaovan za tachy

sumLimit=13; % kolik asu mus bt pokryto QRS znakami

stdevLimit = 0.2; %kolik me bt maximln stdev


result = (bpm>bpmLowLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

% end
end


function result = fibIsRegularActivity21(RRs,badIndices)

result = 0;

% if (length(RRs)>2)

bpm = getBPMs(RRs,badIndices);

stdev = std(RRs);

timeSum = sum(RRs);


bpmLowLimit = 45; %nejmen BPM, kter je povaovan za normln
bpmHighLimit = 250; %nejvy BPM, povaovan za normln. Tady je extremne vysoke, ale uleh to ivot

sumLimit=11;

stdevLimit = 0.15;


result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

% end
end



function result = fibIsRegularActivity31(RRs,badIndices)

result = 0;

% if (length(RRs)>2)

bpm = getBPMs(RRs,badIndices);

stdev = std(RRs);

timeSum = sum(RRs);


bpmLowLimit = 45;
bpmHighLimit = 250;     sumLimit=11;

stdevLimit = 0.15;


result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

% end
end



function result = ventIsRegularActivity11(RRs,badIndices)

result = 0;

% if (length(RRs)>2)

bpm = getBPMs(RRs,badIndices);

stdev = std(RRs);

timeSum = sum(RRs);


bpmLowLimit = 35;
bpmHighLimit = 95;

sumLimit=7;

stdevLimit = 0.1;



result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

if timeSum>8 && length(RRs)>9 && stdev<0.01
    result = 1;
end

% end
end

function result = ventIsRegularActivity21(RRs,badIndices)

result = 0;

% if (length(RRs)>5)

bpm = getBPMs(RRs,badIndices);

stdev = std(RRs);

timeSum = sum(RRs);


bpmLowLimit = 35;
bpmHighLimit = 120;

sumLimit=11;

stdevLimit = 0.1;



result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

if timeSum>11 && length(RRs)>12 && stdev<0.01 %8 / 9
    result = 1;
end

% end
end

function result = ventIsRegularActivity31(RRs,badIndices)

result = 0;

% if (length(RRs)>2)

bpm = getBPMs(RRs,badIndices);

stdev = std(RRs);

timeSum = sum(RRs);


bpmLowLimit = 35;
bpmHighLimit = 95;

sumLimit=11;

stdevLimit = 0.1;



result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && (stdev<stdevLimit);

if timeSum>12 && length(RRs)>10 && stdev<0.03
    result = 1;
end
% end
end



function resultBPM = getBPMs( RRs,badIndices )
resultBPM = 0;
if (length(RRs)>1)
    resultBPM =60/ mean(RRs(badIndices==0));
end
end

function resultBPM = getBPM( RRs)
resultBPM = 0;
if (length(RRs)>1)
    resultBPM =60/ mean(RRs);
end
end


function resultBPM = getBPMMax( RRs)
resultBPM = 0;
if (length(RRs)>1)
    resultBPM =60/ min(RRs);
end
end

function resultBPM = getBPMMin( RRs)
resultBPM = 0;
if (length(RRs)>1)
    resultBPM =60/ max(RRs);
end
end