function [y,meanv,stdv]=calculateDiffECG(cardiac)
smin = 1e-2;
c =  find ( abs(cardiac) > smin);
l = length(c) + 1;
c2=[0;c];c(l)= 0;
tau = c - c2;
l2 = l - 1 ;
tau = tau(2:l2);
if isempty(tau)
    smin = 1e-4;
    c =  find ( abs(cardiac) > smin);
    l = length(c) + 1;
    c2=[0;c];c(l)= 0;
    tau = c - c2;
    l2 = l - 1 ;
    tau = tau(2:l2);
end
r = l2/length(cardiac);
if tau*r>0
    h= histcounts(tau*r,ceil(max(tau)));;
else
    h=0.0001;
end
y = log(h/r);
y(y==Inf | y==-Inf)=[];meanv=mean(y);stdv=std(y);
if length(y)>=20
    y=y(1:20);
else
    y=[y,zeros(1,20-length(y))];
end