function [trainX,trainY,sources]=balanceSource(trainX,trainY,sources)

[usource,~,ic]=unique(sources);
s_counts = accumarray(ic,1);
repCounts=(max(s_counts)./s_counts);
repCounts1=floor(exp(floor(log(repCounts))))-1;
Xadded=[];
Yadded=[];
Sadded=[];
for i=1:length(usource)
    if repCounts1(i)>0
        ffsource=find(sources==usource(i));
        Xadded=[Xadded;repmat(trainX(ffsource,:),[repCounts1(i) 1])];
        Yadded=[Yadded;repmat(trainY(ffsource,:),[repCounts1(i) 1])];
        Sadded=[Sadded;repmat(sources(ffsource,:),[repCounts1(i) 1])];
    end
end
trainX=[trainX;Xadded];
trainY=[trainY;Yadded];
sources=[sources;Sadded];
