function [trainX,trainY,sources]=balanceClassSource(trainX,trainY,sources)
%if repOn==1
repratio=length(find(trainY==1))/length(find(trainY==0));
repCount=floor(1/repratio)-1;
%repCount
ff1=find(trainY==1);
if isempty(ff1)==0
trainX=[trainX;repmat(trainX(ff1,:),[repCount 1])];
trainY=[trainY;repmat(trainY(ff1,:),[repCount 1])];
sources=[sources;repmat(sources(ff1,:),[repCount 1])];
end
[usource,~,ic]=unique(sources);
s_counts = accumarray(ic,1);
repCounts=(max(s_counts)./s_counts);
repCounts1=floor(exp(floor(log(repCounts))))-1;
Xadded=[];
Yadded=[];
Sadded=[];
for i=1:length(usource)
    if repCounts1(i)>0
        ffsource=find(sources==usource(i));
        Xadded=[Xadded;repmat(trainX(ffsource,:),[repCounts1(i) 1])];
        Yadded=[Yadded;repmat(trainY(ffsource,:),[repCounts1(i) 1])];
        Sadded=[Sadded;repmat(sources(ffsource,:),[repCounts1(i) 1])];
    end
end
trainX=[trainX;Xadded];
trainY=[trainY;Yadded];
sources=[sources;Sadded];
