#Copyright 2020, TATA Consultancy Services. All rights reserved


# -*- coding: utf-8 -*-


import numpy as np, os, sys
import joblib
from get_12ECG_features import get_12ECG_features
from scipy.signal import resample , resample_poly 
from scipy.interpolate import interp1d
from keras.models import load_model
from our_classifier import nn_model_3

def run_12ECG_classifier(data,header_data,loaded_model):


    # Use your classifier here to obtain a label and score for each class.
    model = loaded_model['model']
    #imputer = loaded_model['imputer']
    classes = loaded_model['classes']

 #   features=np.asarray(get_12ECG_features(data,header_data))
#    feats_reshape = features.reshape(1, -1)
#    feats_reshape = imputer.transform(feats_reshape)
    # current_label = model.predict(feats_reshape)[0]
    # current_label=current_label.astype(int)
    # current_score = model.predict_proba(feats_reshape)
    # current_score=np.asarray(current_score)
    # current_score=current_score[:,0,1]

    num_classes = len(classes)

    # Use your classifier here to obtain a label and score for each class.
    
    #model = loaded_model['model']
    #imputer = loaded_model['imputer']
    
    processing_length = 5000
#    data_t = pad_sequences(data, maxlen=processing_length, dtype=np.float, padding='post', truncating='post')
    N = processing_length
    odata=np.transpose(data)
    data_t=resample(odata,N)

    predicted_values = model.predict(data_t[np.newaxis, :, :])
    current_score = predicted_values[0][:-1]
    #current_score = predicted_values[0]
    current_label = np.where(current_score >= 0.4, 1, 0)     


    return current_label, current_score,classes

def load_12ECG_model(input_directory):
    # load the model from disk 
    #f_out='finalized_model.sav'
    #filename = os.path.join(input_directory,f_out)

    #loaded_model = joblib.load(filename)
    model = nn_model_3((0, 5000, 12),  (0, 28))
    # dl_model_filename = os.path.join(input_directory, 'model_weights_1.h5')
    dl_model_filename = os.path.join(input_directory, 'model.h5')
    classes_filename = os.path.join(input_directory, 'classes.npy')
    # classes = np.load(classes_filename, allow_pickle=True)
    classes = np.load(classes_filename)
    model.load_weights(dl_model_filename)
    loaded_model = {}
    loaded_model['model'] = model
    loaded_model['classes'] = classes
    
    return loaded_model