% This function update the reference for validation set.
% (1) This function read the records in validation set.
% (2) This function extract the corresponding results in the most recently
%     reference file.
% (3) This function create a new file containing the data in target directory
%     named with 'REFERENCE-v2.csv'.
function ref_update()
%% Load the reference classification results
reffile = ['training2017' filesep 'REFERENCE-v2.csv'];
fid = fopen(reffile, 'r');
if(fid ~= -1)
    Ref = textscan(fid,'%s %s','Delimiter',',');
else
    error(['Could not open ' reffile ' for scoring. Exiting...'])
end
fclose(fid);
%%----Updated records and their labels---------------------------------------------
Records_updated = Ref{1};
Target  = Ref{2};
%-----Open the directory of validation data------------------------------------------
data_dir = [pwd filesep 'validation' filesep];
addpath(pwd)
fid = fopen([data_dir 'RECORDS'],'r');
if(fid ~= -1)
    RECLIST = textscan(fid,'%s');
else
    error(['Could not open ' data_dir 'RECORDS for scoring. Exiting...'])
end
fclose(fid);
RECORDS = RECLIST{1};
N = length(RECORDS);
%% Update the labels in validation set's reference as REFERENCE-v2.csv---------------------------
fid=fopen('REFERENCE-v2.csv','wt');
for i = 1:N
    lia = ismember(Records_updated,RECORDS{i}); 
    j = find(lia);
    fprintf(fid,'%s,%s\n',RECORDS{i},Target{j});
    fprintf(['---Processed ' num2str(i) ' out of ' num2str(N) ' records.\n'])
end
fclose(fid);
fprintf('Completed!');
return