function [p q] = pq_detect(ecg,QRS,sign)% p q are boolean value for detected characteristics.
ecg=ecg-mean(ecg);                  % a = 0 means no P wave and Q wave normal.
if sign<0                           % p = 1 means P detected, q = 1 means q wave abnormal.
    ecg = -ecg;
end
N = max(size(QRS));
p_area = zeros(N-2,2);%P
q_low = zeros(N-2,1);%Q̫
for i = 2:(N-1)
    s = QRS(i);    e = QRS(i+1);    l = QRS(i-1);
    p_start = min( (s-40) , floor((2*s+l)/3)+1  );
    [c d] = min(ecg((s-29):s));
    p_stop = s - 30 + d;
    big = sort(ecg(p_start:p_stop),'descend');
    base = abs(ecg(p_start) - ecg(p_stop))/2;%εĻ
    p_pos_value = mean(big(1:3))-base;%һPֵ
    cal = mean(ecg(p_start:p_stop)-base);%εƽ߶
    p_area(i-1,1) = p_pos_value;
    p_area(i-1,2) = cal;
    [e f] = min(ecg(s:(s+29))); %s
    q_start = s + f - 1;
    if ecg(q_start)>=0
        q_low(i-1) = 0;
    else
        q_low(i-1) = abs(ecg(q_start))/abs(ecg(s));
    end
end
%a = 0;
p=0;q=0;
   if  mean(p_area(:,2))/mean(p_area(:,1)) <= 0.67
       p = 1;%a = 1 ;
   else
       mean(q_low)>=0.30
       q = 1;%a = 1;
   end
 return
   
    
    
    


