%---Multi-lag Poincare Plot Based HRV Analysis--------------
%-----2015EMBC--2367~2370----16210720037@FUDAN.EDU.CN------
function [SD1 SD2 SDratio CCM] = mlpoinplot(RR,lag)
% RR is a column/row vector contains the inerbeat intervals for HRV
% analysis.
% lag is an interger up to which multi-lag analysis is performed. The
% default is 1.
%=======================================================================================
% SD1,SD2 and SDratio is the standard desctiptor of a Poincare Plot.
%=======================================================================================
% CCM(complex correlated measure) is to quantify the change in dynamics of
% the Poincare Plot. For more about this, please refer to :
% "Do existing measures of PP geometry reflect on nonlinear features of HRV?"
% IEEE Transactions on Biomedical Engineering. vol.48 No.11 pp1342-1347.2001
% "Complex Correlation Measure: a novel descriptor for PP" Biomedical
% Engineering Online, vol.8 Aug 13. 2009.
%=======================================================================================
% The SIGNIFICANCE TESTING is not included in this version.
if nargin < 2
    lag = 1;
end
N = length(RR);
%=============================
SD1 = zeros(lag,1);
SD2 = zeros(lag,1);
SDratio = zeros(lag,1);
CCM = zeros(lag,1);
%=============================
for i = 1:lag
  M = N - i; % M is the length of  reconstructed series given the lag.
  x = RR(1:M);
  y = RR((1+i):N);
  SD1(i) = ((norm(x - y))^2)/(2*M);
  SD1(i) = SD1(i)^0.5;
  SD2(i) = ( (  norm( x + y - (2*mean(x)+mean(y)) ) )^2)/(2*M);
  SD2(i) = SD2(i)^0.5;
  for j = 1:(M-2)
     a = [x(i),y(i),1;x(i+1),y(i+1),1;x(i+2),y(i+2),1];
     a = det(a)/2;
     CCM(i) = CCM(i) + abs(a);    
  end
  CCM(i) = CCM(i)/((M-2)*pi*SD1(i)*SD2(i)); % CCM always positive.ʵԿӳ䵽ĳռȥǻЩȱݡ
%   subplot((lag+1),1,i);
%   scatter(x,y);
%   xlabel('RRi/ms');
%   ylabel(['RRi+' num2str(i) '/ms']);
%   hold on  
  % IQR and median can be added for further significance test. 
  % ANOVA? Wilcoxon-Rank Sum Tes?
end

SDratio = SD1./SD2;
%==========================================================================





