function fs = feature_single(recordName)
fs = zeros(1,15);
[tm,ecg,fs,siginfo]=rdmat(recordName);
[QRS,sign,en_thres] = qrs_detect2(ecg',0.25,0.6,fs);%
    %---------------------------------------------------------------------------------
    HR = 18000*length(QRS)/length(ecg);  % Heart Rate.
    if length(QRS)<6
       RR = 0; AFEv = 0; % The function comp_dRR requires input RRI sequence with length no less than6.
    else
    RR=diff(QRS')/fs; % RR intervals sequence.
    AFEv = comput_AFEv(RR); % AFEv
    end
    Length_data = length(ecg); % Length of ECG data.
    Mean = mean(ecg);   % Mean value of ECG data.
    Energy = norm(ecg,2);  % Energy of ECG data.
    Total_mean_power = Energy/((Length_data)^0.5);  % Total mean power of ECG data.
    Length_RR = length(RR);  % Number of Beat-to-beat intervals.
    RR_mean = mean(RR);    % Mean value of RR intervals
    RR_std = std(RR);      % Standard deviation of RR intervals.
    [p q] = pq_detect(ecg,QRS,sign);
    [SD1 SD2 SDratio CCM] = mlpoinplot(RR);
    %--------------------------------------------------------------------------------------
    % write the answer to answers.txt file% fprintf(fid,'%s,%s\n',RECORDS{i},classifyResult(i));
    fs(1) = AFEv;
    fs(2) = HR;
    fs(3) = Length_data;
    fs(4) = Mean;
    fs(5) = Energy;
    fs(6) = Total_mean_power;
    fs(7) = Length_RR;
    fs(8) = RR_mean;
    fs(9) = RR_std;
    fs(10) = p;
    fs(11) = q;
    fs(12) = SD1;
    fs(13) = SD2;
    fs(14) = SDratio;
    fs(15) = CCM;
end
