% This funtion calculate specific feature of recordings in dataset.
% The result will be stored in .mat form for further processing like 
% visualization on its distribution.
% Zhenning Mei znmei16@fudan.edu.cn 2017-04-25
function [Result_for_Classify target]= feature_extraction()
%clear all;close all;clc
%reffile = ['validation' filesep 'REFERENCE.csv'];
reffile = ['training2017' filesep 'REFERENCE.csv'];
fid = fopen(reffile, 'r');
if(fid ~= -1)
    Ref = textscan(fid,'%s %s','Delimiter',',');
else
    error(['Could not open ' reffile ' for scoring. Exiting...'])
end
fclose(fid);
RECORDS = Ref{1};
target  = Ref{2};
N       = length(RECORDS);
%% ļͲο룬
%data_dir = [pwd filesep 'validation' filesep];
data_dir = [pwd filesep 'training2017' filesep];
%% Add this directory to the MATLAB path.
addpath(pwd)
%% Store the results
% Now there are 10 features and it can be extended by changing the following 2 lines.
FeatureResult = cell(N+1,17);
FeatureResult(1,:) = {'Recordname' 'Truth' 'AFEv' 'HR' 'Length data' 'Mean' 'Energy' 'Total mean power' 'Length RR' 'RR mean' 'RR std' ...
    'P detected' 'Q abnormal' 'SD1' 'SD2' 'SDratio' 'CCM'};
%----Following store the results.-----------------------------------------
for i = 2 : (N+1)
    FeatureResult{i,1} = RECORDS{i-1}; % Recordname.
    FeatureResult{i,2} = target{i-1}; % Label or Ground Truth.
    fname = RECORDS{i-1};
    fs = feature_single([data_dir fname]); % Added on 06/11 .
%     [tm,ecg,fs,siginfo]=rdmat([data_dir fname]);
%     [QRS,sign,en_thres] = qrs_detect2(ecg',0.25,0.6,fs);%
%     %---------------------------------------------------------------------------------
%     HR = 18000*length(QRS)/length(ecg);  % Heart Rate.
%     if length(QRS)<6
%        RR = 0; AFEv = 0; % The function comp_dRR requires input RRI sequence with length no less than6.
%     else
%     RR=diff(QRS')/fs; % RR intervals sequence.
%     AFEv = comput_AFEv(RR); % AFEv
%     end
%     Length_data = length(ecg); % Length of ECG data.
%     Mean = mean(ecg);   % Mean value of ECG data.
%     Energy = norm(ecg,2);  % Energy of ECG data.
%     Total_mean_power = Energy/((Length_data)^0.5);  % Total mean power of ECG data.
%     Length_RR = length(RR);  % Number of Beat-to-beat intervals.
%     RR_mean = mean(RR);    % Mean value of RR intervals
%     RR_std = std(RR);      % Standard deviation of RR intervals.
%     [p q] = pq_detect(ecg,QRS,sign);
    %--------------------------------------------------------------------------------------
    % write the answer to answers.txt file% fprintf(fid,'%s,%s\n',RECORDS{i},classifyResult(i));
    FeatureResult{i,3} = fs(1); %AFEv
    FeatureResult{i,4} = fs(2); %HR
    FeatureResult{i,5} = fs(3); %Length_data
    FeatureResult{i,6} = fs(4); %Mean
    FeatureResult{i,7} = fs(5); %Energy
    FeatureResult{i,8} = fs(6); %Total_mean_power
    FeatureResult{i,9} = fs(7); %Length_RR
    FeatureResult{i,10} = fs(8); %RR_mean 
    FeatureResult{i,11} = fs(9); %RR_std
    FeatureResult{i,12} = fs(10); %p_absence
    FeatureResult{i,13} = fs(11); %q_abnormal
    FeatureResult{i,14} = fs(12); %SD1
    FeatureResult{i,15} = fs(13); %SD2
    FeatureResult{i,16} = fs(14); %SDratio
    FeatureResult{i,17} = fs(15); %CCM
    fprintf(['---Processed ' num2str(i-1) ' out of ' num2str(length(RECORDS)) ' records.\n'])
end
%---Aggregate all the features.--------------------------------------------
Result_for_Classify = zeros(N,size(FeatureResult,2)-2);
for i = 2:(N+1)
    for j = 3 : size(FeatureResult,2)
        Result_for_Classify(i-1,j-2) = FeatureResult{i,j};
    end
end
end
%%------------------------------------------------------------------------------------------

