function classifyResult = challenge(recordName,t)
%
% Sample entry for the 2017 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     N = normal rhythm
%                     A = AF
%                     O = other rhythm
%                     ~ = noisy recording (poor signal quality)
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2017/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
%
% Version 1.0
%
%
% Written by: Chengyu Liu and Qiao Li January 20 2017
%             chengyu.liu@emory.edu  qiao.li@emory.edu
%
% Last modified by:
%
%
%ԭ
% classifyResult = 'N'; % default output normal rhythm
% 
% %% AF determination
% [tm,ecg,fs,siginfo]=rdmat(recordName);
% [QRS,sign,en_thres] = qrs_detect2(ecg',0.25,0.6,fs);%
% HR = 18000*length(QRS)/length(ecg);
% 
% %if st_detect(ecg,QRS,sign)>1
% %  classifyResult = 'O';
% %end
% if length(QRS)<6
% else
%     RR=diff(QRS')/fs;
%     AFEv = comput_AFEv(RR);
%     if AFEv>0.5
%         classifyResult = 'O';
%         if AFEv>1
%         classifyResult = 'A';
%         [p q a] = pq_detect(ecg,QRS,sign);
%             if p == 1
%             classifyResult = 'O';
%             end
%         end
%     else
%     %Normal   
%     if ((HR<60)||(HR>140))
%       classifyResult = 'O';
%     end
%     [p q a] = pq_detect(ecg,QRS,sign);
%     if ( (q == 1)  )  &&  ((HR<60)||(HR>130))
%        classifyResult = 'O';
%    % elseif (p==0)
%   %      classifyResult = 'A';
%     end
%     end
% end
% if (  (ecg'*ecg) / length(ecg)  )>=0.35
%             classifyResult = '~';
% end
% %% You can add the determination rules for other rhythm and noisy recordings here
%ԭ档0517Ĺġ
%global cnt;
%global deci_tree;
%if cnt==1
     load('tree061201.mat');
    % load('tree060501.mat');
     X = feature_single(recordName);
     %X(:,3) = [];
    % X(:,4) = [];
     %X(:,5) = [];
    classifyResult = trainedClassifier.predictFcn(X);
    if classifyResult == 10
        classifyResult = 'N';
    elseif classifyResult == 20
        classifyResult = 'A';
    elseif classifyResult == 30
        classifyResult = 'O';
    elseif classifyResult == 0
        classifyResult = '~';
    end
    %cell2mat(eval(deci_tree2,feature_single(recordName)));

%else
%    deci_tree = dtree_const();
%    classifyResult = cell2mat(eval(deci_tree,feature_single(recordName)));
%    save('tree.mat','deci_tree');
%end
end
%classifyResult = cell2mat(eval(t,feature_single(recordName)));
%0517Ĺġ
