function [y,score] = predPyWts(input,wt_file)

% test_mat = csvread('feat_arr_AF11.csv');
% wt_file = 'af_nonaf.h5';
% input = test_mat(:,1:150);
% y_true = test_mat(:,end);

    param_struct = h5info(wt_file);

    no_layers = size(param_struct.Groups);

    input_layer = input';
    for i=1:1:no_layers-1

        layer_name = param_struct.Groups(i).Groups.Name;

        bias_name = param_struct.Groups(i).Groups.Datasets(1).Name;
        bias_file = strcat(layer_name,'/',bias_name);
        kernel_name = param_struct.Groups(i).Groups.Datasets(2).Name;
        kernel_file = strcat(layer_name,'/',kernel_name);
        bias_wts = h5read(wt_file,bias_file);
        kernel_wts = h5read(wt_file,kernel_file);

        output_layer = (kernel_wts*input_layer) + bias_wts;
        
        if(i == no_layers-1)
            act_layer = sigmoid(output_layer);
        else
            act_layer = max(0,output_layer);
        end
        input_layer = act_layer;
    end

    score = input_layer';
    y = (input_layer >= 0.5);
    y = y';

%     tot_pos = length(find(y_true == 1));
%     tot_neg = length(find(y_true == 0));
%     
%     err = y_true - y;
%     
%     fp = length(find(err == -1));
%     fn = length(find(err == 1));
%     tp = tot_pos - fn;
%     tn = tot_neg - fp;
%     
%     fa = (2*tp)/(tp+tp+fp+fn);
%     fo = (2*tn)/(tn+tn+fp+fn);
%     
%     cf = [tp fn;fp tn];
        
end