function [xft_abs,freq] =  plot_fft(x,Fs,plotfig,colr)

if(nargin < 4)
    colr = 'g';
end
if (nargin < 3)
    plotfig = 0;
end  

if(nargin < 2)
    disp('Sampling frequency Fs missing. Using default Fs = 250 Hz');
    Fs = 250;
end

xft = fft(x);
xft_abs = abs(xft);

xft_abs = xft_abs;%/(max(xft_abs));
t = 0:1/Fs:length(x)/Fs;
no_samples = length(t);
div = no_samples/Fs;

freq = 0:1/div:length(x)/(2*div);
xft_abs = xft_abs(1:floor(length(x)/2)+1);

if(plotfig)

    set_figure([0 0 1 1])
    subplot(3,1,1)
    plot(x)
    hold on
    subplot(3,1,2)
    plot(freq,xft_abs,colr)
    hold on
end