function [mean_sig,med_sig,std_sig,signal] = iqr_param(signal)

    q = quantile(signal,[0.25 0.5 0.75]);
    iqr = q(3) - q(1);
    
    out_ll = q(1) - (1.5*iqr);
    out_ul = q(3) + (1.5*iqr);
    
    ll_inv = find(signal < out_ll);
    signal(ll_inv) = [];
    
    ul_inv = find(signal > out_ul);
    signal(ul_inv) = [];
    
    mean_sig = mean(signal);
    med_sig = median(signal);
    std_sig = std(signal);
    
    
end