function [y,max_sig] = iqr_norm(signal,frac,Fs)

    if(nargin < 3)
        Fs = 250;
    end
    if(nargin < 2)
        frac = 0.5;
    end
    
    if(length(signal) < 100)
        y = signal;
        max_sig = max(signal);
        return;
    end
    [pks,loc] = findpeaks(signal,'SortStr','descend','Minpeakdistance',(0.2*Fs));
    no_pks = ceil(frac*length(loc));
    
    pks = pks(1:min(no_pks,length(loc)));
    
    q = quantile(pks,[0.25 0.5 0.75]);
    iqr = q(3) - q(1);
    
    out_ll = q(1) - (1.5*iqr);
    out_ul = q(3) + (1.5*iqr);
    
    pks_n = pks;
    
    ll_inv = find(pks_n < out_ll);
    pks_n(ll_inv) = [];
    
    ul_inv = find(pks_n > out_ul);
    pks_n(ul_inv) = [];
    
    max_sig = max(pks_n);
    y = signal/max_sig(1);
    
    y(find(y > 1)) = 1;
    y(find(y < -1)) = -1;
    
end
