function smSig = getSmPks(signal,max_sig,min_sig)

    if(nargin < 3)
        min_sig  = min(signal);
    end
    if(nargin < 2)
        max_sig = max(signal);
    end
    
    
    sig_new = detrend(signal);
    sig_new = sig_new/max(sig_new);
    sig_new = sig_new.*sig_new;
    
    sum_win = 5;
    sig_new = [(ones(1,sum_win)*sig_new(1)) sig_new (ones(1,sum_win)*sig_new(end))];
    smSig = [];
    
    for j=sum_win+1:1:length(sig_new)-sum_win
        smSig(j-sum_win) = sum(sig_new(j-sum_win:j+sum_win));
        
    end
    
    smSig = ((smSig*(max_sig - min_sig)) + min_sig);
    smSig = smooth(smSig,20)';
    smSig = smSig - min(smSig);
    smSig = smSig/max(smSig);
    
end