function [qrs_locs,rr_ser,qrs_norm,signal2] = getQRS(signal,Fs,hf_samp)

    if(nargin < 2)
        Fs = 250;
    end
       
    Fs_new = 80;
    signal_norm = iqr_norm(signal);
    
    signal2 = resample(signal_norm,Fs_new,250);
    
    signal_pad = power2pad(signal2,11);
    [~,swd5] = swt(signal_pad,4,'db2');
    sig_len = length(signal2);
    
    %%%% Create QRS signal using db5 detail coefficients
    
    swd5(1,:) = 0;    %Use only D2 coefficient
    swd5(3:end,:) = 0;

    qrs_sig = iswt(swd5,'db5'); %Reconstruct signal using D2
    qrs_sig = qrs_sig(1:sig_len);

    qrs_sig = (smooth(qrs_sig))';
    qrs_sm = getSmPks(qrs_sig); %Get MWI wignal

    %%%% Create 2s windows to IQR-normalize qrs_sm
    
    q_win = 2*Fs_new;
    no_seg = floor(sig_len/q_win);
    qrs_norm = [];
    for ll = 1:1:no_seg+1
        st_ll = (ll-1)*q_win+1;
        fi_ll = min(ll*q_win,sig_len);

        if(st_ll >= sig_len)
            break;
        end
        qrs_t = qrs_sm(st_ll:fi_ll);

        qrs_norm = [qrs_norm iqr_norm(qrs_t,0.5,Fs_new)];
    end
    
    [~,qrs_locs_b4] = findpeaks(qrs_norm,'Minpeakheight',0.2,'Minpeakdistance',round(0.3*Fs_new),'Minpeakprominence',0.2);
    q_ul = 1;
    minpkhgt = 0.2;
    
    while((~isempty(q_ul)) && (minpkhgt >= 0.1))
                
        minpkhgt = minpkhgt - 0.05;
        qrs_diff = diff(qrs_locs_b4);

        q = quantile(qrs_diff,[0.25 0.5 0.75]);
        iqr = q(3) - q(1);

        out_ul = q(3) + (1.0*iqr);
        out_ul = min(360,out_ul);
        q_ul = find(qrs_diff > out_ul);

        qrs_locs_new = [];
        
        for q = 1:1:length(q_ul)

            q_s = qrs_locs_b4(q_ul(q));
            q_fi = qrs_locs_b4(q_ul(q)+1);

            q_d = q_fi - q_s;

            q_st = q_s + ceil(0.1*q_d);
            q_fi = q_s + ceil(0.9*q_d);

            qrs_temp = signal(q_st:q_fi);
            qrs_check = qrs_norm(q_st:q_fi);
            if(length(qrs_temp) < round(0.3*Fs_new))
                continue;
            end
            
            [~,pk1] = findpeaks(qrs_temp,'Minpeakheight',minpkhgt,'Npeaks',1);

            if(~isempty(pk1))
                
                len_rem = length(qrs_temp) - pk1;
                minpkdist = min(len_rem,round(0.3*Fs_new));

                [~,qrs_locs_p] = findpeaks(qrs_temp,'Minpeakheight',minpkhgt,'Minpeakdistance',minpkdist,'Minpeakprominence',minpkhgt);

                for qq =1:1:length(qrs_locs_p)
                    
                    ind1 = qrs_locs_p(qq);
                    q_st1 = max(1,ind1-50);
                    q_fi1 = min(ind1+20,length(qrs_check));
                    qrs_check1 = qrs_check(q_st1:q_fi1);
                    [~,qrs_locs_t] = findpeaks(qrs_check1,'Minpeakheight',0.1,'Npeaks',1,'Sortstr','descend');
                    
                    if(~isempty(qrs_locs_t))
                        qrs_locs_t = qrs_locs_t + q_st1 - 1;
                        qrs_locs_t = qrs_locs_t + q_st - 1;
                        qrs_locs_new = [qrs_locs_new qrs_locs_t];
                    end
                end
            end
        end
        qrs_locs_b4 = union(qrs_locs_b4,qrs_locs_new);

    end

    qrs_diff = diff(qrs_locs_b4);
    qntl = quantile(qrs_diff,[0.25 0.5 0.75]);
    if(qntl(3) <= round(0.5*Fs_new))
        inv_diff = find(qrs_diff <= round(0.29*Fs_new));
    else
        inv_diff = find(qrs_diff <= round(0.29*Fs_new));
    end

    for q = 1:1:length(inv_diff)
        
        ind = inv_diff(q);
        if(qrs_locs_b4(ind) >= qrs_locs_b4(ind+1))
            qrs_locs_b4(ind+1) = 0;
        else
            qrs_locs_b4(ind) = 0;
        end
    end
    qrs_locs_b4(find(qrs_locs_b4 == 0)) = [];
    
    qrs_locs_b4 = ceil(qrs_locs_b4*Fs/Fs_new);
    qrs_norm = resample(qrs_norm,Fs,Fs_new);

    qrs_locs = qrs_locs_b4;
    
    if(length(qrs_locs) <= 2)
        rr_ser = [];
        return
    end
    rr_ser = diff(qrs_locs_b4);

    if(size(rr_ser,1) > 1)
        rr_ser = rr_ser';
        qrs_locs_b4 = qrs_locs_b4';
        qrs_locs = qrs_locs_b4;
    end
    
    
    ns_ones = [0 hf_samp 0];
    ns_diff = diff(ns_ones);
    ns_beg = find(ns_diff == 1);
    ns_end = find(ns_diff == -1);
    if(~isempty(ns_end))
        ns_end = ns_end - 1;
    end
    if(~isempty(ns_beg))

        for ns = 1:1:length(ns_beg)

            st_ns = ns_beg(ns);
            fi_ns = ns_end(ns);
            qrs_norm(st_ns:fi_ns) = 0;
            
            st_diff = find(qrs_locs_b4 >= st_ns);
            fi_diff = find(qrs_locs_b4 <= fi_ns);
            rm_diff = intersect(st_diff,fi_diff);
            qrs_locs(rm_diff) = 0;
            if(~isempty(rm_diff))
               if(rm_diff(1) > 1) 
                   rm_diff = [rm_diff(1)-1 rm_diff];
               end
            end
            
            rr_ser(rm_diff) = 0;
            
        end
    end
    qrs_locs(find(qrs_locs == 0)) = [];
    rr_ser(find(rr_ser == 0)) = [];
    
    init_peaks = find(qrs_locs <= Fs);
    qrs_locs(init_peaks) = [];
    rr_ser(init_peaks) = [];

end