function [cons_loc,cons_len] = getCons(signal,value,len,exactly)

    cons_len = [];
    cons_loc = [];
    
    if(nargin < 2)
        error('Not enough input arguments')
    end
    
    [m,~] = size(signal);
    if(m > 1)
        signal = signal';
    end
    
    signal_new = zeros(1,length(signal));
    signal_new(find(signal == value)) = 1;
    
    signal_app = [0 signal_new 0];
    signal_diff = diff(signal_app);
    c_locs = [];
    k=1;
    for i=1:1:length(signal_diff)
        
        if(abs(signal_diff(i)) == 1)
            c_locs(k) = i;
            k=k+1;
        end
    end
    
    for i=1:2:length(c_locs)
        
        cons_len(floor(i/2)+1) = c_locs(i+1) - c_locs(i);
        cons_loc(floor(i/2)+1) = c_locs(i);
    end
    
    if(nargin >= 3)
        
        if(nargin == 4)
            if(exactly == 0)
                
                cons_loc = cons_loc(find(cons_len >= len));
                cons_len = cons_len(find(cons_len >= len));

            else
                cons_loc = cons_loc(find(cons_len == len));
                cons_len = cons_len(find(cons_len == len));
            end
        else
            cons_loc = cons_loc(find(cons_len == len));
            cons_len = cons_len(find(cons_len == len));
        end
    end
    
    if(m > 1)
        cons_len = cons_len';
        cons_loc = cons_loc';
    
    end
    
    
end