function [proc_signal,max_sig] = clean_ecg(signal_ecg,Fs,lf,hf)

    if(nargin < 4)
        hf = 25;
    end
    
    if(nargin < 3)
        lf = 0.5;
    end
    
    if(nargin < 2)
        Fs = 250;
    end
    
    hf_order = 1;
    lf_order = 1;
    
    sig_mod = [signal_ecg(1)*ones(1,Fs) signal_ecg signal_ecg(end)*ones(1,Fs)];
    signal_ecg = sig_mod;
    
    signal = detrend(signal_ecg); % Deterend signal
    signal_sm = (smooth(signal))'; % Smooth signal
    
    % Remove LF noise
    [xft_abs,freq] = plot_fft(signal_sm,Fs,0);
    [max_xft] = max(xft_abs);
    lfreq = find((freq <= 0.5),1,'last');
    max_lxft = max(xft_abs(1:lfreq));
    
    loop = 0;
    signal_lf = signal_sm;
    while(max_lxft > (0.4*max_xft) && (loop <= 5))
        signal_lf = butter_bidir(lf,signal_lf,Fs,lf_order,'high');
        
        [xft_abs,freq] = plot_fft(signal_lf,Fs,0);
        [max_xft] = max(xft_abs);
        lfreq = find((freq <= 0.5),1,'last');
        max_lxft = max(xft_abs(1:lfreq));
        loop = loop + 1;
        
    end
    
    % Remove HF noise
    [xft_abs,freq] = plot_fft(signal_lf,Fs,0);
    hfreq = find((freq > hf),1,'first');
    [max_xft] = max(xft_abs(1:hfreq-1));
    [max_hxft] = max(xft_abs(hfreq:end));
        
    loop = 0;
    signal_hf = signal_lf;
    while(max_hxft > (0.1*max_xft) && (loop <= 10))
    
        signal_hf = butter_bidir(hf,signal_hf,Fs,hf_order,'low');
        
        [xft_abs,freq] = plot_fft(signal_hf,Fs,0);
        hfreq = find((freq > hf),1,'first');
        [max_xft] = max(xft_abs(1:hfreq-1));
        [max_hxft] = max(xft_abs(hfreq:end));
        
        loop = loop + 1;
        
    end
    
    signal_lf = butter_bidir(lf,signal_hf,Fs,lf_order,'high');
    
    trunc_sig = signal_lf(Fs+1:end-Fs);
    signal_ms = mean_sub(trunc_sig,Fs);
    max_sig = max(signal_ms);
    
    proc_signal = signal_ms/max_sig;
    proc_signal = (smooth(proc_signal))';
end
