function classifyResult = challenge(recordName)

warning off
Fs = 250;

reducedFeat_AF = [79 145 147 149 91 67 148 ...
    146 103 80 76 115 68 78 75 55 77 150 81 66 ...
    138 127 36 90 139 44 43 88 135 45 64 69 46 ...
    47 82 57 136 100 56 83 89 102 92 65 99 87 35];
load('AfNaf.mat')

[~,ecg,fs,siginfo]=rdmat(recordName);
ecg = ecg';
sig_orig = ecg(1,:)/siginfo(1).Gain;
resamp_sig = resample(sig_orig,Fs,fs);

signal = resamp_sig;
sig_len = length(signal);

[pred_noise,signal2,hf_samp] = noise_label(signal,sig_len,Fs);

if(pred_noise == 1)
    classifyResult = '~';
else
    
    %%%% If NOT labeled as NOISE
    
    [~,rr_ser] = getQRS(signal2,Fs,hf_samp);
    
    if(length(rr_ser) < 4)
        classifyResult = '~';
        
    else
        
        hr = rr2hr(mean(rr_ser));
        rr_diff = [];
        rr_per = [];
        
        for rr=1:1:length(rr_ser)-1
            
            rr1 = rr_ser(rr);
            rr2 = rr_ser(rr+1);
            
            rr_diff(rr) = rr2 - rr1;
            rr_per(rr) = rr_diff(rr)/rr1*100;
            
        end
        
        low_lim = min(-70,min(rr_per));
        upp_lim = max(70,max(rr_per));
        mkv_edg = [[low_lim -55 -45 -35 -25 -20 -10 15 25 35 45 55 upp_lim]];
        m_mat = zeros(length(mkv_edg)-1);
        rr_d = discretize(rr_per,mkv_edg);
        rr_d = [7 rr_d];
        
        h = histcounts(rr_per,mkv_edg);
        p = h/length(rr_per);
        ent = get_entropy(p);
        
        rr_per1 = sort(rr_per);
        rr_per1 = rr_per1(2:end-1);
        rr_d1 = sort(rr_d);
        rr_d1 = rr_d1(2:end-1);
        
        sd_per = std(rr_per);
        sd_per1 = std(rr_per1);
        
        sd_rr = std(rr_d);
        sd_rr1 = std(rr_d1);
        
        for ll = 1:1:length(rr_d)-1
            p_ind = rr_d(ll);
            n_ind = rr_d(ll+1);
            
            m_mat(p_ind,n_ind) = m_mat(p_ind,n_ind) + 1;
            
        end
        
        for i=1:1:size(m_mat,1)
            if(sum(m_mat(i,:)) > 0)
                m_mat(i,:) = m_mat(i,:)/sum(m_mat(i,:));
            end
        end
        
        m_arr = reshape(m_mat,1,numel(m_mat));
        
        fv = [m_arr ent sd_per sd_per1 sd_rr sd_rr1 hr];
                
        [pred_af_dl,score_af_dl] = predPyWts(fv,'af_nonaf.h5');
        [pred_af_rf,score_af_rf] = predict(rf_mdl,fv(1,reducedFeat_AF));
        pred_af_rf = str2num(cell2mat(pred_af_rf));
        pred_af = pred_af_rf;
        compare_err = pred_af_dl - pred_af_rf;
        dl = score_af_dl;
        rf = score_af_rf(1,2);
        
        if(compare_err < 0)
            if((0.5 - dl) > (rf - 0.5))
                pred_af = pred_af_dl;
            end
        elseif(compare_err > 0)
            if((dl - 0.5) < (0.5 - rf))
                pred_af = pred_af_dl;
            end
        end
        if(pred_af == 1)
            classifyResult = 'A';
        else
            pred_on = predPyWts(fv,'on_norm.h5');
            if(pred_on == 1)
                classifyResult = 'O';
            elseif((hr <= 40) || (hr >= 100))
                classifyResult = 'O';
            else
                classifyResult = 'N';
            end
        end
    end
end
