function classifyResult = challenge(recordName)
%
% Sample entry for the 2017 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     N = normal rhythm
%                     A = AF
%                     O = other rhythm
%                     ~ = noisy recording (poor signal quality)
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2017/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
%
% Version 1.0
%
%
% Written by: Victor Manuel Jos Ochoa Abril 20 2017
%             victorjose.298@gmail.com
%



%% AF determination
DatEntrada=DatosEvaluar(recordName);

resultado = NeuralNetworkFunction(DatEntrada);
[val pos]=max(resultado);
if pos==1
    classifyResult = 'N';
else if pos==2
        classifyResult = 'A';
    else if pos==3
            classifyResult = 'O';
        else if pos==4
              classifyResult = '~';  
            end
        end
    end
end
 if  DatEntrada(7)>0.4  && DatEntrada(6)>5 
        classifyResult = '~';
 end
end
%% You can add the determination rules for other rhythm and noisy recordings here

