function [y1] = NeuralNetworkFunction(x1)
%MYNEURALNETWORKFUNCTION neural network simulation function.
%
% Generated by Neural Network Toolbox function genFunction, 20-Apr-2017 13:24:59.
% 
% [y1] = myNeuralNetworkFunction(x1) takes these arguments:
%   x = 8xQ matrix, input #1
% and returns:
%   y = 4xQ matrix, output #1
% where Q is the number of samples.

%#ok<*RPMT0>

  % ===== NEURAL NETWORK CONSTANTS =====
  
  % Input 1
  x1_step1_xoffset = [0.483776895118448;-18014.383735;0.00090215339453543;0;-97.6819144248875;-130;0;0];
  x1_step1_gain = [4.50572811059316;0.000106043744721992;23.1968779796192;0.0362620364372789;0.00951266326712887;0.00930232558139535;0.133761903031549;0.0142857142857143];
  x1_step1_ymin = -1;
  
  % Layer 1
  b1 = [-2.5143915437559206;-2.1765428805960507;2.7277219668542445;-2.3807486989746551;-2.3597176041391736;-2.0330237980658223;-2.3654116333320996;1.3039656787412273;-1.6801692771218522;1.5593319723181116;2.0301205002166736;-0.67137225387466026;2.7478185541507822;1.768925692197246;1.591603693833197;2.3078833544568691;1.1660840796481309;-1.5125044018368992;-0.18129597049386589;-0.92503886974770233;1.0238036668917627;-2.9633865425288786;0.013871493403815841;-0.18049526717056719;-0.79820618085753958;0.63743335479750307;0.063384863744069625;-0.11562593649464306;0.79446621797217076;0.55056160177487523;-0.41776888328167294;-0.68199215658086321;0.46455481646274843;0.37364095914673306;0.27731328936557709;-0.031076958342929575;-2.1895732982213509;1.5428036146272026;0.42326818869498711;0.44061196788924401;0.31940035923965898;-1.6654735645799366;1.3287317334575748;1.3727028270251491;-1.7711078388582113;1.3840937937459195;1.1185449276463999;1.4728817500220106;-1.2214808513730497;-0.81572007155568405;2.3498983483602016;-1.9367987484220039;-1.6593231534431228;-1.9161317457285252;-2.1270988036598668;-1.6369351524868627;-3.4059095593762918;1.9610586669372474;-6.7537996617206026;-2.5130004707693412];
  IW1_1 = [0.19042673808462454 0.9248530062018695 0.76635924335898409 1.3145737854593142 0.32496161727061318 -1.0453826536369113 -0.3432557521462018 0.98910988696866975;0.94249983632281253 -0.86138389905345514 0.22521471629380183 0.26331894036548381 -1.3428158061034743 -1.1566493562453268 -0.71782592872264561 -0.74655939121069592;-0.59300094106357015 -0.37620174141348295 -0.47779962700405332 -1.1230696729456664 0.72996599801533701 -0.33853936724795897 0.1867127139847016 -0.11758984397604133;0.06869903776010032 0.60358023149640316 0.75265478263782026 -0.38779964545202772 0.78485967104707921 -0.85484065415682398 1.2188504625908614 -0.87979710415069445;0.037549401526201565 0.59383915521406549 0.11000122600569298 -1.0100389182315384 0.78913500750771404 -0.98013654570897135 1.1789022661447037 -0.41053065275435696;0.056185563680727718 0.034775786095889986 0.25486977766909141 0.62990973851851939 1.2643756858633257 1.3949865618667499 0.6056505035624502 0.82643134968320975;0.50653607436314341 0.59097843885781731 -0.19011405068383003 -0.99547171071380991 0.34449244005354895 0.11280136184893724 1.4991850946600094 -0.13134189100292759;-0.67578256523298985 0.42721523916671167 -0.91384805690883419 0.034152917022056972 1.5150658538883848 -0.20066270311254703 -0.9428755584248073 1.2178835986936918;0.11319965460597184 -1.3758480028068538 1.3079907873068037 0.66440983578110346 0.74418090371217627 -1.2578036554027672 -0.13025797565411174 0.25131571825914611;-0.46967960515322588 -0.35084733764410869 0.77896325990183723 -0.092465755350171694 -1.144435889060466 1.2085188438419399 -1.1780790972591435 -0.33571960256606126;-0.50726481258938727 0.55111678470233072 1.7084175033201998 -0.89931493252557537 -0.82979570680011694 0.18967892209596707 0.8992520527236838 1.1962728958599196;0.39957582880827652 -1.8407364947502118 -1.1599504115953045 -0.41418378826100477 2.1759625061164285 0.023016627031402156 -0.4047483142971473 -0.40705599618946153;-1.341729828411486 0.18618402585778518 0.5392154460238674 -0.12287927971725521 -0.038935256897893469 -2.0083904329780786 0.912403850944145 1.7262644453009455;-1.2740307774146047 1.2230848401147552 0.09150737724025651 -1.0009632902347494 -0.91171457545441981 -1.1450473648118622 0.75642587702231434 1.7745937041228461;-1.6946447167654146 0.26827613058644506 -0.73599377830476742 1.0713340024354201 -0.93026928248817053 0.86343403845956357 -0.61416237791456363 -0.7409629678640377;-0.50801218069967602 -1.3163040799564989 1.2518846419408287 0.44685123731824078 -1.7311432475644055 -4.4446529082027526 -1.1594322945675479 -2.009832598030008;-0.73903636121950556 -0.9153271685790888 -0.72832173440248149 -0.67659793123900802 -0.59486647752652266 1.1378304393590088 -0.61318408710021377 -0.70212965128669669;0.011386190984362204 1.9117494254835723 -1.2341855425822725 0.66174575558941451 0.58457995599314405 2.8397772347309704 0.64838752378061781 -0.75487158537598309;1.5020974278371928 0.69965631402686135 -1.6477243654122904 -0.026171382492533927 1.6192132926911054 -1.1090784592316953 -0.010080624159255404 1.2784786011193827;0.19907060963340958 -0.62717371319456905 -1.008309899916046 0.59940174953013792 0.84626225176933767 -1.3762830568478452 0.49195617214185261 0.60597921799571841;-0.18530741865702893 -0.0012521038168815946 0.57888381960274471 -0.12744226832769384 0.3679183695272088 -2.925466192936037 0.090189242714932893 3.0034233793845533;-0.13583081749178552 0.0037244460011427172 1.2460825091353851 0.97804421682408393 -0.085873723842651545 -0.52383876639137739 -4.3192053387555367 -0.98081905502302758;0.09244733808501325 -0.053916797769340122 -0.60331993399480077 2.5867848276830405 1.6872772436789818 2.1537388431028885 -0.65598979481923381 0.35925272142917758;1.9759670441615045 0.074540020711784671 -0.22892034440280926 0.7420871861295828 2.2170858044285704 0.34980027771891775 -0.83378417164417129 0.35918841229631943;-0.76818558679986204 1.3982754774803479 0.75564574885144653 0.72061972614216685 0.014575636446206089 -1.7638812964010837 -1.7857976001534166 3.9545282363212331;-0.17612749194137958 -1.8622095660538316 1.5524467115140101 -0.44154490976153654 -1.2783163384152723 -3.5118893432669647 -1.4113021305209263 -1.2932470344278293;1.2375164771823368 -1.0183779304470617 -0.69475683210835781 -0.59793489487187323 -0.62112709780583519 0.27167138322906548 -1.4411565732526166 0.47684676839615009;-2.0418238811987415 1.0756045403377938 1.3449831263465064 0.28037028744331782 0.26763647636791754 0.60977712812923091 0.54275925873363151 0.74392122190531185;-1.3175555043098466 -0.085563990208294388 -0.79465702147699213 0.74714756929897053 0.38652691625635416 1.5057847385681065 2.2871942059157995 -1.7808207793415167;-0.4302828911703343 0.56782603402051313 -0.43395994374553942 -0.51465415940298787 1.8122687171193088 -0.73327258996480948 1.7263302836370253 2.0960874706650587;-0.28229247013982506 1.483131524029073 -1.2862477334451285 0.29500398712200965 0.70451865071019248 -0.78585843323874405 -0.96200635722582872 -3.8247601403420872;-0.62496463452922002 -0.28707268570888095 0.54196019560667752 0.72565125891107596 -1.4716064351694456 -0.18295329923509404 1.1515088426120783 1.0239589635474506;-0.017529976745941114 -0.51369758434337587 0.22239796215329938 -0.52875340222689882 0.66724319434392088 -2.4508793378857585 1.5597735381651925 1.6115778269638963;0.14360017301014089 0.46833178512452228 2.320883220721651 -0.42089295578069924 0.44257341799930677 -0.21351828022306668 -0.68569789225495692 2.1573383433553897;0.79775120834589308 0.11246817081932878 0.44566310960721878 -0.8256211092000425 -0.96878577687915235 0.42899157966461959 -0.20753707393168694 -1.3272620952590675;-0.75008894533106807 1.3583924635858393 1.8441665862254435 0.68914624716712092 1.8980435230006938 1.929490788063343 -0.18244200437133659 -1.1435487503766741;-0.1705601591541708 -0.67317455772751278 -1.0946952573808428 0.71975645667588706 1.4323776571620892 0.74599768128898347 -1.5916429428676115 -1.0988966324454219;0.30785305047712574 -0.53298285274161317 0.31668520149247498 -0.88309214648439516 0.52444946019529848 2.5901128775885947 4.769977674644319 -2.7357192418188654;1.6430724579714795 2.8664783836540875 0.41247299008536981 0.60809353838540936 0.37535387429126771 -0.40375195733345115 -0.4323323427882908 0.22526109153183813;0.37070933923094529 0.64324901162098069 -0.14615293727282261 0.61444230325940241 -1.2164579539506934 0.57955763388648318 -1.2020172127396973 -1.5977689645382294;0.83261192290345376 1.2388014638672817 -0.85894293586663828 0.33927806352647388 0.98573056485055754 1.0752497537642971 2.3234479382051201 0.27161067897152869;0.22092655597901045 -0.7862302818475938 0.80088280857048866 -0.20893057904133691 0.033751928901740523 0.96668819741224565 -1.4060516228856772 1.7355813691995516;1.0571767705855921 -1.1917994377284944 0.51211533644879681 0.83379702996572946 0.16088192146509875 0.44536731927322198 2.0023722453510691 -0.079439098665699259;0.31802695266374464 -1.664685535130517 -1.2564090524211049 0.80155222982207064 0.96598496358548691 -1.5710591947930406 0.87022777070349777 -1.4176976623507191;0.0343575245233812 0.23769479087744164 -0.0081701447045524137 -0.0053910379337906589 0.91914713906861911 4.1372547321521616 0.75876897038731939 2.4339507770133104;0.3021000008621525 -0.89924517932571868 1.1438606629768473 -1.3624721425988657 0.14616464575444105 0.25319287918852623 0.14357003343576902 1.4801650728958853;1.308977377956781 -0.8873403537295752 -0.18729137495980219 0.50620048725590761 0.3689906996858241 0.38675479186650896 -1.0795321531225206 -0.82967575631892232;1.3677645006988204 1.3272891927367272 0.24760023632682354 -0.3196062585769327 0.83803592982353126 1.148826541558603 -1.0083563476423916 -0.86392571363406678;-1.6252910393701805 -1.3507646673992761 0.49222229535083512 -0.33537825500328811 -0.19459932555535858 0.89327065634858716 -0.24506161818440714 -0.10182789716464026;0.078136037126173993 -0.67418643042807547 -1.455478706593422 -0.27849331981720366 2.5283112516437223 0.28240380005617033 1.9929644383668121 -2.3712076317177204;1.2397489653159206 -0.48606012785144187 0.66519996143672078 1.1260182948761974 0.01236676046396365 -3.5680723358582336 -0.83576914104180167 -1.1774325730464958;-1.0208547957184304 -0.21600738476526696 1.1304313294285493 -2.1928029518918262 -0.72769238817521242 0.77553200540558986 0.087907731307663661 -1.7907234866545976;-0.59488620357506383 -1.2343022812669353 0.97879379607324157 0.21629245974678274 0.28924218128903861 0.56197937400133247 -0.44029028250011076 0.84187343215910071;-0.8497665338847884 -0.8823256615804036 1.3148969260404559 -0.034791631623517429 0.28074126591557091 1.2863227247348099 0.76225616380957983 0.21431179012933893;-1.286614445984346 -0.17228754050320039 -0.11709777287796633 -0.48039616519351241 1.0622469988010621 0.48976906175634116 0.79644458322741418 -1.0309317101691853;-0.85571946024419399 -0.86289556881852147 0.91328212370099149 0.075319227582891099 -0.45265540215921979 -1.3308350861237812 -0.27784748622131367 -1.1984589669062331;0.019452882313661823 0.075184805878672656 2.1227396412151895 -0.98696026868764564 0.24487406974567105 0.098972851783520222 -4.0729856426034337 1.2674197916135432;-0.25143275042529245 1.6041124394168655 0.76155540390141496 0.77475716825498198 -0.49524380903519882 0.18176911443464538 -0.33080356743572581 -1.0417035298530646;-0.0096053121640288716 -0.49943959157869189 -0.22618037883476885 -0.83900824415170072 0.79713195320607788 -1.0251547094356552 -5.3395354867839258 1.1278882084912814;-1.0487331079826752 -1.2318461712750866 0.11278588279757111 0.70005074244311993 -0.37573837397032156 -1.1244876634679264 -0.46198528447524789 -1.3640161332002105];
  
  % Layer 2
  b2 = [-0.15566023558232278;-0.23471980576177168;0.18298323595338817;-0.088527707619174639];
  LW2_1 = [-0.59376318714466425 -0.58390119590240119 -0.33795847830932135 0.13131119737036107 -0.7519207569378541 -0.28442209721268646 0.48730215737199478 -0.78419333488467358 0.82092500924731138 0.42466723593615457 -1.165573595947933 0.89779817518717564 1.8119080396555098 0.22221607369717555 0.7744165198524694 2.301922003240664 0.60416087913113048 0.0088395413907078058 1.686633663508196 0.35943044364417359 -1.4073612854158359 2.7192671059634246 -1.5977823624551373 -0.93912044628467128 1.3183530206249245 -1.2305341368697755 0.19262726845132316 0.032638797164122137 2.0530708013883006 -1.6840453022415189 1.4244628029663788 0.65352606237277089 -1.6734631006809608 -1.4577618795266434 -0.12377936947367417 -1.2095940586521681 1.2554882066764468 2.7830408229255843 0.48860560452355045 1.3012194686217275 1.7674602467103493 1.490146983562129 0.50228162333332982 -0.070525170172858032 2.045312409577448 0.85472423445631729 0.056919910248869575 1.0050622963045512 0.061267056240172334 -2.691737507503746 0.56765767027608016 -1.4298561750292262 -0.9468892829775073 0.5984332063706429 0.95720221745985612 -0.38878682615355664 2.9336496996219803 -0.32180890939086754 3.8147413454377892 1.1932810032839363;-0.67233429021800839 -0.046648523493126572 0.030004130268859383 -0.18845495800292211 0.32648059464057289 -0.0019689198478830463 0.22097024835991241 0.67173438824148068 0.17569091191336605 -0.29237588144020143 0.25983476657327242 0.41339165729500893 -0.38889001416242513 0.9143834331146935 -0.0609332199131657 -1.8730586831608806 -0.79373581027073536 0.72823185030165893 -0.41790135866455586 -0.59519958801645245 0.3366340517573404 -0.1159927036562913 0.40112454105490786 0.057223734781700494 0.18967565199643757 1.51785724711503 0.19193134034725942 -0.70828047503771763 -0.30364992595211937 -0.48497828361084805 0.10871117751599409 0.22275747426901951 -0.06855712069810016 0.18107371867083491 -0.75028556862860729 0.069433586832186617 0.45160850287784488 -0.030698724733825098 0.23894842843912406 -0.043660167249803691 -0.050383450512874503 -0.44358619536365518 0.92477319570813676 -0.61834471673913138 -0.83150415917062515 -0.093673681974927439 0.0048060803931236021 -0.39823052751064436 -0.59052024670505776 0.16805416465742543 -1.0435213295878316 0.40479944695743492 -0.017914233070338667 -0.12782403566526246 -0.70118929407559871 -0.836898426192209 -0.5221235739671608 -0.62457730785159293 0.19708791034206022 0.24855774137512676;0.99834489767127754 0.59632197031580292 -0.97013818732898094 0.46354560046796495 -0.13636083195769413 -0.23134308235745876 -0.28741360428016449 -0.69184012273118523 -0.42284305454447674 -0.019145176143624255 0.50608194658868766 -1.4028780431158772 -1.3498654536430299 -1.2011521067941884 -0.77174703010392209 -0.36133967469615541 0.51412560750680492 -0.76407838768495717 -1.0775009096317971 0.61506324871898288 1.0355323444391717 -2.8660892221566909 1.1942369504371171 0.7579484176174196 -1.5407313775109255 -0.48586496360961462 0.67070395043775743 0.070120786042305289 -1.7252932734722912 2.2860936242274406 -1.4858420837587305 -0.6470239721868638 1.9739738907940725 0.87976542272069125 0.20936865241281449 1.15392013882308 -1.9234646089058698 -2.9002911202720636 -0.63219718863090579 -0.47408616190765812 -2.0632011820026634 -0.99962462035697419 -1.6396636042441364 0.87027075673858101 -0.96008438004011198 -1.1493317802455945 -0.30473397523382595 -0.48845631639352732 0.70628164188321452 2.5786649085173114 0.70819372017697102 1.1700207986840292 0.49705660934437373 0.10064389135481809 0.63841316635052525 -0.1404036429043129 -1.5254060848096054 0.70203540029413547 -4.6683273741087135 -0.84727952379335902;0.60003643595891476 0.083907104723004569 0.28339814153691556 -0.50971999959028969 -0.090805942095477127 -0.72198843394591383 0.85093598912684965 0.90058573091924543 0.74265760118312452 0.79708206270690241 0.58158948796034138 0.013010861404980929 -0.042500908721881864 -0.017864193088372886 0.019386749304757121 -0.044792335999313593 -0.8971587248153553 -0.010089154720273349 -0.37637612892522282 -0.40328203676740332 0.061397956302030696 0.073428185359127734 -0.039071780471548891 0.10831406037524874 0.0044092490287520915 0.078566971530282539 -0.00021987586608513549 0.85934437485401693 -0.27128123152149058 -0.28893090721592729 -0.12811584249714622 0.52396699680277925 -0.23055631834140061 0.49876512884361801 0.31168936264180003 -0.0090176714787510472 0.38996789253408909 0.23591666587595045 -0.039409638122187278 -0.62221566933706862 0.19189174457329661 -0.40797183073547916 0.13126942657500718 -0.031030403158776802 -0.038133879312253788 0.1476365698407488 0.84028959164972383 -0.2160621934290291 -0.14085456814198927 -0.050861161404738259 -0.15508303299645382 -0.20326877844979316 -0.55906460870944941 0.51512412679342634 0.27806655672883973 -0.83461838745122907 -0.78517162668672091 0.054154958078983226 0.70924054015380833 0.83272218451036606];
  
  % Output 1
  y1_step1_ymin = -1;
  y1_step1_gain = [2;2;2;2];
  y1_step1_xoffset = [0;0;0;0];
  
  % ===== SIMULATION ========
  
  % Dimensions
  Q = size(x1,2); % samples
  
  % Input 1
  xp1 = mapminmax_apply(x1,x1_step1_gain,x1_step1_xoffset,x1_step1_ymin);
  
  % Layer 1
  a1 = tansig_apply(repmat(b1,1,Q) + IW1_1*xp1);
  
  % Layer 2
  a2 = repmat(b2,1,Q) + LW2_1*a1;
  
  % Output 1
  y1 = mapminmax_reverse(a2,y1_step1_gain,y1_step1_xoffset,y1_step1_ymin);
end

% ===== MODULE FUNCTIONS ========

% Map Minimum and Maximum Input Processing Function
function y = mapminmax_apply(x,settings_gain,settings_xoffset,settings_ymin)
  y = bsxfun(@minus,x,settings_xoffset);
  y = bsxfun(@times,y,settings_gain);
  y = bsxfun(@plus,y,settings_ymin);
end

% Sigmoid Symmetric Transfer Function
function a = tansig_apply(n)
  a = 2 ./ (1 + exp(-2*n)) - 1;
end

% Map Minimum and Maximum Output Reverse-Processing Function
function x = mapminmax_reverse(y,settings_gain,settings_xoffset,settings_ymin)
  x = bsxfun(@minus,y,settings_ymin);
  x = bsxfun(@rdivide,x,settings_gain);
  x = bsxfun(@plus,x,settings_xoffset);
end
