function DatEntrada = ExtraerDatos( recordName )
%Esta funcin nos permite extraer ocho factores de la seal
%electrocardiogrfica: 
%   *Densidad Espectral de 0.5 a 20hz.
%   *Entropa.
%   *Promedio de frecuencia en el espectro de Fourier 0 a 20Hz.
%   *Desviacin estndar en la magnitud de los picos de la onda R.
%   *Promedio en la magnitud de los picos de la onda R.
%   *AFEv.
%   *Desviacin estndar entre la diferencia de tiempos.
%   *Frecuencia del ECG. 


    DatEntrada=zeros(8,1);
    [tm,ecg2,fs,siginfo]=rdmat(recordName);
    [QRS,sign,en_thres,bpfecg]=qrs_detect2(ecg2',0.4,0.8,fs);
    FFT=fft(ecg2);
    FFTAbs = abs(FFT/length(ecg2));
    FFTpos = FFTAbs(1:length(ecg2)/2+1);
    FFTpos(2:end-1) = 2*FFTpos(2:end-1);
    posfrec1=round(0.5*2*length(FFTpos)/fs)+1;
    posfrec2=round(20*2*length(FFTpos)/fs)+1;
    %   Densidad Espectral de 0.5 a 20hz
    DatEntrada(1) = sum(FFTpos(posfrec1:posfrec2))/sum(FFTpos);
    %   Entropia
    DatEntrada(2) = wentropy(ecg2, 'sure', 1);
    % Promedio de frecuencia en el espectro de Fourier 0 a 20Hz
    DatEntrada(3) = mean(FFTpos(1:posfrec2));
    if length(QRS)>4
        % Desviacin estndar en la magnitud de los picos de la onda R
        DatEntrada(4) = std(bpfecg(QRS));
        % Promedio en la magnitud de los picos de la onda R
        DatEntrada(5) = mean(bpfecg(QRS));
        RR=diff(QRS')/fs; %tiempo entre ondas P-1 y P
        % AFEv
        DatEntrada(6) = comput_AFEv(RR);
        % Desviacin estndar entre la diferencia de tiempos
        DatEntrada(7) = std(RR);
        % Frecuencia del ECG 
        DatEntrada(8) = 60*length(QRS)*fs/length(tm);
        
    end 
end

