function classifyResult = challenge(recordName)
%
% Sample entry for the 2017 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     N = normal rhythm
%                     A = AF
%                     O = other rhythm
%                     ~ = noisy recording (poor signal quality)
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2017/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
%
% Version 1.0
%
%
% Written by: Chengyu Liu and Qiao Li January 20 2017
%             chengyu.liu@emory.edu  qiao.li@emory.edu
%
% Last modified by:
%      Ruhallah Amandi(ruhallah1020@gmail.com), Mohammad Farhadi, A.J. Zarrin
%      

    classifyResult = 'N'; % default output normal rhythm
    recordName
    load Precomputed2.mat
%% AF determination
    [tm,ecg,fs,siginfo]=rdmat(recordName);
    [QRS,sign,en_thres] = qrs_detect2(ecg',0.25,0.6,fs);

    RR=diff(QRS')/fs;
    try
        AFEv = comput_AFEv(RR);
    catch
        AFEv = 0;
    end
    RR1=zeros(1,180)+0.1;
    RR1(1,1:length(RR))=RR';
    RR=RR1;
    if(isempty(sign))
        sign=0;
    end
    if(isempty(QRS))
        QRS=0;
    end
     sig=[(AFEv>1) sign length(QRS) min(RR) max(RR) mean(RR) median(RR) std(RR) var(RR) corrcoef(RR) mode(RR) max(xcorr(RR))/100 min(xcorr(RR)) median(xcorr(RR))/100 mean(xcorr(RR))/100 entropy(ecg)/100  ];    

    output=predict(Mdl,sig);
    
    if(output==1)
        classifyResult = 'N';
    elseif(output==2)
        classifyResult = 'A';
    elseif(output==3)
        classifyResult = 'O';    
    else
        classifyResult = '~';
    end
end


%% You can add the determination rules for other rhythm and noisy recordings here

