function [Power_p,freq_p,rr_var]=AF_analyse(Input_ECG,Fs);
Input_ECG=resample(Input_ECG,256,300);
val=Input_ECG;
val=(val-1024)/200;
    flag=0;
    if(flag==0)
        x1=val(1,1:end);
 else
    x1=-val(1,1:end);
     end

fs = Fs;              % Sampling rate
N = length (x1);       % Signal length
t = [0:N-1]/fs;        % time index


%xdum for P wave analysis
xdum=x1;
%Cancellation DC drift and normalization

x1 = x1 - mean (x1 );    % cancel DC conponents
mag_x1=max(abs(x1));
x1 = x1/ max( abs(x1 )); % normalize to one

%Low Pass Filtering
% LPF (1-z^-6)^2/(1-z^-1)^2
b=[1 0 0 0 0 0 -2 0 0 0 0 0 1];
a=[1 -2 1];

h_LP=filter(b,a,[1 zeros(1,12)]); % transfer function of LPF
x2 = conv (x1 ,h_LP);
%x2 = x2 (6+[1: N]); %cancle delay
x2 = x2/ max( abs(x2 )); % normalize , for convenience .

%High Pass Filtering
% HPF = Allpass-(Lowpass) = z^-16-[(1-z^-32)/(1-z^-1)]
b = [-1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32 -32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1];
a = [1 -1];

h_HP=filter(b,a,[1 zeros(1,32)]); % impulse response iof HPF

x3 = conv (x2 ,h_HP);
%x3 = x3 (16+[1: N]); %cancle delay
x3 = x3/ max( abs(x3 ));


%Derivative Filter

% Make impulse response
h = [-1 -2 0 2 1]/8;
% Apply filter
x4 = conv (x3 ,h);
x4 = x4 (2+[1: N]);
x4 = x4/ max( abs(x4 ));

%Squaring
x5 = x4 .^2;
x5 = x5/ max( abs(x5 ));


%Moving Window Integration

% Make impulse response
h = ones (1 ,31)/31;
Delay = 15; % Delay in samples

% Apply filter
x6 = conv (x5 ,h);
x6 = x6 (15+[1: N]);
x6 = x6/ max( abs(x6 ));

%Find QRS Points Which it is different than Pan-Tompkins algorithm

% figure(7)
% subplot(2,1,1)
max_h = max(x6);
thresh = mean (x6 );
poss_reg =(x6>thresh*max_h);

left = find(diff([0 poss_reg])==1);
right = find(diff([poss_reg 0])==-1);

left=left-(6+16);  % cancle delay because of LP and HP
right=right-(6+16);% cancle delay because of LP and HP

R_value=zeros(1,length(left));
S_value=zeros(1,length(left));
Q_value=zeros(1,length(left));
for i=1:length(left)
    if(left(i)<1)
       left(i)=1;
    end
    if(right(i)<1)
       right(i)=1;
    end
    
    [R_value(i),R_loc(i)] = max( x1(left(i):right(i)) );
        R_loc(i) = R_loc(i)-1+left(i); % add offset 

        [Q_value(i),Q_loc(i)] = min( x1(left(i):R_loc(i)) );
        Q_loc(i) = Q_loc(i)-1+left(i); % add offset

        [S_value(i),S_loc(i)] = min( x1(R_loc(i):right(i)) );
        S_loc(i) = S_loc(i)-1+R_loc(i); % add offset

end
rr_var=abs(diff(R_loc));
rr_var=kurtosis(rr_var);
%%
%Updated T wave algorithm
% R_value(5);
% S_value(5);
uplimit=(sum(R_value(1,:)))/length(R_value); % avg value of maxima
lowlimit=(sum(S_value(1,:)))/length(S_value); %avg value of minima
T_thresh=0.15*abs(uplimit-lowlimit); %threshold for detection of T
 T_loc=ones(1,length(left)-1);
 T_limit_left=zeros(1,length(left)-1);
 T_limit_right=zeros(1,length(left)-1);
 T_loc_left=ones(1,length(left)-1);
 T_loc_right=ones(1,length(left)-1);
 T_further_right=ones(1,length(left)-1);
 T_further_right_value=ones(1,length(left)-1);
 T_inv=zeros(1,length(left)-1);
% 
 for z=2:length(left)-1
     T_inv(z)=0; %T wave assumed to be not inverted
     len=floor(0.85*(Q_loc(z+1)-right(z)));
     xt1=x2(right(z):right(z)+len);
     [T_value(z) T_loc(z)] = (max( xt1));
     T_loc(z)=T_loc(z)-1+right(z);
     T_value(z)=x1(T_loc(z)); 
 end  
%%finding P Waves 
P_loc=ones(1,length(left)-1);
P_loc_left=ones(1,length(left)-1);
P_loc_right=ones(1,length(left)-1);
P_limit_left=zeros(1,length(left)-1);
P_limit_right=zeros(1,length(left)-1);
P_value_left=ones(1,length(left)-1);
P_value_right=ones(1,length(left)-1);
baseline_amp=zeros(1,length(left)-1);
amp_p=zeros(1,length(left)-1);
width_p=zeros(1,length(left)-1);
count_p=ones(1,length(left)-1);
T_inv_rt_val=zeros(1,length(left)-1);
T_inv_rt_loc=zeros(1,length(left)-1);
if(length(left)>1)
for z=1:length(left)-1
    len1=floor(0.3*(Q_loc(z+1)-right(z)));% 30 % of the region taken for P estimation
    %len2=Q_loc(z+1)-T_loc(z); %taking length from T to next Q
    len= len1;%min(len1,len2);%taking whichever is minimum for finding P 
    xp1=x2(Q_loc(z+1)-len:Q_loc(z+1));
%     figure(20+z)
%     plot(xp1)
    if(numel(xp1)>5) 
        [P_value(z),P_loc(z)] = (max( xp1));
        P_loc(z)=P_loc(z)-1+Q_loc(z+1)-len-6;
        P_value(z)=x1(P_loc(z));
        
        P_limit_left(z)=floor(P_loc(z)-(55/1000)*fs);  %locations of left of P
        P_limit_right(z)=floor(P_loc(z)+(55/1000)*fs);  %locations of right of P
        
        
        [P_value_left(z) P_loc_left(z)]=min(x1(P_limit_left(z):P_loc(z)));
        [P_value_right(z) P_loc_right(z)]=min(x1(P_loc(z):P_limit_right(z)));
        
        P_loc_left(z)=P_loc_left(z)+P_limit_left(z);%adding offset
        P_loc_right(z)=P_loc_right(z)+P_loc(z);%adding offset
        
        [P_value(z) P_loc(z)] = max(x1(P_loc_left(z):P_loc_right(z)));
        P_loc(z)=P_loc(z)+P_loc_left(z)-1;
        P_value(z)=x1(P_loc(z));
        
        baseline_amp(z)=sum(x1(P_loc_left(z))+x1(P_loc_right(z)))/2; %calc. baseline of p
        amp_p(z)=abs(P_value(z)-baseline_amp(z)); %amplitude of p waves
        
       width_p(z)=abs(P_loc_right(z)-P_loc_left(z));%width of p waves
%         
% plot(x4(P_loc_left(z):P_loc_right(z)))
%        hold on
    end
if(z==1)
Power_p=0;freq_p=0;
end

[Power_p_loc,Power_freq_loc]=psd(x4(P_loc_left(z):P_loc_right(z)));
Power_p((length(Power_p)+1):(length(Power_p)+length(Power_p_loc)))= Power_p_loc;
freq_p((length(Power_p)+1):(length(Power_p)+length(Power_p_loc)))=Power_freq_loc;


   
end
else
Power_p=0;
freq_p=0;
rr_var=0;
end
end

