function [ ST, TP ] = preproST_TP( ecg, QRS, fs  )
%*******************  preproST_TP *****************************%  
% Funcion que nos devuelve el intervalo ST (C) y TP(P) de una seal ECG
% *************************************************************%
% Pasamos de fs a tiempo y cogemos las muesras detras del pico R detectado
% dif_QRS = round(mean(diff(QRS)));
dif_QRS = round(diff(QRS));
% Partimos el intervalo en 2 (post-pre R)
int_ST = round(dif_QRS/2);
int_TP = dif_QRS;
samp_ST = fs * (100*10^(-3)); % 100 ms despues de R para empezar ST
samp_TP = fs * (100*10^(-3)); % 100 ms antes de R para finalizar TP
ST_pos = cell(length(dif_QRS),1);
TP_pos = cell(length(dif_QRS),1);
ST_i = cell(length(dif_QRS),1);
TP_i = cell(length(dif_QRS),1);
for i = 1:length(dif_QRS)
    ST_pos{i} = samp_ST:1:int_ST(i);
    TP_pos{i} = int_ST(i):1:(int_TP(i)-samp_TP);
end

for j = 1:length(ST_pos);
  ST_i{j,1} =  QRS(j) + ST_pos{j,1};
end
for j = 1:length(TP_pos);
  TP_i{j,1} = QRS(j) + TP_pos{j,1};
end
% Concatenamos en un solo vector
clear C;
C = cell2mat(ST_i');
clear P;
P = cell2mat(TP_i');
P_pos = P < length(ecg);
C_pos = C < length(ecg);
ST = P(P_pos);
TP = C(C_pos);
end

